/*******************************************************
 Author:					Manfred Langemann
 mailto:					Manfred.Langemann t t-online.de
 Begin of project:			04.01.2008
 Latest version generated:	11.01.2010
 Filename:					3SlavesSlaveMain.c
 Description:    			Main routine for testing
 							3SlavesSlaveMain.c
 ********************************************************/
#include <stdio.h>
#include <avr/interrupt.h>

#include "General.h"
#include "RS232.h"
#include "Delay.h"
#include "TWI_Slave.h"
/*
** Define LED Port
*/
#define LED_PORT 		PORTC	// Port C output
#define LED_PORT_DDR 	DDRC	// Port C data direction 
/*
** This main programm demonstrates how to use the 
** implemented TWI slave functions. These are:
**	TWIS_Init
**	TWIS_ReadAck
**	TWIS_ReadNack
**	TWIS_Write
**	TWIS_Stop
**	TWIS_ResonseRequired
**
** Connect the two TWI lines properly (don't forget to also
** connect GND between Master and Slave!)
**
** Used uC for Slave is ATMega8
*/
int main (void)
	{
	uint8_t		i=0;
	uint8_t		byte[8];
	uint8_t		TWIS_ResonseType;

	uint8_t		SlaveAddress1 = 15;
//	uint8_t		SlaveAddress2 = 16;	// Use this statement for the second Slave Controler
/*
** Set LED Ports to output
** Note: For ATmega8 Port C only the Pins 0 to 5 are 
** freely available (Pin C6=Reset, Pin C7 not available)
*/
	LED_PORT_DDR = 0b00111111;
/*
** Clear any interrupt
*/
	cli ();
/*
** Wait 1 second for POR
*/
	Delay_ms (500);
/*
** Initiate RS232
*/
	RS232_Init ();
	printf ("Hello world...\n");
/*
** Start TWI Slave with address 15 and bitrate of 100000 Hz
*/
	TWIS_Init (SlaveAddress1, 100000);

	while (1)
		{
/*
** Check wether something is to do for the TWI slave interface
*/
		if (TWIS_ResonseRequired (&TWIS_ResonseType))
			{
			switch (TWIS_ResonseType)
				{
/*
** Slave is requests to read bytes from the master.
** It is expliciltely assumed, that the master sends 8 bytes
*/
				case TWIS_ReadBytes:
					for (i=0;i<7;i++)
						{
						byte[i] = TWIS_ReadAck ();
						printf ("Byte read: %d\n",byte[i]);
						}
					byte[7] = TWIS_ReadNack ();
					printf ("Byte read: %d\n",byte[7]);
					TWIS_Stop ();
					break;
				}
			}
/*
** Use the first byte received from the Master to set the 
** Port C0 to Port C5.
*/
		LED_PORT = byte[0];
/*
** Do something else, e.g.
*/
		i++;
		}
	return 0;
	}
