#!/usr/bin/env python
import yaml
from pprint import pprint
from argparse import ArgumentParser


class Dings:
    def __init__(self, model: str):
        with open(model, 'r') as ifh:
            self.commands = yaml.safe_load(ifh)['commands']


def main():
    parser = ArgumentParser(description='bla bla bla')
    parser.add_argument('--model', '-m', type=str, required=True,
                        help='the model to load')
    args = parser.parse_args()
    
    dings = Dings(args.model)
    pprint(dings.commands)


if __name__ == '__main__':
    main()
