# Waveshare PiPico2 LCD 0.96
# 3 Channel Voltmeter
# 2025-10-31 mchris

import time
import LCD_0inch96
import colors

from machine import ADC

adc0 = ADC(26)        # create an ADC object acting on a pin
adc1 = ADC(27)        # create an ADC object acting on a pin
adc2 = ADC(28)        # create an ADC object acting on a pin


lcd = LCD_0inch96.LCD_0inch96()   
lcd.fill(colors.BLACK)

lcd.text("3 channel voltmeter",10,10,colors .GREEN)

lcd.display()

time.sleep(0.5)

import framebuf
from writer import CWriter
import freesans20

lcd.fill(colors.BLACK)
lcd.display()

width = 160
height = 80

buf = lcd.buffer  # Must get this *after* lcd is initialized

class FrameBufferWithSize(framebuf.FrameBuffer):
    def __init__(self, buffer, width, height, format):
        super().__init__(buffer, width, height, format)
        self.width = width
        self.height = height

fb = FrameBufferWithSize(buf, width, height, framebuf.RGB565)

wri = CWriter(fb, freesans20)

fb.fill(0)  # Clear framebuffer

def printAdc(txt,val):
    wri.setcolor(colors.BLUE,colors.BLACK)
    wri.printstring(txt)
    wri.setcolor(colors.GREEN,colors.BLACK)
    wri.printstring(str(val)+" V\n")
    

while True:
    scale=3.3/65536
    val0 = adc0.read_u16()*scale 
    val1 = adc1.read_u16()*scale 
    val2 = adc2.read_u16()*scale
    #wri.set_textpos(fb,0,20)
    printAdc("pin 31: ",round(val0,2))
    printAdc("pin 32: ",round(val1,2))
    printAdc("pin 34: ",round(val2,2))
    #wri.printstring("\n")
    lcd.display()
    time.sleep(0.5)

lcd.display()

