#include "pico/stdlib.h"

#ifndef PSMALLOC_H
#define PSMALLOC_H

#ifdef __cplusplus
extern "C"
{
#endif
//#define malloc(size) psram_malloc(size)
//#define calloc(num, size) psram_calloc(num, size)
//#define free(ptr) psram_free(ptr)

#define PSMALLOCLIST 10

typedef struct
{
    uint32_t  idxfree; //
    uint32_t  idxused;
    size_t    size[PSMALLOCLIST];
    uint8_t*  ptr[PSMALLOCLIST];
} psmalloc_list_t;

static psmalloc_list_t psmalloc_list;
void psmalloc_init(void);
void* psram_malloc(size_t size);
void* psram_calloc(size_t num, size_t size);
void psram_free(void* ptr);

#ifdef __cplusplus
}
#endif

#endif