<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);
require_once 'config.php';
if (isset($_COOKIE[DASHBOARD_COOKIE_NAME]) &&
    hash_equals($_COOKIE[DASHBOARD_COOKIE_NAME], hash('sha256', DASHBOARD_PASSWORD))) {

    setcookie(
        DASHBOARD_COOKIE_NAME,
        hash('sha256', DASHBOARD_PASSWORD),
        time() + 30*24*60*60,
        "/"
    );

} else {

    if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['password'])) {

        if ($_POST['password'] === DASHBOARD_PASSWORD) {

            setcookie(
                DASHBOARD_COOKIE_NAME,
                hash('sha256', DASHBOARD_PASSWORD),
                time() + 30*24*60*60,
                "/"
            );

            header("Location: ".$_SERVER['PHP_SELF']);
            exit;

        } else {
            $error = "Falsches Passwort.";
        }
    }

    ?>
    <!DOCTYPE html>
    <html lang="de">
        <!DOCTYPE html>
        <html lang="de">
        <head>
            <meta charset="UTF-8">
            <title>Login</title>
            <style>
                body { font-family: sans-serif; background: #f0f0f0; padding: 40px; }
                .login-box {
                    background: white; padding: 20px; max-width: 300px;
                    margin: auto; border-radius: 8px; box-shadow: 0 0 10px rgba(0,0,0,0.1);
                }
                input[type=password] { width: 100%; padding: 10px; margin-top: 10px; }
                input[type=submit] { margin-top: 15px; padding: 10px; width: 100%; }
                .error { color: red; margin-top: 10px; }
            </style>
        </head>
        <body>
            <div class="login-box">
                <h2>Passwort erforderlich</h2>
                <form method="post">
                    <input type="password" name="password" placeholder="Passwort eingeben">
                    <input type="submit" value="Login">
                </form>
                <?php if (!empty($error)) echo "<div class='error'>$error</div>"; ?>
            </div>
        </body>
        </html>

    </html>
    <?php
    exit;
}

// Logout durchführen, wenn ?logout=1 gesetzt ist
if (isset($_GET['logout'])) {
    // Cookie löschen
    setcookie(DASHBOARD_COOKIE_NAME, '', time() - 3600, "/");

    // Seite neu laden, damit der Login erscheint
    header("Location: ".$_SERVER['PHP_SELF']);
    exit;
}

// DB-Verbindung
$mysqli = new mysqli(DB_HOST, DB_USER, DB_PASS, DB_NAME);
if ($mysqli->connect_error) {
    die("DB connection failed: " . $mysqli->connect_error);
}

// Datum aus Auswahl oder heute
$selectedDate = $_GET['date'] ?? date("Y-m-d");

// Zeitbereich-Helfer
function dayRange($date) {
    return [$date . " 00:00:00", $date . " 23:59:59"];
}
function weekRange($date) {
    $ts = strtotime($date);
    $monday = date("Y-m-d", strtotime("monday this week", $ts));
    $sunday = date("Y-m-d", strtotime("sunday this week", $ts));
    return [$monday . " 00:00:00", $sunday . " 23:59:59", $monday, $sunday];
}
function monthRange($date) {
    $ts = strtotime($date);
    $start = date("Y-m-01", $ts);
    $end   = date("Y-m-t", $ts);
    return [$start . " 00:00:00", $end . " 23:59:59", $start, $end];
}
function yearRange($date) {
    $year = date("Y", strtotime($date));
    return [
        "$year-01-01 00:00:00",
        "$year-12-31 23:59:59",
        "$year-01-01",
        "$year-12-31"
    ];
}

// Daten laden
function loadData($mysqli, $sql, $params) {
    $stmt = $mysqli->prepare($sql);
    if (!$stmt) { die("Prepare failed: " . $mysqli->error); }
    $types = str_repeat("s", count($params));
    $stmt->bind_param($types, ...$params);
    $stmt->execute();
    $res = $stmt->get_result();
    $data = [];
    while ($row = $res->fetch_assoc()) {
        $row['avg_power_kw']     = isset($row['avg_power_kw'])     ? (float)$row['avg_power_kw']     : null;
        $row['temp_out_c']       = isset($row['temp_out_c'])       ? (float)$row['temp_out_c']       : null;
        $row['temp_vorlauf_c']   = isset($row['temp_vorlauf_c'])   ? (float)$row['temp_vorlauf_c']   : null;
        $row['temp_ruecklauf_c'] = isset($row['temp_ruecklauf_c']) ? (float)$row['temp_ruecklauf_c'] : null;
        $data[] = $row;
    }
    return $data;
}

// Tagesdaten
list($dayStart, $dayEnd) = dayRange($selectedDate);
$dayData = loadData(
    $mysqli,
    "SELECT ts, avg_power_kw, temp_out_c, temp_vorlauf_c, temp_ruecklauf_c 
     FROM gas_logger WHERE ts BETWEEN ? AND ? ORDER BY ts",
    [$dayStart, $dayEnd]
);

// Wochendaten
list($weekStartDT, $weekEndDT, $weekStartDate, $weekEndDate) = weekRange($selectedDate);
$weekData = loadData(
    $mysqli,
    "SELECT ts, avg_power_kw, temp_out_c, temp_vorlauf_c, temp_ruecklauf_c 
     FROM gas_logger WHERE ts BETWEEN ? AND ? ORDER BY ts",
    [$weekStartDT, $weekEndDT]
);

// Monatsdaten
list($monthStartDT, $monthEndDT, $monthStartDate, $monthEndDate) = monthRange($selectedDate);
$monthData = loadData(
    $mysqli,
    "SELECT ts, avg_power_kw, temp_out_c, temp_vorlauf_c, temp_ruecklauf_c 
     FROM gas_logger WHERE ts BETWEEN ? AND ? ORDER BY ts",
    [$monthStartDT, $monthEndDT]
);

// Jahresdaten
list($yearStartDT, $yearEndDT, $yearStartDate, $yearEndDate) = yearRange($selectedDate);
$yearData = loadData(
    $mysqli,
    "SELECT ts, avg_power_kw, temp_out_c, temp_vorlauf_c, temp_ruecklauf_c 
     FROM gas_logger WHERE ts BETWEEN ? AND ? ORDER BY ts",
    [$yearStartDT, $yearEndDT]
);

// Heizkurvendaten = Jahresdaten
$curveData = $yearData;



// Statistik
function calcStats($data) {
    if (empty($data)) return null;

    $temps   = array_column($data, 'temp_out_c');
    $powers  = array_column($data, 'avg_power_kw');
    $vorlauf = array_column($data, 'temp_vorlauf_c');

    // Null-Werte filtern
    $temps   = array_values(array_filter($temps, fn($v) => $v !== null));
    $powers  = array_values(array_filter($powers, fn($v) => $v !== null));
    $vorlauf = array_values(array_filter($vorlauf, fn($v) => $v !== null));

    if (empty($temps) || empty($powers)) return null;

    return [
        'temp_min'    => min($temps),
        'temp_max'    => max($temps),
        'temp_avg'    => array_sum($temps)/count($temps),
        'power_min'   => min($powers),
        'power_max'   => max($powers),
        'power_avg'   => array_sum($powers)/count($powers),
        'vorlauf_max' => empty($vorlauf) ? null : max($vorlauf)
    ];
}


$dayStats   = calcStats($dayData);
$weekStats  = calcStats($weekData);
$monthStats = calcStats($monthData);
$yearStats  = calcStats($yearData);

function calcEnergyKWh($data) {
    if (empty($data)) return 0;

    $energy = 0; // kWh
    $prevTs = null;

    foreach ($data as $row) {
        if ($row['avg_power_kw'] === null) continue;

        $ts = strtotime($row['ts']);

        if ($prevTs !== null) {
            $dt = ($ts - $prevTs) / 3600; // Stunden
            $energy += $row['avg_power_kw'] * $dt;
        }

        $prevTs = $ts;
    }

    return $energy;
}

// Kumulierte Energie in Zeitraum
$dayEnergyKWh  = calcEnergyKWh($dayData);
$weekEnergyKWh = calcEnergyKWh($weekData);
$monthEnergyKWh = calcEnergyKWh($monthData);
$yearEnergyKWh = calcEnergyKWh($yearData);

// Achsen der Charts harmonisieren, damit beide y-Achsen sinnvoll übereinander liegen
function computeHarmonizedAxes($data) {

    if (empty($data)) {
        return [
            'power' => ['min' => 0, 'max' => 1, 'step' => 1],
            'temp'  => ['min' => 0, 'max' => 10, 'step' => 5]
        ];
    }

    // --- Min/Max bestimmen ---
    $powerValues = array_column($data, 'avg_power_kw');
    $tempValues  = array_merge(
        array_column($data, 'temp_out_c'),
        array_column($data, 'temp_vorlauf_c'),
        array_column($data, 'temp_ruecklauf_c')
    );

    $minPower = min($powerValues);
    $maxPower = max($powerValues);

    $minTemp = min($tempValues);
    $maxTemp = max($tempValues);

    // --- "Schöne" Rundung ---
    $minPowerRounded = 0;
    $maxPowerRounded = ceil($maxPower);

    $minTempRounded = floor($minTemp / 5) * 5;
    $maxTempRounded = ceil($maxTemp / 5) * 5;

    // --- Bereiche ---
    $powerRange = $maxPowerRounded - $minPowerRounded;
    $tempRange  = $maxTempRounded - $minTempRounded;

    // --- Schrittgrößen ---
    $powerStep = 1;   // 1 kW
    $tempStep  = 5;   // 5°C

    $powerSteps = $powerRange / $powerStep;
    $tempSteps  = $tempRange / $tempStep;

    // --- Gemeinsame Schrittanzahl ---
    $commonSteps = max($powerSteps, $tempSteps);

    // --- Endgültige Max-Werte ---
    $maxPowerFinal = $minPowerRounded + $commonSteps * $powerStep;
    $maxTempFinal  = $minTempRounded + $commonSteps * $tempStep;

    return [
        'power' => [
            'min'  => $minPowerRounded,
            'max'  => $maxPowerFinal,
            'step' => $powerStep
        ],
        'temp' => [
            'min'  => $minTempRounded,
            'max'  => $maxTempFinal,
            'step' => $tempStep
        ]
    ];
}

$axesDay   = computeHarmonizedAxes($dayData);
$axesWeek  = computeHarmonizedAxes($weekData);
$axesMonth = computeHarmonizedAxes($monthData);
$axesYear  = computeHarmonizedAxes($yearData);

?>

<script>
const axisDay   = <?php echo json_encode($axesDay); ?>;
const axisWeek  = <?php echo json_encode($axesWeek); ?>;
const axisMonth = <?php echo json_encode($axesMonth); ?>;
const axisYear  = <?php echo json_encode($axesYear); ?>;
</script>


<!DOCTYPE html>
<html lang="de">
<head>
<meta charset="UTF-8">
<title>Gaslogger Auswertung</title>
<link rel="stylesheet" href="auswertung.css">
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
</head>
<body>
<div class="page-container">
<h1>Gaslogger Auswertung</h1>

<form method="get" style="display:inline;">
    <button type="submit" name="logout" value="1">Logout</button>
</form>
<br>
<p>
<form method="get" class="filter-form">
  <label for="date">Datum wählen:</label>
  <input type="date" id="date" name="date" value="<?php echo htmlspecialchars($selectedDate); ?>">
  <button type="submit">Anzeigen</button>
</form>
<?php
$ts = strtotime($selectedDate);

// Tag
$prevDay = date("Y-m-d", strtotime("-1 day", $ts));
$nextDay = date("Y-m-d", strtotime("+1 day", $ts));

// Woche
$prevWeek = date("Y-m-d", strtotime("-1 week", $ts));
$nextWeek = date("Y-m-d", strtotime("+1 week", $ts));

// Monat
$prevMonth = date("Y-m-d", strtotime("-1 month", $ts));
$nextMonth = date("Y-m-d", strtotime("+1 month", $ts));

// Jahr
$prevYear = date("Y-m-d", strtotime("-1 year", $ts));
$nextYear = date("Y-m-d", strtotime("+1 year", $ts));
?>


<!-- ============================
     CHARTS
============================= -->

<div class="chart-container">
  <h2>Tagesverlauf (<?php echo htmlspecialchars($selectedDate); ?>)</h2>
  <canvas id="chartDay"></canvas>

  <?php if ($dayStats): ?>
    <div class="stats-grid">

      <div>
        <div class="stats-title">Temperatur (°C)</div>
        <div class="stats-item"><span>Min:</span> <?php echo number_format($dayStats['temp_min'], 1, ',', '.'); ?></div>
        <div class="stats-item"><span>Max:</span> <?php echo number_format($dayStats['temp_max'], 1, ',', '.'); ?></div>
        <div class="stats-item"><span>Ø:</span>   <?php echo number_format($dayStats['temp_avg'], 1, ',', '.'); ?></div>
      </div>

      <div>
        <div class="stats-title">Leistung (kW)</div>
        <div class="stats-item"><span>Min:</span> <?php echo number_format($dayStats['power_min'], 1, ',', '.'); ?></div>
        <div class="stats-item"><span>Max:</span> <?php echo number_format($dayStats['power_max'], 1, ',', '.'); ?></div>
        <div class="stats-item"><span>Ø:</span>   <?php echo number_format($dayStats['power_avg'], 1, ',', '.'); ?></div>
      </div>

      <div>
        <div class="stats-title">Vorlauf (°C)</div>
        <div class="stats-item"><span>Max:</span>
          <?php echo $dayStats['vorlauf_max'] !== null
            ? number_format($dayStats['vorlauf_max'], 1, ',', '.')
            : '–'; ?>
        </div>
      </div>

    </div>
  <?php else: ?>
    <div class="stats-empty">Keine Daten für diesen Tag.</div>
  <?php endif; ?>
</div>

<?php
echo "<div style='text-align:center; margin-top:10px; font-size:1.2em;'>
         Verbrauch am <b>" . date("d.m.Y", strtotime($selectedDate)) . "</b>: 
        <b>" . round($dayEnergyKWh, 2) . " kWh</b>
      </div>";
?>
<div class="nav-buttons">
    <a href="?date=<?php echo $prevDay; ?>" class="btn">« Tag zurück</a>
    <a href="?date=<?php echo $nextDay; ?>" class="btn">Tag vor »</a>
    <br>
</div>
<br>
<br>
<div class="chart-container">
  <h2>Wochenverlauf (<?php echo htmlspecialchars($weekStartDate); ?> bis <?php echo htmlspecialchars($weekEndDate); ?>)</h2>
  <canvas id="chartWeek"></canvas>

  <?php if ($weekStats): ?>
    <div class="stats-grid">

      <div>
        <div class="stats-title">Temperatur (°C)</div>
        <div class="stats-item"><span>Min:</span> <?php echo number_format($weekStats['temp_min'], 1, ',', '.'); ?></div>
        <div class="stats-item"><span>Max:</span> <?php echo number_format($weekStats['temp_max'], 1, ',', '.'); ?></div>
        <div class="stats-item"><span>Ø:</span>   <?php echo number_format($weekStats['temp_avg'], 1, ',', '.'); ?></div>
      </div>

      <div>
        <div class="stats-title">Leistung (kW)</div>
        <div class="stats-item"><span>Min:</span> <?php echo number_format($weekStats['power_min'], 1, ',', '.'); ?></div>
        <div class="stats-item"><span>Max:</span> <?php echo number_format($weekStats['power_max'], 1, ',', '.'); ?></div>
        <div class="stats-item"><span>Ø:</span>   <?php echo number_format($weekStats['power_avg'], 1, ',', '.'); ?></div>
      </div>

      <div>
        <div class="stats-title">Vorlauf (°C)</div>
        <div class="stats-item"><span>Max:</span>
          <?php echo $weekStats['vorlauf_max'] !== null
            ? number_format($weekStats['vorlauf_max'], 1, ',', '.')
            : '–'; ?>
        </div>
      </div>

    </div>
  <?php else: ?>
    <div class="stats-empty">Keine Daten für diese Woche.</div>
  <?php endif; ?>
</div>

<?php
echo "<div style='text-align:center; margin-top:10px; font-size:1.2em;'>
        Verbrauch in der Woche ab <b>" . date("d.m.Y", strtotime($weekStartDate)) . "</b>: 
        <b>" . round($weekEnergyKWh, 2) . " kWh</b>
      </div>";
?>
<div class="nav-buttons">
    <a href="?date=<?php echo $prevWeek; ?>" class="btn">« Woche zurück</a>
    <a href="?date=<?php echo $nextWeek; ?>" class="btn">Woche vor »</a>
    <br>
</div>
<br>
<br>
<div class="chart-container">
  <h2>Monatsverlauf (<?php echo htmlspecialchars($monthStartDate); ?> bis <?php echo htmlspecialchars($monthEndDate); ?>)</h2>
  <canvas id="chartMonth"></canvas>

  <?php if ($monthStats): ?>
    <div class="stats-grid">

      <div>
        <div class="stats-title">Temperatur (°C)</div>
        <div class="stats-item"><span>Min:</span> <?php echo number_format($monthStats['temp_min'], 1, ',', '.'); ?></div>
        <div class="stats-item"><span>Max:</span> <?php echo number_format($monthStats['temp_max'], 1, ',', '.'); ?></div>
        <div class="stats-item"><span>Ø:</span>   <?php echo number_format($monthStats['temp_avg'], 1, ',', '.'); ?></div>
      </div>

      <div>
        <div class="stats-title">Leistung (kW)</div>
        <div class="stats-item"><span>Min:</span> <?php echo number_format($monthStats['power_min'], 1, ',', '.'); ?></div>
        <div class="stats-item"><span>Max:</span> <?php echo number_format($monthStats['power_max'], 1, ',', '.'); ?></div>
        <div class="stats-item"><span>Ø:</span>   <?php echo number_format($monthStats['power_avg'], 1, ',', '.'); ?></div>
      </div>

      <div>
        <div class="stats-title">Vorlauf (°C)</div>
        <div class="stats-item"><span>Max:</span>
          <?php echo $monthStats['vorlauf_max'] !== null
            ? number_format($monthStats['vorlauf_max'], 1, ',', '.')
            : '–'; ?>
        </div>
      </div>

    </div>
  <?php else: ?>
    <div class="stats-empty">Keine Daten für diesen Monat.</div>
  <?php endif; ?>
</div>


<?php
echo "<div style='text-align:center; margin-top:10px; font-size:1.2em;'>
        Verbrauch im <b>" . date("F Y", strtotime($selectedDate)) . "</b>: 
        <b>" . round($monthEnergyKWh, 2) . " kWh</b>
      </div>";
?>
<div class="nav-buttons">
    <a href="?date=<?php echo $prevMonth; ?>" class="btn">« Monat zurück</a>
    <a href="?date=<?php echo $nextMonth; ?>" class="btn">Monat vor »</a>
</div>

<div class="chart-container">
  <h2>Jahresverlauf (<?php echo date("Y", strtotime($selectedDate)); ?>)</h2>
  <canvas id="chartYear"></canvas>

  <?php if ($yearStats): ?>
    <div class="stats-grid">

      <div>
        <div class="stats-title">Temperatur (°C)</div>
        <div class="stats-item"><span>Min:</span> <?php echo number_format($yearStats['temp_min'], 1, ',', '.'); ?></div>
        <div class="stats-item"><span>Max:</span> <?php echo number_format($yearStats['temp_max'], 1, ',', '.'); ?></div>
        <div class="stats-item"><span>Ø:</span>   <?php echo number_format($yearStats['temp_avg'], 1, ',', '.'); ?></div>
      </div>

      <div>
        <div class="stats-title">Leistung (kW)</div>
        <div class="stats-item"><span>Min:</span> <?php echo number_format($yearStats['power_min'], 1, ',', '.'); ?></div>
        <div class="stats-item"><span>Max:</span> <?php echo number_format($yearStats['power_max'], 1, ',', '.'); ?></div>
        <div class="stats-item"><span>Ø:</span>   <?php echo number_format($yearStats['power_avg'], 1, ',', '.'); ?></div>
      </div>

      <div>
        <div class="stats-title">Vorlauf (°C)</div>
        <div class="stats-item"><span>Max:</span>
          <?php echo $yearStats['vorlauf_max'] !== null
            ? number_format($yearStats['vorlauf_max'], 1, ',', '.')
            : '–'; ?>
        </div>
      </div>

    </div>
  <?php else: ?>
    <div class="stats-empty">Keine Daten für dieses Jahr.</div>
  <?php endif; ?>
</div>

<?php
echo "<div style='text-align:center; margin-top:10px; font-size:1.2em;'>
        Verbrauch im Jahr <b>" . date("Y", strtotime($selectedDate)) . "</b>: 
        <b>" . round($yearEnergyKWh, 2) . " kWh</b>
      </div>";
?>
<div class="nav-buttons">
    <a href="?date=<?php echo $prevYear; ?>" class="btn">« Jahr zurück</a>
    <a href="?date=<?php echo $nextYear; ?>" class="btn">Jahr vor »</a>
</div>
<br>
<br>

<script>
function buildChart(canvasId, data, axis) {
  const ctx = document.getElementById(canvasId).getContext('2d');

  const labels      = data.map(r => r.ts);
  const power       = data.map(r => r.avg_power_kw);
  const tempOut     = data.map(r => r.temp_out_c);
  const tempVorlauf = data.map(r => r.temp_vorlauf_c);
  const tempRueck   = data.map(r => r.temp_ruecklauf_c);

  new Chart(ctx, {
    type: 'line',
    data: {
      labels: labels,
      datasets: [
        {
          label: 'Leistung (kW)',
          data: power,
          borderColor: '#d62828',
          borderWidth: 2,
          yAxisID: 'yPower',
          fill: false,
          tension: 0.2
        },
        {
          label: 'Außentemperatur (°C)',
          data: tempOut,
          borderColor: '#1d4ed8',
          borderWidth: 2,
          yAxisID: 'yTemp',
          fill: false,
          tension: 0.2
        },
        {
          label: 'Vorlauf (°C)',
          data: tempVorlauf,
          borderColor: '#a020f0',
          borderWidth: 1,
          yAxisID: 'yTemp',
          fill: false,
          tension: 0.2
        },
        {
          label: 'Rücklauf (°C)',
          data: tempRueck,
          borderColor: '#00c0c0',
          borderWidth: 1,
          yAxisID: 'yTemp',
          fill: false,
          tension: 0.2
        }
      ]
    },
    options: {
      responsive: true,
      interaction: { mode: 'index', intersect: false },
      stacked: false,
      scales: {
        yPower: {
            min: axis.power.min,
            max: axis.power.max,
            ticks: { stepSize: axis.power.step },

            type: 'linear',
            position: 'left',
            beginAtZero: true,
            title: {
                display: true,
                text: 'Leistung (kW)',
                color: '#d62828',
                font: { weight: 'bold' }
            },

            grid: {
                color: 'rgba(214, 40, 40, 0.2)'   // leicht rötliche Hilfslinien
            }
        },
     
        yTemp: {
            min: axis.temp.min,
            max: axis.temp.max,
            ticks: { stepSize: axis.temp.step },
            type: 'linear',
            position: 'right',
            beginAtZero: true,
            title: {
                display: true,
                text: 'Temperatur (°C)',
                color: '#1d4ed8',
                font: { weight: 'bold' }
            },

            grid: {
                color: 'rgba(29, 78, 216, 0.2)'   // leicht bläuliche Hilfslinien
            }
        }
      }

    }
  });
}

const dayData   = <?php echo json_encode($dayData); ?>;
const weekData  = <?php echo json_encode($weekData); ?>;
const monthData = <?php echo json_encode($monthData); ?>;
const yearData = <?php echo json_encode($yearData); ?>;


buildChart('chartDay', dayData, axisDay);
buildChart('chartWeek', weekData, axisWeek);
buildChart('chartMonth', monthData, axisMonth);
buildChart('chartYear', yearData, axisYear);

</script>

<!-- ============================
    Zählerstand
============================= -->
<hr style="
    width: 70%;
    margin: 20px auto;
    border: none;
    border-top: 3px solid #000;
">

<?php
// Letzten Datensatz holen
$res = $mysqli->query("SELECT cumulative_ticks FROM gas_logger ORDER BY ts DESC LIMIT 1");
if ($res && $row = $res->fetch_assoc()) {
    $cumulative_ticks = (int)$row['cumulative_ticks'];
    $current_m3 = START_M3 + ($cumulative_ticks * K_TICK_M3);

    echo "<div style='text-align:center; font-size:2em; font-weight:bold; margin-top:40px;'>";
    echo "Aktueller Zählerstand: " . number_format($current_m3, 2, ',', '');
    echo "</div>";
}
?>
<br>
<hr style="
    width: 70%;
    margin: 20px auto;
    border: none;
    border-top: 3px solid #000;
">

<!-- ============================
     HEIZKURVENANALYSE (JAHR)
============================= -->

<h2 style="text-align:center; margin-top:50px;">Heizkurvenanalyse (Jahr)</h2>
<div style="width:90%; max-width:900px; margin:0 auto;">
  <canvas id="chartCurve"></canvas>
</div>

<?php
// Heizkurvendaten reduzieren (VL vs AT)
$curveReduced = [];
$curveSeen = [];

// Heizkurvendaten reduzieren (VL vs AT) mit Häufigkeitszählung
$curveReduced = [];
$curveSeen = [];

foreach ($curveData as $row) {
    if ($row['temp_out_c'] === null || $row['temp_vorlauf_c'] === null) continue;

    $x = round($row['temp_out_c'] * 4) / 4;   // 0,25°C Raster
    $y = round($row['temp_vorlauf_c'] * 4) / 4;

    $key = $x . "_" . $y;

    if (!isset($curveSeen[$key])) {
        $curveSeen[$key] = 1;
        $curveReduced[$key] = ['x' => $x, 'y' => $y, 'count' => 1];
    } else {
        $curveSeen[$key]++;
        $curveReduced[$key]['count'] = $curveSeen[$key];
    }
}

$curveJson = json_encode(array_values($curveReduced));

?>

<script>
const curveDataYear = <?php echo $curveJson; ?>;

function buildCurveChart() {
    const ctx = document.getElementById('chartCurve').getContext('2d');

    new Chart(ctx, {
        type: 'scatter',
        data: {
            datasets: [{
                label: 'Vorlauf vs. Außentemperatur (Jahr)',
                data: curveDataYear,
                backgroundColor: '#a020f0',
                borderColor: '#a020f0',
                pointRadius: ctx => {
                    const c = ctx.raw.count || 1;
                    const size = 3 + Math.floor(c / 5) * 2;
                    return Math.min(size, 30);
                },
                pointHoverRadius: 5
            }]
        },
        options: {
            responsive: true,
            animation: false,
            scales: {
                x: {
                    type: 'linear',
                    title: { display: true, text: 'Außentemperatur (°C, 0,25er Raster)' }
                },
                y: {
                    type: 'linear',
                    title: { display: true, text: 'Vorlauf (°C, 0,25er Raster)' }
                }
            }
        }
    });
}

buildCurveChart();

</script>

<?php
echo "<div style='text-align:center; margin-top:20px; font-size:1.3em;'>";
// --- Vorlauf-Prognose bei -10°C aus gas_logger berechnen ---

$vorlauf_minus10 = null;
$vorlauf_info = "";

// Messwerte holen: nur Außentemperaturen <= 16°C, zwei Heizperioden
$sql = "
    SELECT temp_out_c, temp_vorlauf_c
    FROM gas_logger
    WHERE temp_out_c IS NOT NULL
      AND temp_vorlauf_c IS NOT NULL
      AND temp_out_c <= 16
      AND ts >= DATE_SUB(NOW(), INTERVAL 730 DAY)
    ORDER BY ts DESC

";

$result = $mysqli->query($sql);

if ($result && $result->num_rows > 20) {

    $temps = [];
    $vorlauf = [];

    while ($row = $result->fetch_assoc()) {
        $temps[]   = (float)$row['temp_out_c'];
        $vorlauf[] = (float)$row['temp_vorlauf_c'];
    }

    // Temperaturspanne prüfen (mind. 10°C)
    $minT = min($temps);
    $maxT = max($temps);
    $span = $maxT - $minT;

    if ($span < 10) {
        // Zu wenig Varianz → keine Prognose
        $vorlauf_minus10 = null;
        $vorlauf_info = "Temperaturspanne zu gering (nur " . round($span, 1) . "°C). Mindestens 10°C erforderlich.";
    } else {

        // Lineare Regression
        $n = count($temps);

        $sumX  = array_sum($temps);
        $sumY  = array_sum($vorlauf);
        $sumXY = 0;
        $sumX2 = 0;

        for ($i = 0; $i < $n; $i++) {
            $sumXY += $temps[$i] * $vorlauf[$i];
            $sumX2 += $temps[$i] * $temps[$i];
        }

        $den = ($n * $sumX2 - $sumX * $sumX);

        if ($den != 0) {
            // Regressionsparameter
            $m = ($n * $sumXY - $sumX * $sumY) / $den;
            $b = ($sumY - $m * $sumX) / $n;

            // Vorlauf bei -10°C
            $vorlauf_minus10 = $m * (-10) + $b;

            $vorlauf_info =
                "Berechnet aus $n Datenpunkten (Temperaturspanne: "
                . round($span, 1) . "°C, Steigung: "
                . round($m, 2) . " °C/°C).";

        } else {
            $vorlauf_minus10 = null;
            $vorlauf_info = "Regression nicht möglich (Division durch 0).";
        }
    }

} else {
    $vorlauf_minus10 = null;
    $vorlauf_info = "Nicht genügend Messpunkte für eine verlässliche Prognose.";
}

if ($vorlauf_minus10 !== null) {
    echo "Vorlauftemperaturprognose bei -10°C: <b>" . round($vorlauf_minus10, 1) . " °C</b><br>";
    echo "<span style='color:#666;'>$vorlauf_info</span>";
} else {
    echo "Vorlauftemperaturprognose bei -10°: Nicht genügend Datenpunkte für eine belastbare Prognose";
}

echo "</div>";
?>

<!-- ============================
     LEISTUNG vs. AUSSENTEMPERATUR (JAHR)
============================= -->

<h2 style="text-align:center; margin-top:50px;">Leistung vs. Außentemperatur (Jahr)</h2>
<div style="width:90%; max-width:900px; margin:0 auto;">
  <canvas id="chartPowerCurve"></canvas>
</div>

<?php
// Datenreduktion für Scatterplot (Jahr)
// Datenreduktion für Scatterplot (Jahr) mit Häufigkeitszählung
$powerReduced = [];
$powerSeen = [];

foreach ($yearData as $row) {
    if ($row['temp_out_c'] === null || $row['avg_power_kw'] === null) continue;

    $x = round($row['temp_out_c'] * 4) / 4;   // 0,25°C Raster
    $y = round($row['avg_power_kw'], 1);     // 0,1 kW Raster

    $key = $x . "_" . $y;

    if (!isset($powerSeen[$key])) {
        $powerSeen[$key] = 1;
        $powerReduced[$key] = ['x' => $x, 'y' => $y, 'count' => 1];
    } else {
        $powerSeen[$key]++;
        $powerReduced[$key]['count'] = $powerSeen[$key];
    }
}

$powerJson = json_encode(array_values($powerReduced));

// Heizlastberechnung
$xs = [];
$ys = [];

foreach ($powerReduced as $p) {
    if ($p['x'] < 16) {
        $xs[] = $p['x'];
        $ys[] = $p['y'];
    }
}

$heizlast_minus10 = null;
$heizlast_info = "";

if (count($xs) >= 50) {
    $t_min = min($xs);
    $t_max = max($xs);
    $spread = $t_max - $t_min;

    if ($spread >= 10) {
        $n = count($xs);
        $sumX = array_sum($xs);
        $sumY = array_sum($ys);
        $sumXY = 0;
        $sumX2 = 0;

        for ($i = 0; $i < $n; $i++) {
            $sumXY += $xs[$i] * $ys[$i];
            $sumX2 += $xs[$i] * $xs[$i];
        }

        $a = ($n * $sumXY - $sumX * $sumY) / ($n * $sumX2 - $sumX * $sumX);
        $b = ($sumY - $a * $sumX) / $n;

        $heizlast_minus10 = $a * (-10) + $b;

        $heizlast_info = "Basierend auf $n Datenpunkten von $t_min°C bis $t_max°C";
    }
}
?>

<script>
const powerCurveData = <?php echo $powerJson; ?>;

function buildPowerCurveChart() {
    const ctx = document.getElementById('chartPowerCurve').getContext('2d');

    new Chart(ctx, {
        type: 'scatter',
        data: {
            datasets: [{
                label: 'Leistung (kW) vs. Außentemperatur (Jahr)',
                data: powerCurveData,
                backgroundColor: '#d62828',
                borderColor: '#d62828',
                pointRadius: ctx => {
                    const c = ctx.raw.count || 1;
                    const size = 2 + Math.floor(c / 5) * 2;
                    return Math.min(size, 30);
                },
                pointHoverRadius: 5
            }]
        },
        options: {
            responsive: true,
            animation: false,
            scales: {
                x: {
                    type: 'linear',
                    title: { display: true, text: 'Außentemperatur (°C, 0,25er Raster)' }
                },
                y: {
                    type: 'linear',
                    title: { display: true, text: 'Leistung (kW, gerundet)' }
                }
            }
        }
    });
}

buildPowerCurveChart();
</script>



<?php
// Heizlast-Ausgabe
echo "<div style='text-align:center; margin-top:20px; font-size:1.3em;'>";

if ($heizlast_minus10 !== null) {
    echo "Geschätzte Heizlast bei -10°C: <b>" . round($heizlast_minus10, 1) . " kW</b><br>";
    echo "<span style='color:#666;'>$heizlast_info</span>";
} else {
    echo "Heizlastprognose bei -10°: Nicht genügend Datenpunkte für eine belastbare Prognose";
}

echo "</div>";
?>

<!-- ============================
     Autorefresh nach 30 min mit (hoffentlich neuen Daten)
============================= -->
<script>
// Seite alle 30 Minuten automatisch neu laden
setInterval(function() {
    location.reload();
}, 30 * 60 * 1000);
</script>
</div>
</body>
</html>

