<?php
require_once("config.php");

// Verbindung herstellen
$mysqli = new mysqli(DB_HOST, DB_USER, DB_PASS, DB_NAME);
if ($mysqli->connect_error) {
    die("DB connection failed: " . $mysqli->connect_error);
}

// Prüfen, ob Tabelle existiert
$tableExists = $mysqli->query("
    SHOW TABLES LIKE 'gas_logger'
");

if ($tableExists && $tableExists->num_rows > 0) {
    echo "<b>Tabelle 'gas_logger' ist bereits vorhanden.</b><br>";
    exit;
}

// Tabelle anlegen
$sql = "
CREATE TABLE `gas_logger` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `ts` datetime NOT NULL,
  `avg_power_kw` double NOT NULL,
  `energy_kwh` double DEFAULT NULL,
  `temp_out_c` double DEFAULT NULL,
  `device` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `cumulative_ticks` int(10) UNSIGNED NOT NULL DEFAULT 0,
  `temp_vorlauf_c` float DEFAULT NULL,
  `temp_ruecklauf_c` float DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
";

if ($mysqli->query($sql) === TRUE) {
    echo "<b>Tabelle 'gas_logger' wurde erfolgreich angelegt.</b><br>";
} else {
    echo "<b>Fehler beim Erstellen der Tabelle:</b> " . $mysqli->error . "<br>";
}

$mysqli->close();
?>

