<?php
// gasupload.php
require_once("config.php"); // enthält DB_HOST, DB_USER, DB_PASS, DB_NAME, API_KEY

// Eingehende Parameter
$device            = $_POST['device']            ?? '';
$auth              = $_POST['auth']              ?? '';
$cumulative_ticks  = $_POST['cumulative_ticks']  ?? '';
$avg_power_kw      = $_POST['avg_power_kw']      ?? '';
$energy_kwh        = $_POST['energy_kwh']        ?? '';
$temp_out_c        = $_POST['temp_out_c']        ?? '';
$temp_vorlauf_c    = $_POST['temp_vorlauf_c']    ?? '';
$temp_ruecklauf_c  = $_POST['temp_ruecklauf_c']  ?? '';
$timestamp         = $_POST['timestamp']         ?? '';

// Authentifizierung prüfen
if ($auth !== API_KEY) {
    http_response_code(403);
    echo "Auth failed";
    exit;
}

// Zeitstempel prüfen: wenn leer oder ungültig, aktuelle Serverzeit verwenden
if (empty($timestamp) || strtotime($timestamp) === false) {
    $timestamp = date("Y-m-d H:i:s");
}

// DB-Verbindung
$mysqli = new mysqli(DB_HOST, DB_USER, DB_PASS, DB_NAME);
if ($mysqli->connect_error) {
    http_response_code(500);
    die("DB connection failed: " . $mysqli->connect_error);
}

// Prepared Statement für Insert
$stmt = $mysqli->prepare("
    INSERT INTO gas_logger 
        (ts, cumulative_ticks, avg_power_kw, energy_kwh, temp_out_c, temp_vorlauf_c, temp_ruecklauf_c, device)
    VALUES 
        (?, ?, ?, ?, ?, ?, ?, ?)
");

if (!$stmt) {
    http_response_code(500);
    die("Prepare failed: " . $mysqli->error);
}

// Datentypen:
// ts = string
// cumulative_ticks = int
// avg_power_kw = double
// energy_kwh = double
// temp_out_c = string (nullable)
// temp_vorlauf_c = string (nullable)
// temp_ruecklauf_c = string (nullable)
// device = string
$stmt->bind_param(
    "siddddds",
    $timestamp,
    $cumulative_ticks,
    $avg_power_kw,
    $energy_kwh,
    $temp_out_c,
    $temp_vorlauf_c,
    $temp_ruecklauf_c,
    $device
);


if ($stmt->execute()) {
    echo "OK";
} else {
    http_response_code(500);
    echo "DB error: " . $stmt->error;
}

$stmt->close();
$mysqli->close();
?>

