pkg load signal

[uj, fs] = audioread("90_90_30db_DIFF_Board_Pico1preamp.wav");
disp(fs);
N=length(uj);
nn=1:N;
T=N/fs;
ff=(mod(nn-1+N/2,N)-N/2)/T;
U=fft(uj)*6/N; 
data1 = abs(U);
[imax, imaxidx] = max(data1)
signal = 0;
noisesum = 0;
noise    = [];
noiseidx = [];
ii=0;
[pks idx] = findpeaks(data1,"MinPeakHeight",0.005); 
for i=1:length(pks)
 if ff(idx(i)) >=1 && ff(idx(i)) <=2000
  if ff(idx(i)) > ff(imaxidx)-50 && ff(idx(i)) < ff(imaxidx)+50
     signal = signal + (pks(i) * pks(i));
  else
     
     noisesum = noisesum + (pks(i) * pks(i));
     noise = [noise, pks(i)];
     noiseidx = [noiseidx, ff(idx(i))];
  end
 end
end

snr = 10*log10(signal/noisesum)
semilogy(ff(1:20000)*1e-3,data1(1:20000));
hold on;
semilogy(noiseidx*1e-3,noise,'xm');
semilogy(ff(imaxidx)*1e-3,sqrt(signal),'or');
hold off;
legend (['Gen.: -90dBm / Protoboard DIFF' char(10) sprintf('Pico1 PreAmp -89dBm / SNR %.0fdB',snr)],"location", "northeast",'fontsize', 6);
axis tight
ylim([0.0001 1.0]);

%input('Drücken Sie Enter für den nächsten Plot...');

