from datetime import datetime, time, timedelta
from pathlib import Path
import platform, socket, getpass, psutil # (zusätzlich installiert)
import socket
import requests

# from MeineModule import SystemInformations

###########################################################################

def get_system_info():
    print("===== Systeminformationen =====")
    print("Datum & Uhrzeit:", datetime.now().strftime("%d.%m.%Y %H:%M:%S"))
    print("Benutzer:", getpass.getuser())
    print("Hostname:", socket.gethostname())
    print("Betriebssystem:", platform.system(), platform.release())
    print("Version:", platform.version())
    print("Plattform:", platform.platform())
    print("Prozessor:", platform.processor())
    print("Architektur:", platform.architecture()[0])
    # CPU
    print("CPU-Kerne (physisch):", psutil.cpu_count(logical=False))
    print("CPU-Kerne (logisch):", psutil.cpu_count(logical=True))
    print("CPU-Auslastung (%):", psutil.cpu_percent(interval=1))
    # RAM
    ram = psutil.virtual_memory()
    print(f"RAM gesamt: {ram.total / (1024 ** 3):.2f} GB")
    print(f"RAM verfügbar: {ram.available / (1024 ** 3):.2f} GB")
    print(f"RAM-Auslastung: {ram.percent}%")
    # Festplatten
    print("\nFestplatten:")
    for part in psutil.disk_partitions():
        usage = psutil.disk_usage(part.mountpoint)
        print(f"{part.device} - {usage.total / (1024 ** 3):.2f} GB gesamt, "
            f"{usage.free / (1024 ** 3):.2f} GB frei")
    print("================================")
    
def get_all_network_interface():
    for interface_name, interface_addresses in psutil.net_if_addrs().items():
        for address in interface_addresses:
            if address.family == socket.AF_INET:
                print(f"{interface_name}: {address.address}")
    print("================================")   
        
def get_public_IP():    
    ip = requests.get('https://api.ipify.org').text
    return ip
    
def get_local_IP():
    # Erstellt einen temporären UDP-Socket, um die "beste" lokale IP herauszufinden
    s = socket.socket(socket.AF_INET, socket.SOCK_DGRAM)
    try:
        # Verbindung zu einer externen IP (Google DNS), nur um die lokale IP zu ermitteln
        s.connect(("8.8.8.8", 80))
        ip = s.getsockname()[0]
    except Exception:
        ip = "127.0.0.1"  # Fallback
    finally:
        s.close()
    return ip
        
### für schnelle Tests im Modul ###############################

if __name__ == '__main__':
    get_system_info()   
    get_all_network_interface()
    print("public IP:", get_public_IP())
    print("local IP:", get_local_IP())