#include <avr/io.h>
#include <stdlib.h>
#include <string.h>
#include <avr/interrupt.h>
#include <avr/pgmspace.h>
#include <avr/eeprom.h>
#define globals_main 1
#include "main.h"
#include <avr/power.h>
#include <util/delay.h>
#include "std_lib_lcd.h"
#include "uart.h"

int16_t adc_read(u8 ADCchannel);

#define sender0_empfaenger1 0

u8	sperre_rtc=1;

#define wr_bat0_grid0 1
#define wr_bat1_grid0 2
#define wr_bat1_grid1 4
u8 status_wr =wr_bat0_grid0;

#define rs485_ready  	1
#define rs485_waitresp1 2
#define rs485_send_a  	4
#define rs485_send_b  	8
u8 status_rs485 = 1;

u8 status_sync_time = 0;

u16 akku_volt=0;
u16 pv_in=0;
u8 varLTswitch=0;
u8 tag1_nacht0=0;
u8 zlxy=0;
volatile uint8_t txBuffer_rsp[]={1,0,4,4,2,219};



//main ***************************************************************

void main()
{
clock_prescale_set(clock_div_2);//8mhz
init_timer_smh();
lcd_init();
uart_init(18227);//baudrate 9600=>18226-18233 //1,04
adc_init();

i2c_init();
kk_ds1307_getAll_to_global_struct_zt();

lcd_goto(1,1);
lcd_int2(DAY);
lcd_write(".");
lcd_int2(MON);
lcd_write(".");
lcd_int2(YEA);

lcd_goto(2,1);//              
lcd_int2(hou);//
lcd_write(":");              
lcd_int2(min);//
lcd_write(":");  



cbi(DDR(D),2); //Taster
sbi(PORT(D),2);

bat_relais_init;
LTswitch_init;


//while(1);

while(1)
{


/*	while(gbi(PIN(D),2)==0)
	{
	lcd_init();

	}*/

//------------------- smh timer ------------------
	if (timer_smh>99)
		{
			sec=sec+timer_smh/100;
			timer_smh=timer_smh%100;
			if(sec>59){
				sec=sec-60;	min=min+1;
				lcd_goto(2,4);//              
				lcd_int2(min);//
				lcd_write(":");
			if(min==60){
				min=0; hou++;
				if(hou==24)
				{
				hou=0;
					if(sperre_rtc==0)
					{
//						kk_ds1307_getAll_to_global_struct_zt();
//						sub_sommerzeit();
						sperre_rtc=1;
//						sub_day_start();
					}
				
				}
				if(hou==2)sperre_rtc=0;
				
				
				lcd_goto(2,1);//              
				lcd_int2(hou);//
				lcd_write(":");              
				}
			}
		lcd_goto(2,7);//              
		lcd_int2(sec);//
//		led1_tog;              
	
//------------------------------------------------
#if sender0_empfaenger1==0
	if(sec==2)//check
	{
			akku_volt= adc_read_volt();
			pv_in=adc_read(3);
			
			varLTswitch=LTswitch;
			if(varLTswitch==0)// grid-kontakt geschlossen
			{
				if(akku_volt>468){			
				status_wr=wr_bat1_grid0;
				}else{
				status_wr=wr_bat0_grid0;
				}
			
			}else{
			status_wr=wr_bat1_grid1;
			}
			
			
			lcd_goto(3,1);
			lcd_int_10(akku_volt);
			lcd_write("BV ");
			lcd_int4(pv_in);
			lcd_write("PV ");
			lcd_int4(varLTswitch);
			lcd_write("LT ");
			lcd_int4(status_wr);
			lcd_write("St");
			
			sub_fill_txBuffer_a();			
			sub_send_txBuffer(txBuffer_a,16);			
			
	}



	if(sec==5)// Steuerung
	{
		if(pv_in>10 && tag1_nacht0==0)tag1_nacht0=1;
		if(pv_in<5  && tag1_nacht0==1)tag1_nacht0=0;


		if(akku_volt>450 && akku_volt<469  && status_wr==wr_bat0_grid0)//bat ist aus
		{
			bat_start();
			status_wr=wr_bat1_grid0;
			sub_send_txBuffer(txBuffer_b,16);			
			sub_fill_txBuffer_b(0);
			sub_log_anzeige(0);
		}


/*		if(akku_volt>515 && pv_in>225 && status_wr==wr_bat1_grid0) // >1kw
		{
			grid_relais_verbinden;
			status_wr=wr_bat1_grid1;
			sub_log(1);
		
		}*/


		if(akku_volt>530 && status_wr==wr_bat1_grid0)
		{
			grid_relais_verbinden;
			status_wr=wr_bat1_grid1;
			sub_log_anzeige(2);
			sub_fill_txBuffer_b(2);
			sub_send_txBuffer(txBuffer_b,16);			
		}

		
		if(akku_volt<503 &&  status_wr==wr_bat1_grid1)
		{
			grid_relais_trennen;
			status_wr=wr_bat1_grid0;
			sub_log_anzeige(3);
			sub_fill_txBuffer_b(3);
			sub_send_txBuffer(txBuffer_b,16);			
		}

		if(tag1_nacht0==0 && status_wr==wr_bat1_grid0)// kurz vor Sonnenuntergang
		{
			bat_relais_long;
			status_wr=wr_bat0_grid0;
			sub_log_anzeige(4);
			sub_fill_txBuffer_b(4);
			sub_send_txBuffer(txBuffer_b,16);			
		}


//		sub_status_Anzeige();
	
	}
	
/*	if (sec==10 || sec==30 || sec==50)
	{
		sub_log_anzeige(4);
		sub_fill_txBuffer_b(4);
		sub_send_txBuffer(txBuffer_b,16);			
	}*/
	
	
	#endif

		}//sec
	}//while
		
}
//main ***************************************************************



void init_timer_smh(void) {
	TCCR0A |= (1<<WGM01);
	TCCR0B |= ti_prescaler_8;//1024
	OCR0A = 98;// var_ocr0a;//100;//85;//abgleich mit uhr
	TIMSK0 |= (1<<OCIE0A);//Compare Interrupt aktivieren
	sei();//Globale Interrupts aktivieren
	status_zeit=0;
}





ISR(TIMER0_COMPA_vect)
{
timer_10ms++;//~10khz, 100ns
if(rs485_ready_dtimer)
	{
	if(rs485_ready_dtimer==1)
		{
			sub_rx_check();
		}
/**/	rs485_ready_dtimer--;
	}

if(timer_10ms%10==0)
{
}
	if(timer_10ms>99)
	{//100hz
	timer_10ms=0;
	timer_smh++;
	timer_100ms++;
	timer_100msX++;
	
	
		if(anzeige_timer)
		{
			anzeige_timer--;
			if(anzeige_timer==0)led1_off;
		}
		
//timer_elt400++;
//timer_elt1000++;
	}//10ms
	
	if(timer_100ms>9)
	{//10hz
//	timer_elt++;
	timer_100ms=0;
	}
}




void adc_init()
{
   // Set the ADC reference to AVcc
    ADMUX = (1 << REFS0);
    
    // Enable ADC and set prescaler to 128 (16 MHz / 128 = 125 kHz)
    ADCSRA = (1 << ADEN) | (1 << ADPS2) | (1 << ADPS1) | (1 << ADPS0);
}





int16_t adc_read(u8 ADCchannel)
{
    // Select ADC channel (0-7) by setting the lower bits of ADMUX
    ADMUX = (ADMUX & 0xF8) | (ADCchannel & 0x07);
    
    // Start the conversion
    ADCSRA |= (1 << ADSC);
    
    // Wait for the conversion to complete
    while (ADCSRA & (1 << ADSC));
    
	
	
    // Return the ADC result
    return ADC;
}


int16_t adc_read_volt()
{

u16 val=adc_read(2);
val=val*10/14;
return val;
}



void bat_start(void)
{
				grid_relais_trennen;
				wait;
				bat_relais_short;
				status_wr=wr_bat1_grid0;
}



//void function_crc( int array[], int laenge){
//01 10 006C 0001 02 0078 AF1E
u16 function_crc( u8 *bufx, int len){
/*
//01 10 00 6C 00 01 02 00 78 AF1E

uart_str_tx[0]=1;
uart_str_tx[1]=0x10;
uart_str_tx[2]=0;
uart_str_tx[3]=0x6c;
uart_str_tx[4]=0;
uart_str_tx[5]=1;
uart_str_tx[6]=2;
uart_str_tx[7]=0;
uart_str_tx[8]=0x78;


u16 crcx = function_crc(uart_str_tx,9);
lcd_goto(4,1);//              
lcd_int4(crcx & 255);
lcd_int4(crcx>>8);

//=> result dez 175 30 
*/

    u16 crc = 0xffff ;//0;

         for (int pos = 0; pos < len; pos++)
          {
              crc ^= (u16)bufx[pos];          // XOR byte into least sig. byte of crc

              for (int i = 8; i != 0; i--)
              {    // Loop over each bit
                  if ((crc & 0x0001) != 0)
                  {      // If the LSB is set
                      crc >>= 1;                    // Shift right and XOR 0xA001
                      crc ^= 0xA001;
                  }
                  else                            // Else LSB is not set
                      crc >>= 1;                    // Just shift right
              }
          }

return crc;
//         int c=(u16)((crc >> 8) | (crc << 8));
		 
          //132-10
		 
//		  u16 xx = crc / 256;
//        u16 xxx= crc % 256;
}


void sub_fill_txBuffer_a()
{
u16 crc;
		txBuffer_len=14;

		txBuffer_a[0]=0x01;//adr-sender
		txBuffer_a[1]=0x02;//adr-empfnger
		txBuffer_a[2]=txBuffer_len;//len-payload
		txBuffer_a[3]=0;//cmd

		txBuffer_a[4]=hou;
		txBuffer_a[5]=min;
		txBuffer_a[6]=sec;
		txBuffer_a[7]=tag1_nacht0;
		txBuffer_a[8]=status_wr;
		
		txBuffer_a[9]=akku_volt>>8;
		txBuffer_a[10]=akku_volt;

		txBuffer_a[11]=pv_in>>8;
		txBuffer_a[12]=pv_in;

		txBuffer_a[13]=varLTswitch;

	crc= function_crc( txBuffer_a,  txBuffer_len);
	txBuffer_a[txBuffer_len]  = crc & 255 ;
	txBuffer_a[txBuffer_len+1]= crc>>8  ;
}


void serial_tx(u8 array[], u8 ct)
    {
				for(u8 i=0;i<ct;i++)
				{
				uart_putc(array[i]);//127
				}
    }


void sub_send_txBuffer(u8* array, u8 ct)
{
  rs485_data_received=0;
  for (u8 ii = 0; ii < 3; ii++)//mehrere Versuche
	{
		for (u8 i = 0; i < ct; i++)
		{
			while(!(UCSR0A & (1<<UDRE0)));
			UDR0 = array[i];
		}	
		
		_delay_ms(200);//>190ms Dauer der Antwort
		if(rs485_data_received && (rxBuffer[3]==4))
		{
			rs485_data_received=0;
			ii=3;
			return;
		}
		
	}

}			

void sub_log_anzeige(u8 xx)
{
lcd_goto(6+zlxy++,1);
           
lcd_int2(hou);//
lcd_write(":");              
lcd_int2(min);//
lcd_write(" B");              

if(akku_volt>490)
	lcd_int(1);	
	else	
	lcd_int(0);

lcd_write(" G");              
if(LTswitch)
	lcd_int(1);	
	else	
	lcd_int(0);

lcd_int4(akku_volt);
lcd_write("V ");              

lcd_int4(pv_in);
lcd_write("L ");              

lcd_int(xx);
lcd_write("S");              


if(zlxy==10)zlxy=0;


}

void sub_fill_txBuffer_b(u8 xx)
{
//tx
//sub_log_anzeige(xx);

	u16 crc=0;

	txBuffer_len=14;


	txBuffer_b[0]=0x01;//adr-sender
	txBuffer_b[1]=0x02;//adr-empfnger
	txBuffer_b[2]=txBuffer_len;//len-payload
	txBuffer_b[3]=1;//cmd

	txBuffer_b[4]=hou;
	txBuffer_b[5]=min;
	txBuffer_b[6]=sec;
	txBuffer_b[7]=tag1_nacht0;
	txBuffer_b[8]=status_wr;
	
	txBuffer_b[9]=akku_volt>>8;
	txBuffer_b[10]=akku_volt;

	txBuffer_b[11]=pv_in>>8;
	txBuffer_b[12]=pv_in;

	txBuffer_b[13]=LTswitch;

	crc= function_crc( txBuffer_b,  txBuffer_len);
	txBuffer_b[txBuffer_len]  = crc & 255 ;
	txBuffer_b[txBuffer_len+1]= crc>>8  ;


}


sub_rx_check()
{
u8 cmd =rxBuffer[3];
if(cmd==4)//Antwort erhalten
{
	status_rs485=rs485_ready;
}else{
	u8	uart_string_lenx = rxBuffer[2];
/*		for (u8 i=0;i<16;i++)
		{
			lcd_goto(5+i,5);
			lcd_int4(rxBuffer[i]);
		}
*/
	u16	crc= function_crc( rxBuffer,  uart_string_lenx);
	//stimmt crc?
		if(((crc&255)==rxBuffer[uart_string_lenx]) && ((crc>>8)==rxBuffer[uart_string_lenx+1]))
		{
		serial_tx(txBuffer_rsp,6);

		lcd_write("ok");              
	

		switch (cmd)
		  {
		  
			case (0)://status message from 0

			akku_volt=(rxBuffer[9]<<8)+rxBuffer[10];
			pv_in=(rxBuffer[11]<<8)+rxBuffer[12];
				
			u8 LTswitchx=rxBuffer[13];
			status_wr=rxBuffer[8];
			tag1_nacht0=rxBuffer[7];




			lcd_goto(3,1);
			lcd_int(tag1_nacht0);
			lcd_write("tn ");
			
			
			lcd_int_10(akku_volt);
			lcd_write("BV ");
			lcd_int(pv_in);
			lcd_write("PV ");
			lcd_int(LTswitchx);
			lcd_write("LT ");
			lcd_int(status_wr);
			lcd_write("St");
			lcd_int2(rxBuffer[5]);
			
				sec=rxBuffer[6];
				
			if(!status_sync_time)
			{				
				hou=rxBuffer[4];
				min=rxBuffer[5];
				DAY=rxBuffer[7];
				MON=rxBuffer[8];
								YEA=rxBuffer[9];
				lcd_goto(1,1);
				lcd_int2(DAY);
				lcd_write(".");
				lcd_int2(MON);
				lcd_write(".");
				lcd_int2(YEA);

				lcd_goto(2,1);//              
				lcd_int2(hou);//
				lcd_write(":");              
				lcd_int2(min);//
				lcd_write(":");  
								
				status_sync_time=1;				
			}		
			break;
			
			
			case(1):
			
				hou=rxBuffer[4];
				min=	rxBuffer[5];
				sec=	rxBuffer[6];
				tag1_nacht0=	rxBuffer[7];
				status_wr=	rxBuffer[8];
					
				akku_volt=	rxBuffer[10] | (rxBuffer[9]<<8);

				pv_in=	rxBuffer[12] | (rxBuffer[11]<<8);

				varLTswitch=	rxBuffer[13];
				
				sub_log_anzeige(7);
				
			break;
			
			
			
		    case (7)://command set rtc
			
				hou=rxBuffer[4];
				min=rxBuffer[5];
				sec=rxBuffer[6];
				DAY=rxBuffer[7];
				MON=rxBuffer[8];
				YEA=rxBuffer[9];

				lcd_goto(1,1);
				lcd_int2(DAY);
				lcd_write(".");
				lcd_int2(MON);
				lcd_write(".");
				lcd_int2(YEA);

				lcd_goto(2,1);//              
				lcd_int2(hou);//
				lcd_write(":");              
				lcd_int2(min);//
				lcd_write(":");  
				lcd_int2(sec);//


				kk_ds1307_setTime(hou,min,sec);//Sommerzeit 
				kk_ds1307_setDate(DAY,MON,YEA);
			break;


			
			
			
		}//switch

	}else{

	lcd_write("er");              

	}	
}
rxBuffer_ct=0;
}

