/* vim: set ai et ts=4 sw=4: */
//#include "stm32f4xx_hal.h"
#include "ili9341.h"


//kk

#include "colors.h"
#include "new_lib_fonts.h"


  //uint8_t f_height=12,ascii_versatz=32,y=0,f_width=8,frame=0;
uint16_t curposx,curposy;
uint8_t *ptr_image=0, lcd_zeilen_versatz, ascii_versatz=32;
const uint8_t *ptr_font=f8x12;
uint8_t	f_width=8, f_height=12,vertikal_zeichnen=0, frame=0;
uint8_t frame_horz_versatz,frame_vert_versatz;
uint16_t curposx, curposy, Xpos,Ypos;
uint16_t backcolor=White,frontcolor=Black;
 v u16 graphbackcolor=WHITE;



#define ll_cs_high   pinset(ll_cs_port,ll_cs_pin)
#define ll_cs_low    pinclr(ll_cs_port,ll_cs_pin)
#define ll_dc_high   pinset(ll_dc_port,ll_dc_pin)
#define ll_dc_low    pinclr(ll_dc_port,ll_dc_pin)

#define ll_ck_high      pinset(ll_ck_port,ll_ck_pin)
#define ll_ck_low       pinclr(ll_ck_port,ll_ck_pin)
//#define ll_miso_high   pinset(ll_miso_port,ll_miso_pin)
//#define ll_miso_low    pinclr(ll_miso_port,ll_miso_pin)
#define ll_mosi_high   pinset(ll_mosi_port,ll_mosi_pin)
#define ll_mosi_low    pinclr(ll_mosi_port,ll_mosi_pin)


//bitbang
//==============================================


void ll_init(void){

//#if ili_bitbang
reg_dir_out(ll_cs_port,ll_cs_pin);
reg_dir_out(ll_ck_port,ll_ck_pin);
reg_dir_out(ll_dc_port,ll_dc_pin);
reg_dir_out(ll_mosi_port,ll_mosi_pin);
#define ll_ck_cycle     ll_ck_low;ll_ck_high;


//#else

#if ili_bitbang==0

//ili-datasheet: pol=0 pha=0 idle=low pha=leading
SPCR=(1<<SPE)|(1<<MSTR);
SPCR&=~(1<<CPOL);// When this bit is written to zero, SCK is low when idle. 
//SPCR|=(1<<CPOL);// When this bit is written to one, SCK is high when idle. 
SPCR&=~(1<<CPHA);//data is sampled on the leading (first 0) or trailing (last 1) edge
//SPCR|=(1<<CPHA);//data is sampled on the leading (first 0) or trailing (last 1) edge
SPSR = (1 << SPI2X);  // maximale Geschwindigkeit: F_CPU / 2 
_delay_ms(50);
#endif

}



 //HAL_SPI_Transmit(&ILI9341_SPI_PORT, &cmd, sizeof(cmd), HAL_MAX_DELAY);

 void ll_spi_write (const uint8_t *buff, uint16_t size
 //	const u8* buff,	/* Data to be sent */
 //	u16 size		/* Number of bytes to send */
 )
 {
	uint8_t d;
	do {  
	 
	#if ili_bitbang

		d = *buff++;
		if (d & 0x80)ll_mosi_high; else ll_mosi_low;	// bit7
		 ll_ck_cycle;
		if (d & 0x40)ll_mosi_high; else ll_mosi_low;	// bit6
		 ll_ck_cycle;
		if (d & 0x20)ll_mosi_high; else ll_mosi_low;	// bit5
		 ll_ck_cycle;
		if (d & 0x10)ll_mosi_high; else ll_mosi_low;	// bit4
		 ll_ck_cycle;
		if (d & 0x08)ll_mosi_high; else ll_mosi_low;	// bit3
		 ll_ck_cycle;
		if (d & 0x04)ll_mosi_high; else ll_mosi_low;	// bit2
		 ll_ck_cycle;
		if (d & 0x02)ll_mosi_high; else ll_mosi_low;	// bit1
		 ll_ck_cycle;
		if (d & 0x01)ll_mosi_high; else ll_mosi_low;	// bit0
		 ll_ck_cycle;

#else

		SPDR=*buff++;
		while(!(SPSR & (1<<SPIF)));
		//_delay_us(10);
#endif	

 	} while (--size);
 }

//#endif

#if 0

#define ll_spi_write

#endif
//kk

static void ILI9341_Select() {
	ll_cs_low;
    //HAL_GPIO_WritePin(ILI9341_CS_GPIO_Port, ILI9341_CS_Pin, GPIO_PIN_RESET);
}

void ILI9341_Unselect() {
	ll_cs_high;
    //HAL_GPIO_WritePin(ILI9341_CS_GPIO_Port, ILI9341_CS_Pin, GPIO_PIN_SET);
}

static void ILI9341_Reset() {
    // SOFTWARE RESET
    ILI9341_WriteCommand(0x01);
    HAL_Delay(1000);

    //HAL_GPIO_WritePin(ILI9341_RES_GPIO_Port, ILI9341_RES_Pin, GPIO_PIN_RESET);
    //HAL_Delay(5);
    //HAL_GPIO_WritePin(ILI9341_RES_GPIO_Port, ILI9341_RES_Pin, GPIO_PIN_SET);
}

 void ILI9341_WriteCommand(uint8_t cmd) {
//    HAL_GPIO_WritePin(ILI9341_DC_GPIO_Port, ILI9341_DC_Pin, GPIO_PIN_RESET);
    ll_dc_low;
#if 0
    HAL_SPI_Transmit(&ILI9341_SPI_PORT, &cmd, sizeof(cmd), HAL_MAX_DELAY);
#else
    ll_spi_write(&cmd, sizeof(cmd));
#endif
}

static void ILI9341_WriteData(uint8_t* buff, size_t buff_size) {
//    HAL_GPIO_WritePin(ILI9341_DC_GPIO_Port, ILI9341_DC_Pin, GPIO_PIN_SET);
	ll_dc_high;
    // split data in small chunks because HAL can't send more then 64K at once
    while(buff_size > 0) {
        uint16_t chunk_size = buff_size > 32768 ? 32768 : buff_size;
#if 0
        HAL_SPI_Transmit(&ILI9341_SPI_PORT, buff, chunk_size, HAL_MAX_DELAY);
#else
        ll_spi_write(buff, chunk_size);

#endif
        buff += chunk_size;
        buff_size -= chunk_size;
    }
}
//======================= - lowlevel - ===================================

#if 0
static void ILI9341_SetAddressWindow(uint16_t x0, uint16_t y0, uint16_t x1, uint16_t y1) {
    // column address set
    ILI9341_WriteCommand(0x2A); // CASET
    {
        uint8_t data[] = { (x0 >> 8) & 0xFF, x0 & 0xFF, (x1 >> 8) & 0xFF, x1 & 0xFF };
        ILI9341_WriteData(data, sizeof(data));
    }

    // row address set
    ILI9341_WriteCommand(0x2B); // RASET
    {
        uint8_t data[] = { (y0 >> 8) & 0xFF, y0 & 0xFF, (y1 >> 8) & 0xFF, y1 & 0xFF };
        ILI9341_WriteData(data, sizeof(data));
    }

    // write to RAM
    ILI9341_WriteCommand(0x2C); // RAMWR
}
#endif


static void ILI9341_SetAddressWindow_kk(uint16_t Xpos, uint16_t Ypos, uint16_t x1, uint16_t y1) {

#if ( DISP_ORIENTATION == 0 )//0° grad
			Xpos=MAX_X-Xpos;
			Ypos=MAX_Y-Ypos;
#endif
#if ( DISP_ORIENTATION == 1 )//0° grad
			uint16_t i=Xpos;
			Xpos=MAX_Y-Ypos;
			Ypos=i;
#endif
#if ( DISP_ORIENTATION == 2 )//0° grad
			//Xpos=Xpos;
			//Ypos=MAX_Y-Ypos;
#endif
#if ( DISP_ORIENTATION == 3 )//0° grad
			uint16_t i=Xpos;
			Xpos=Ypos;
			Ypos=MAX_X-i;
#endif
			uint16_t	x0=Xpos;
			uint16_t	y0=Ypos;
			x1=Xpos+1;
			y1=Ypos+1;

	// column address set
    ILI9341_WriteCommand(0x2A); // CASET
    {
        uint8_t data[] = { (x0 >> 8) & 0xFF, x0 & 0xFF, (x1 >> 8) & 0xFF, x1 & 0xFF };
        ILI9341_WriteData(data, sizeof(data));
    }

    // row address set
    ILI9341_WriteCommand(0x2B); // RASET
    {
        uint8_t data[] = { (y0 >> 8) & 0xFF, y0 & 0xFF, (y1 >> 8) & 0xFF, y1 & 0xFF };
        ILI9341_WriteData(data, sizeof(data));
    }

    // write to RAM
    ILI9341_WriteCommand(0x2C); // RAMWR
}


void lcd_init_() {
	ll_init();
    ILI9341_Select();
	
	
  
    // command list is based on https://github.com/martnak/STM32-ILI9341

    // SOFTWARE RESET
    ILI9341_WriteCommand(0x01);
    HAL_Delay(1000);
        
    // POWER CONTROL A
    ILI9341_WriteCommand(0xCB);
    {
        uint8_t data[] = { 0x39, 0x2C, 0x00, 0x34, 0x02 };
        ILI9341_WriteData(data, sizeof(data));
    }

    // POWER CONTROL B
    ILI9341_WriteCommand(0xCF);
    {
        uint8_t data[] = { 0x00, 0xC1, 0x30 };
        ILI9341_WriteData(data, sizeof(data));
    }
    // DRIVER TIMING CONTROL A
    ILI9341_WriteCommand(0xE8);
    {
        uint8_t data[] = { 0x85, 0x00, 0x78 };
        ILI9341_WriteData(data, sizeof(data));
    }

    // DRIVER TIMING CONTROL B
    ILI9341_WriteCommand(0xEA);
    {
        uint8_t data[] = { 0x00, 0x00 };
        ILI9341_WriteData(data, sizeof(data));
    }

    // POWER ON SEQUENCE CONTROL
    ILI9341_WriteCommand(0xED);
    {
        uint8_t data[] = { 0x64, 0x03, 0x12, 0x81 };
        ILI9341_WriteData(data, sizeof(data));
    }

    // PUMP RATIO CONTROL
    ILI9341_WriteCommand(0xF7);
    {
        uint8_t data[] = { 0x20 };
        ILI9341_WriteData(data, sizeof(data));
    }

    // POWER CONTROL,VRH[5:0]
    ILI9341_WriteCommand(0xC0);
    {
        uint8_t data[] = { 0x23 };
        ILI9341_WriteData(data, sizeof(data));
    }

    // POWER CONTROL,SAP[2:0];BT[3:0]
    ILI9341_WriteCommand(0xC1);
    {
        uint8_t data[] = { 0x10 };
        ILI9341_WriteData(data, sizeof(data));
    }

    // VCM CONTROL
    ILI9341_WriteCommand(0xC5);
    {
        uint8_t data[] = { 0x3E, 0x28 };
        ILI9341_WriteData(data, sizeof(data));
    }

    // VCM CONTROL 2
    ILI9341_WriteCommand(0xC7);
    {
        uint8_t data[] = { 0x86 };
        ILI9341_WriteData(data, sizeof(data));
    }

    // MEMORY ACCESS CONTROL
    ILI9341_WriteCommand(0x36);
    {
        uint8_t data[] = { 0x48 };
        ILI9341_WriteData(data, sizeof(data));
    }

    // PIXEL FORMAT
    ILI9341_WriteCommand(0x3A);
    {
        uint8_t data[] = { 0x55 };
        ILI9341_WriteData(data, sizeof(data));
    }

    // FRAME RATIO CONTROL, STANDARD RGB COLOR
    ILI9341_WriteCommand(0xB1);
    {
        uint8_t data[] = { 0x00, 0x18 };
        ILI9341_WriteData(data, sizeof(data));
    }

    // DISPLAY FUNCTION CONTROL
    ILI9341_WriteCommand(0xB6);
    {
        uint8_t data[] = { 0x08, 0x82, 0x27 };
        ILI9341_WriteData(data, sizeof(data));
    }

    // 3GAMMA FUNCTION DISABLE
    ILI9341_WriteCommand(0xF2);
    {
        uint8_t data[] = { 0x00 };
        ILI9341_WriteData(data, sizeof(data));
    }

    // GAMMA CURVE SELECTED
    ILI9341_WriteCommand(0x26);
    {
        uint8_t data[] = { 0x01 };
        ILI9341_WriteData(data, sizeof(data));
    }

    // POSITIVE GAMMA CORRECTION
    ILI9341_WriteCommand(0xE0);
    {
        uint8_t data[] = { 0x0F, 0x31, 0x2B, 0x0C, 0x0E, 0x08, 0x4E, 0xF1,
                           0x37, 0x07, 0x10, 0x03, 0x0E, 0x09, 0x00 };
        ILI9341_WriteData(data, sizeof(data));
    }

    // NEGATIVE GAMMA CORRECTION
    ILI9341_WriteCommand(0xE1);
    {
        uint8_t data[] = { 0x00, 0x0E, 0x14, 0x03, 0x11, 0x07, 0x31, 0xC1,
                           0x48, 0x08, 0x0F, 0x0C, 0x31, 0x36, 0x0F };
        ILI9341_WriteData(data, sizeof(data));
    }

    // EXIT SLEEP
    ILI9341_WriteCommand(0x11);
    HAL_Delay(120);

    // TURN ON DISPLAY
    ILI9341_WriteCommand(0x29);

    // MADCTL
    ILI9341_WriteCommand(0x36);
    {
        uint8_t data[] = { ILI9341_ROTATION };
        ILI9341_WriteData(data, sizeof(data));
    }

    ILI9341_Unselect();
}




void lcd_pixel(uint16_t Xpos,uint16_t Ypos,uint16_t color)
{
	if( Xpos >= MAX_X || Ypos >= MAX_Y )
	{
		return;
	}

	ILI9341_Select();
    ILI9341_SetAddressWindow_kk(Xpos, Ypos, Xpos+1, Ypos+1);
    uint8_t data[] = { color >> 8, color & 0xFF };
    ILI9341_WriteData(data, sizeof(data));
    ILI9341_Unselect();
}






//AVR lcd_char
void lcd_char_( uint8_t ASCI)
{	uint16_t i, j;
    uint16_t  tmp_char;
//Fontheader auswerten
//f_width= pgm_read_byte( &ptr_font[2]);
//f_height=pgm_read_byte( &ptr_font[3]);
//frame =pgm_read_byte( &ptr_font[4]);
//vertikal_zeichnen=pgm_read_byte( &ptr_font[5]);
//if (frame==1){f_width++;f_height+=2;}


u16 Xpos=curposx;
u16 Ypos=curposy;
if(frame){
//	if(!vertikal_zeichnen)Xpos=curposx-1+f_height;

for(i=0;i<f_width +1;i++){
//lcd_pixel(Xpos+f_height+1-frame_vert_versatz,Ypos+f_width-i-1, backcolor );}
lcd_pixel(Xpos-frame_vert_versatz+i,Ypos+1+frame_horz_versatz, backcolor );}

for(i=0;i<f_width +1;i++){
lcd_pixel( Xpos-frame_vert_versatz+i , Ypos-f_height+frame_horz_versatz,      backcolor );}

for(i=0;i<f_height+1;i++){
lcd_pixel( Xpos-frame_vert_versatz,Ypos-i+frame_horz_versatz, backcolor );}

//pos 1nach unten:
Xpos++;//90°Bildschirm sonst ypos++
}
Xpos=curposx+1;


//0x00,0x30,0x30,0x7E,0x30,0x30,0x30,0x30,0x30,0x1E,0x00,0x00,//"t",84+/

if(vertikal_zeichnen){
        for( j=0; j<f_width; j++ ){

tmp_char = pgm_read_byte( &ptr_font[(ASCI-32)*f_width+j+7]);
//uint8_t b = &ptr_font[(ASCI - 32)];
    for( i=0; i<f_height; i++ ){
 //   _delay_ms(100);
            if( ((tmp_char>>((f_height-1) - i)) & 0x01) == 0x01 ){
                lcd_pixel( Xpos +j , Ypos -i , frontcolor );  // Character color
             }else{
			if(backcolor!=TRANSPARENT)
                lcd_pixel( Xpos +j, Ypos -i , backcolor );  // Background color
            }
        }
    }
}else{
//Xpos=curposx+2-f_height;
/**/
for( i=0; i<f_height; i++ ){


	//0x00,0x30,0x30,0x7E,0x30,0x30,0x30,0x30,0x30,0x1E,0x00,0x00,//"t",84+/

//       tmp_char = buffer[i];
tmp_char = pgm_read_byte( &ptr_font[(ASCI-ascii_versatz)*f_height+i+7]);
//tmp_char = ( f8x12[(ASCI-ascii_versatz)*f_height+i+7]);
//testx[i]=f8x12[7+i+(ASCI-ascii_versatz)*f_height];
//testy[i]=7+i+(ASCI-ascii_versatz)*f_height;
//lcd_int3(tmp_char);lw(" ");

for( j=0; j<f_width; j++ ){
//   _delay_ms(100);
             if( ((tmp_char >>((f_width-1) - j)) & 0x01 )== 0x01 ){
     lcd_pixel( Xpos +j , Ypos +i , frontcolor );  // Character color
 //  lcd_pixel( Xpos -i , Ypos +j , frontcolor );  // Character color
            }else{
        if(backcolor!=TRANSPARENT)
		lcd_pixel( Xpos + j, Ypos +i , backcolor );
//      lcd_pixel( Xpos - i, Ypos +j , backcolor );  // Background color
            }
        }
    }
	}
}
//==================================================
void lcd_write_(uint8_t* str)
{
	while(*str>31)
    {
        lcd_char_(*str++);
        curposx =curposx+ f_width;
		if(frame)curposx++;
    }
}

//==================================================



void lcd_goto_(uint8_t Zeile,uint8_t Spalte){
curposx=(Spalte-1)*(f_width+frame);
curposy=(Zeile-1)*(f_height+2*frame)+lcd_zeilen_versatz;
//if(frame)curposy+=2;//-
}
//
void lcd_xy(u16 x,u16 y){curposx=x;curposy=y;}



void selectfont(uint8_t abfr){
switch (abfr){
case (1):
ptr_font=f5x7;
f_width=5;
f_height=7;
vertikal_zeichnen=1;
frame=1;lcd_zeilen_versatz=9;
ascii_versatz=32,frame_vert_versatz=0,frame_horz_versatz=0;
break;
case (2):
ptr_font=f8x12;f_width=8; f_height=12;vertikal_zeichnen=0; frame=0;lcd_zeilen_versatz=0;
ascii_versatz=32,frame_vert_versatz=0,frame_horz_versatz=0;
break;
case (3):
ptr_font=f3x5;f_width=3; f_height=5;vertikal_zeichnen=0; frame=1;lcd_zeilen_versatz=0;
ascii_versatz=32,frame_vert_versatz=0,frame_horz_versatz=4;
break;
case (4):
ptr_font=z8x10;f_width=8; f_height=10;vertikal_zeichnen=0; frame=0;lcd_zeilen_versatz=0;
ascii_versatz=0,frame_vert_versatz=0,frame_horz_versatz=4;
break;
case (5):
ptr_font=z8x4;f_width=8; f_height=4;vertikal_zeichnen=0; frame=0;lcd_zeilen_versatz=0;
ascii_versatz=0,frame_vert_versatz=0,frame_horz_versatz=4;
break;
}
}


void ILI9341_FillRectangle(uint16_t x, uint16_t y, uint16_t w, uint16_t h, uint16_t color) {
    // clipping
    if((x >= ILI9341_WIDTH) || (y >= ILI9341_HEIGHT)) return;
    if((x + w - 1) >= ILI9341_WIDTH) w = ILI9341_WIDTH - x;
    if((y + h - 1) >= ILI9341_HEIGHT) h = ILI9341_HEIGHT - y;

    ILI9341_Select();
    ILI9341_SetAddressWindow_kk(x, y, x+w-1, y+h-1);

    uint8_t data[] = { color >> 8, color & 0xFF };
 //   HAL_GPIO_WritePin(ILI9341_DC_GPIO_Port, ILI9341_DC_Pin, GPIO_PIN_SET);
ll_dc_high;
    for(y = h; y > 0; y--) {
        for(x = w; x > 0; x--) {
 #if 0
            HAL_SPI_Transmit(&ILI9341_SPI_PORT, data, sizeof(data), HAL_MAX_DELAY);
 #else
        ll_spi_write(data, sizeof(data));

#endif
        }
    }

    ILI9341_Unselect();
}







void lcd_clear_(uint16_t color)
{
   uint8_t data[] = { color >> 8, color & 0xFF };
	ILI9341_Select();
 for(int i=0;i<240;i++)
{
	for(int j=0;j<320;j++){
  ILI9341_SetAddressWindow_kk(i, j, i+1, j+1);
	ll_dc_high;
    ll_spi_write(data, 2);

 	}
}
    ILI9341_Unselect();
}

void lcd_light_(uint8_t x){;}

//==================================================



