/* vim: set ai et ts=4 sw=4: */
#ifndef __ILI9341_H__
#define __ILI9341_H__

//#include "fonts.h"
#include <stdbool.h>


#if 0
#include "kk_main.h"
#else
#include "main.h"
#include <util/delay.h>

#define pinset(x,y)  PORT(x)|=(1<<y)
#define pinclr(x,y)  PORT(x)&=~(1<<y)
#define pinget(x,y)  (PIN(x) & (1<<(y)))
#define HAL_Delay 		_delay_ms
#define reg_dir_in(x,y) DDR(x)&=~(1<<y)
#define reg_dir_out(x,y) DDR(x)|=(1<<y)

#endif

/****************************/
#define	MAX_X 240
#define	MAX_Y 320
#define	DISP_ORIENTATION  2
#define ili_bitbang       0
//======================= +lowlevel+ ===================================

#if 0 //stm
#define pgm_read_byte *



#define ll_cs_port      A
#define ll_cs_pin       15
#define ll_dc_port      B
#define ll_dc_pin       1

//#if use_bitbang_tft


#define ll_ck_port      B
#define ll_ck_pin       3
#define ll_mosi_port    B
#define ll_mosi_pin     5
#else

#define ll_cs_port      B
#define ll_cs_pin       1
#define ll_dc_port      B
#define ll_dc_pin       2

//#if use_bitbang_tft


#define ll_ck_port      B
#define ll_ck_pin       5
#define ll_mosi_port    B
#define ll_mosi_pin     3


#endif



//#define ll_miso_port    D
//#define ll_miso_pin     0



//#define ILI9341_RES_Pin       GPIO_PIN_13
//#define ILI9341_RES_GPIO_Port GPIOC
//#define ILI9341_CS_Pin        GPIO_PIN_15
//#define ILI9341_CS_GPIO_Port  GPIOA
//#define ILI9341_DC_Pin        GPIO_PIN_12
//#define ILI9341_DC_GPIO_Port  GPIOB


//#define ILI9341_SPI_PORT hspi4
//extern SPI_HandleTypeDef ILI9341_SPI_PORT;







#define ILI9341_MADCTL_MY  0x80
#define ILI9341_MADCTL_MX  0x40
#define ILI9341_MADCTL_MV  0x20
#define ILI9341_MADCTL_ML  0x10
#define ILI9341_MADCTL_RGB 0x00
#define ILI9341_MADCTL_BGR 0x08
#define ILI9341_MADCTL_MH  0x04

/*** Redefine if necessary ***/
// default orientation
#define ILI9341_WIDTH  240
#define ILI9341_HEIGHT 320
#define ILI9341_ROTATION (ILI9341_MADCTL_MX | ILI9341_MADCTL_BGR)

// rotate right
/*
#define ILI9341_WIDTH  320
#define ILI9341_HEIGHT 240
#define ILI9341_ROTATION (ILI9341_MADCTL_MX | ILI9341_MADCTL_MY | ILI9341_MADCTL_MV | ILI9341_MADCTL_BGR)
*/

// rotate left
/*
#define ILI9341_WIDTH  320
#define ILI9341_HEIGHT 240
#define ILI9341_ROTATION (ILI9341_MADCTL_MV | ILI9341_MADCTL_BGR)
*/

// upside down
/*
#define ILI9341_WIDTH  240
#define ILI9341_HEIGHT 320
#define ILI9341_ROTATION (ILI9341_MADCTL_MY | ILI9341_MADCTL_BGR)
*/

//#define lcd_goto lcd_goto_
//#define lcd_write lcd_write_
//#define lcd_init_ ILI9341_Init

// Color definitions
#define	ILI9341_BLACK   0x0000
#define	ILI9341_BLUE    0x001F
#define	ILI9341_RED     0xF800
#define	ILI9341_GREEN   0x07E0
#define ILI9341_CYAN    0x07FF
#define ILI9341_MAGENTA 0xF81F
#define ILI9341_YELLOW  0xFFE0
#define ILI9341_WHITE   0xFFFF
#define ILI9341_COLOR565(r, g, b) (((r & 0xF8) << 8) | ((g & 0xFC) << 3) | ((b & 0xF8) >> 3))

// call before initializing any SPI devices
void ILI9341_Unselect();

void lcd_init_(void);
void ILI9341_DrawPixel(uint16_t x, uint16_t y, uint16_t color);
//void ILI9341_WriteString(uint16_t x, uint16_t y, const char* str, FontDef font, uint16_t color, uint16_t bgcolor);
void ILI9341_FillRectangle(uint16_t x, uint16_t y, uint16_t w, uint16_t h, uint16_t color);
void ILI9341_FillScreen(uint16_t color);
void ILI9341_DrawImage(uint16_t x, uint16_t y, uint16_t w, uint16_t h, const uint16_t* data);
void ILI9341_InvertColors(bool invert);
void lcd_int(int32_t dat);
void lcd_pixel(uint16_t Xpos,uint16_t Ypos,uint16_t color);
void lcd_goto_(uint8_t Zeile,uint8_t Spalte);
void lcd_write_(uint8_t* str);
void selectfont(uint8_t abfr);
void lcd_light_(uint8_t x);


#endif // __ILI9341_H__
