#include "main.h"
#include <stdint.h> 
#include "std_lib_lcd.h"

#if ili9320_select
#include "ili9320.c"
#endif


#if i2clcd_select
#include "i2cmaster.c"
#include "i2clcd.c"
#endif


#if ili9341_select
#include "ili9341.c"
#endif



char hextablex[18] = "0123456789ABCDEF";

//--------------------------------------------------
void lcd_float3(float dat){
uint8_t dum[12]={' ',' ',' ',' ',' ','0','.','0','0','0',' ','\0'};
u8 n=0,z=0,pt=0,nk1,nk2,nk3,start;

//dat=-3.456;


if(dat<0)
{
	n=1;dat=-dat;
}
u16 vk=dat;


u16 nk=(float)(dat-vk)*1000;

nk1=nk/100;
nk2=(nk%100)/10;
nk3=nk%10;


dum[7]=nk1+48;
dum[8]=nk2+48;
dum[9]=nk3+48;


while(vk)
{
	z=vk%10;
	vk=vk/10;
	dum[5-pt]=z+48;
	pt++;
}


if(n)
{
	dum[5-pt]='-';
	pt++;
}


if(pt>3)
{
dum[6]=' ';
dum[7]='\0';
start=6-pt;
}
else
//if(pt==3)
{
start=5-n;
dum[11-pt]=' ';
dum[12-pt]='\0';
}

lw(dum+start); //li(pt);

return;

}







void lcd_int(int32_t dat){
uint8_t dum[8]={'0','0','0','0','0','0','0','\0'};
u8 n=0,z=0,pt=0;
if(dat==0)pt++;

if(dat<0){
n=1;dat=-dat;
}

while(dat){
z=dat%10;
dat=dat/10;
dum[6-pt]=z+48;
pt++;
}

if(n){
dum[6-pt]='-';
pt++;
}

//printf( "string %s \n", (dum+(7-pt)));
lcd_write(dum+(7-pt));
}

//-------------------------------------------
  void  lcd_hx(uint8_t byteX)
  //
  {
  uint8_t x;
	char dummy[3]={'0','0','\0'};
  x=byteX/16;
        dummy[0]= hextablex[x];
	 x=byteX%16;
       dummy[1]= hextablex[x];
 	lcd_write(dummy);	
  }
  
  
   void  lcd_hex(uint8_t byteX)
  //
  {
  lcd_write("x");
  lcd_hx(byteX);
}
//============================================================

  void  lcd_hex16(uint16_t byteX)
  //
  {
		lcd_write("x");
		lcd_hx(byteX>>8);
		lcd_hx(byteX & 0xff);
  }
 
void lcd_id(u8 *ptid){
	int i;
	for(i=0;i<8;i++)
	{
	lcd_hx(ptid[i]);
	}


/*
	uint8_t dum[17]={48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,'\0'};
	u8 i,x;
	for(i=0;i<8;i++){
	x=ptid[i]/16;
	
		if(x<10){
		dum[i*2]=(x+48);
		}else{
		dum[i*2]=(x+55);
		}
	x=ptid[i]%16;
	
		if(x<10){
		dum[i*2+1]=(x+48);
		}else{
		dum[i*2+1]=(x+55);
		}
	}
lcd_write(dum);
*/
}  
//---------------------------------------------------- 


  
 //---------------------------------------------------- 
 lcd_int4(i16 x){
	uint8_t dum[5]={' ',' ',' ','0','\0'};
	u8 neg=0;
if (x!=0)	
{
	
if (x<0){x=x*-1;neg=1;}

    if (x>999){
        dum[0]=(x/1000+48);
        x=x%1000;
		dum[1]='0';
		dum[2]='0';
		
        }
	
    if (x>99){
        dum[1]=(x/100+48);
        x=x%100;
		if(neg){neg=0;dum[0]='-';}
 		dum[2]='0';
       }
    if (x>9){
        dum[2]=(x/10+48);
        x=x%10;
		if(neg){neg=0;dum[1]='-';}
        }
         dum[3]=(x+48);
 		if(neg){dum[2]='-';}


}
    lcd_write(dum);
}
 
 //---------------------------------------------------- 
void lcd_int_10(i16 x){
	uint8_t dum[5]={' ','0',',','0','\0'};
	
	
	//    sprintf(dum, "The value of pi is %.2f.", pi);

	
	
	uint8_t keinkomma=0;
	u8 neg=0;
if (x!=0)	
{
	
if (x<0){x=x*-1;neg=1;}

    if (x>999){
        dum[0]=(x/1000+48);
        x=x%1000;
		dum[1]='0';
		dum[2]='0';
		keinkomma=1;
		
        }
	
    if (x>99){
		if(keinkomma==1)
			{
				dum[1]=(x/100+48);
				dum[2]='0';
			}
			else
			{
				dum[0]=(x/100+48);
				dum[1]='0';
			}
			
        x=x%100;
		if(neg){neg=0;dum[0]='-';}
       }

    if (x>9){
	
		if(keinkomma==1)
			{
				dum[2]=(x/10+48);
			}
		else
			{
				dum[1]=(x/10+48);
			}
			
        x=x%10;
		if(neg){neg=0;dum[1]='-';}
        }
		
         dum[3]=(x+48);
 		if(neg){dum[2]='-';}


}
    lcd_write(dum);
}
 
//---------------------------------------------------- 
void lcd_int2(uint8_t int1){
	uint8_t dum[3]={'0','0','\0'};
 if(int1<100){
    if (int1>9){
        dum[0]=(int1/10+48);
        int1=int1%10;
        }
        dum[1]=int1+48; 
        
     lcd_write(dum);
	 }
}

void lcd_int3(uint16_t int1){
	uint8_t dum[4]={' ',' ',48,'\0'};
	u8 s1=0;

    if (int1>99){
        dum[0]=(int1/100+48);
		s1=1;
		}
        int1=int1%100;

    if (int1>9 || s1){
        dum[1]=(int1/10+48);
		}
        int1=int1%10;
        
        dum[2]=int1+48; 
	 
        
     lcd_write(dum);
}

void lcd_int4x(int16_t int1){
	uint8_t dum[5]={' ',' ',' ',48,'\0'};
	u8 s1=0,n=0,zln=2;
	

if(int1<0){
n=1;int1=-int1;
}

	

    if (int1>999){
        dum[0]=(int1/1000+48);
		s1=1;
		zln=0;
		}
        int1=int1%1000;

    if (int1>99 || s1){
        dum[1]=(int1/100+48);
		s1=1;
		if(zln==2)zln=0;
		}
        int1=int1%100;

    if (int1>9 || s1){
        dum[2]=(int1/10+48);
		if(zln==2)zln=1;
		}
        int1=int1%10;
        
        dum[3]=int1+48; 
		
	 if(n)dum[zln]='-';
        
     lcd_write(dum);
}
/*
//============================================================
void lcd_int4(uint8_t int1){
	uint8_t dum[5]={48,48,48,48,'\0'};
    if (int1>9){
        dum[0]=(int1/1000+48);
        int1=int1%1000;
        }
        dum[1]=(int1/100+48);
        int1=int1%100;
        }
        dum[2]=(int1/10+48);
        int1=int1%10;
        }
        dum[3]=int1+48; 
        
     lcd_write(dum);
}*/
//============================================================

//---------------------------------------------------- 

//---------------------------------------------------- 


//---------------------------------------------------- 

//---------------------------------------------------- 


//---------------------------------------------------- 

//---------------------------------------------------- 


//---------------------------------------------------- 

//---------------------------------------------------- 




