'''
https://github.com/peter-l5/MicroPython_SCD4X/tree/main

'''
import scd4x
import machine
import time

i2c = machine.I2C(scl=machine.Pin(22), sda=machine.Pin(21)) # ESP32 example
#i2c = machine.I2C(0, sda=Pin(2), scl=Pin(3), freq=100000)   # RaspberryPi pico example
scd = scd4x.SCD4X(i2c)
scd.start_periodic_measurement()  # start_low_periodic_measurement() is a lower power alternative
print("startup wait")
time.sleep(5)  # Mandatory 5s wait for first measurement

#for n in range(10):
while True:
    if scd.data_ready:
        t = time.localtime()
        timestamp = "{:02d}:{:02d}:{:02d}".format(t[3], t[4], t[5])
    
        print(f"[{timestamp}] CO2: {scd.CO2} ppm, Temp: {scd.temperature:.2f}°C, RH: {scd.relative_humidity:.2f}%")
        #print(f"CO2: {scd.CO2} ppm, Temp: {scd.temperature:.2f}°C, RH: {scd.relative_humidity:.2f}%")
    else:
        print("Data not ready")
    time.sleep(5)  # SCD41 updates every 5s minimum
        
    
