import sys
import pyvisa
from datetime import datetime
import os
from pathlib import Path
import warnings

# Datei Pfad und Namen festlegen
ordner = Path.home() / "Pictures/Rigol Screenshots"
dateiName = "Rigol_DS1054_Screenshot"
dateiEndung = ".png"

# Prüfen, ob ein Parameter übergeben wurde
if len(sys.argv) > 1:
    dateiName = sys.argv[1]
    
IP = "xxx.xxx.xxx.xxx"

# Warnungen von pyvisa für HiSLIP unterdrücken
warnings.filterwarnings("ignore", category=UserWarning, module="pyvisa_py.tcpip")

def getSystemTime():
    # aktuelles Datum und Uhrzeit zusammenbauen
    zeitstempel: str = datetime.now().strftime("%y%m%d_%H%M%S")
    return zeitstempel

def modifiziereDateiName(name, endung):
    #dateiname, dateiendung = os.path.splitext(datei)
    neuerDateiname = f"{getSystemTime()}_{name}{endung}"
    # print(f"alter Dateiname: {dateiname}{dateiendung}")   
    # print("neuer Dateiname:", neuerDateiname)        
    return neuerDateiname  

dateipfad: str = ordner / (modifiziereDateiName(dateiName, dateiEndung))
print("Pfad & Dateiname:", dateipfad) 

# Initialisieren Sie den Resource Manager
rm = pyvisa.ResourceManager("@py")
# Alle verfügbaren Ressourcen auflisten
resources = rm.list_resources()
print("Gefundene Geräte:", resources)

scope = rm.open_resource(f"TCPIP::{IP}::INSTR")

print("Rigol erreichbar? ", scope.query("*IDN?"))

# Timeouts setzen
scope.timeout = 5000  
scope.write_termination = '\n'
scope.read_termination = None

# Screenshot als PNG anfordern
scope.write(":DISP:DATA? ON,OFF,PNG")

# Binärdaten lesen
data = scope.read_raw()

# Binär Header entfernen
# Format: b'#9XXXXXXXXX<data>'
header_length = int(data[1:2])
header_size = 2 + header_length
png_picture = data[header_size:]

# Datei speichern
with open(dateipfad, "wb") as file:
    file.write(png_picture)

# Egal was passiert, auf jeden Fall Datei schließen, ist nicht notwendig, ich weiß    
file.close()

print(f"Screenshot gespeichert unter: {dateipfad}")  

scope.close()
rm.close()
