
.equ ADS_ADR=72 		; 0x48

.equ ADS_MODE		=0
.equ ADS_PGA0		=1
.equ ADS_PGA1		=2
.equ ADS_PGA2		=3
.equ ADS_MUX0		=4
.equ ADS_MUX1		=5
.equ ADS_MUX2		=6
.equ ADS_OS	 		=7

.equ ADS_COMP_QUE0	=0
.equ ADS_COMP_QUE1	=1
.equ ADS_COMP_LAT	=2
.equ ADS_COMP_POL	=3
.equ ADS_COMP_MODE	=4
.equ ADS_DR0		=5
.equ ADS_DR1		=6
.equ ADS_DR2		=7
; ##############################################################################
; ##############################################################################
; ##############################################################################
;																				
;BIT 		15 	14 		13 		12 		11 	 	10   	9 		8				
;NAME		OS 	MUX2 	MUX1 	MUX0 	PGA2 	PGA1 	PGA0 	MODE			
;Default	1	0		0		0		0		1		0		1		X85(MSB)
;																				
;BIT		7  	6  	5  	4  			3  			2	 	 1 			0			
;NAME		DR2 DR1 DR0 COMP_MODE 	COMP_POL 	COMP_LAT COMP_QUE1 	COMP_QUE0	
;Default	1	0	0	0			0			0		1			1	x83(LSB)
;Default = 8583h																
;																				
; Bits [14:12] MUX[2:0]: Input multiplexer configuration (ADS1115 only)			
; 000 : AIN0 vs. AIN1 (default)													
; 001 : AIN0 vs. AIN3															
; 010 : AIN1 vs. AIN3															
; 011 : AIN2 vs. AIN3															
;*100 : AIN0 vs. GND															
; 101 : AIN1 vs. GND															
; 110 : AIN2 vs. GND															
;																				
; Bits [11:9] PGA[2:0]: Programmable gain amplifier configuration				
;*000 : FS = 6.144V															
; 001 : FS = 4.096V															
; 010 : FS = 2.048V (default)												
; 011 : FS = 1.024V															
; 100 : FS = 0.512V															
; 101 : FS = 0.256V															
; 110 : FS = 0.256V															
; 111 : FS = 0.256V															
;																				
ADS_INI:
	
	; Config RESET																
	ldi temp1,(ADS_ADR)							; TWI-ADR						
	rcall TWI_MASTER_TRANSMITTER_START_TEMP1
	ldi temp1,0b0000001 						; Config register				
	rcall TWI_MASTER_TRANSMITTER_DATEN_TEMP1
	ldi temp1,0x85								;(85h default)					
	rcall TWI_MASTER_TRANSMITTER_DATEN_TEMP1
	ldi temp1,0x83								;(83h default)					
	rcall TWI_MASTER_TRANSMITTER_DATEN_TEMP1	
	rcall TWI_STOP
	; Config read																
	rcall ADS_CONFIG_READ
	rcall WAIT_500ms
	; Config ERROR ?															
	LDS temp,(adr_ADS_LSB)						; LSB	x83						
	cpi temp,0x83
	brne ADS_ERROR	
	LDS temp,(adr_ADS_MSB)						; MSB	x85						
	cpi temp,0x85
	brne ADS_ERROR	
	; Config Write																
	ldi temp1,(ADS_ADR)							; TWI-ADR						
	rcall TWI_MASTER_TRANSMITTER_START_TEMP1
	ldi temp1,0b0000001 						; Config register				
	rcall TWI_MASTER_TRANSMITTER_DATEN_TEMP1

;	ldi temp1, 1<<ADS_OS|0<<ADS_MUX2|0<<ADS_MUX1|0<<ADS_MUX0|0<<ADS_PGA2|0<<ADS_PGA1|0<<ADS_PGA0|1<<ADS_MODE	; AIN0 vs AIN0 (default) X85 (LSB)					
	ldi temp1, 1<<ADS_OS|1<<ADS_MUX2|0<<ADS_MUX1|0<<ADS_MUX0|0<<ADS_PGA2|0<<ADS_PGA0|0<<ADS_PGA0|0<<ADS_MODE	; AIN0 vs GND PGA000 6.144V ADC:x0e05	
;	ldi temp1, 1<<ADS_OS|1<<ADS_MUX2|0<<ADS_MUX1|0<<ADS_MUX0|0<<ADS_PGA2|0<<ADS_PGA1|1<<ADS_PGA0|0<<ADS_MODE	; AIN0 vs GND PGA001 4.096V ADC:x1507	
;	ldi temp1, 1<<ADS_OS|1<<ADS_MUX2|0<<ADS_MUX1|0<<ADS_MUX0|0<<ADS_PGA2|1<<ADS_PGA1|0<<ADS_PGA0|0<<ADS_MODE	; AIN0 vs GND PGA010 2.048V ADC:x2a0e	
;	ldi temp1, 1<<ADS_OS|1<<ADS_MUX2|0<<ADS_MUX1|0<<ADS_MUX0|0<<ADS_PGA2|1<<ADS_PGA1|1<<ADS_PGA0|0<<ADS_MODE	; AIN0 vs GND PGA011 1.024V ADC:x5422	
;	ldi temp1, 1<<ADS_OS|1<<ADS_MUX2|0<<ADS_MUX1|0<<ADS_MUX0|1<<ADS_PGA2|0<<ADS_PGA1|0<<ADS_PGA0|0<<ADS_MODE	; AIN0 vs GND PGA100 0.512V ADC:x7fff	
;	ldi temp1, 1<<ADS_OS|1<<ADS_MUX2|0<<ADS_MUX1|0<<ADS_MUX0|1<<ADS_PGA2|0<<ADS_PGA1|1<<ADS_PGA0|0<<ADS_MODE	; AIN0 vs GND PGA101 0.256V ADC:x7fff	
;	ldi temp1, 1<<ADS_OS|1<<ADS_MUX2|0<<ADS_MUX1|0<<ADS_MUX0|1<<ADS_PGA2|1<<ADS_PGA1|0<<ADS_PGA0|0<<ADS_MODE	; AIN0 vs GND PGA110 0.256V ADC:x7fff	
;	ldi temp1, 1<<ADS_OS|1<<ADS_MUX2|0<<ADS_MUX1|0<<ADS_MUX0|1<<ADS_PGA2|1<<ADS_PGA1|1<<ADS_PGA0|0<<ADS_MODE	; AIN0 vs GND PGA111 0.256V ADC:x7fff	
	rcall TWI_MASTER_TRANSMITTER_DATEN_TEMP1

	ldi temp1, 0<<ADS_DR2|0<<ADS_DR1|0<<ADS_DR0|0<<ADS_COMP_MODE|0<<ADS_COMP_POL|0<<ADS_COMP_LAT|1<<ADS_COMP_QUE1|1<<ADS_COMP_QUE0	;(default) X83 (MSB)
	rcall TWI_MASTER_TRANSMITTER_DATEN_TEMP1
	rcall TWI_STOP
	rcall WAIT_100ms
	ret
;-------------------------------------------------------------------------------
ADS_ERROR:
	GRUEN_OFF
	GELB_ON
	ROT_ON
	rcall WAIT_100ms
	GELB_OFF
	ROT_OFF
	rcall WAIT_100ms
	rjmp ADS_ERROR
; ##############################################################################
; ##############################################################################
; ##############################################################################
ADS_READ_2_BYTES:
	STS(adr_DIGIT7),NULL						; ZEILE0 CLEAR				
	STS(adr_DIGIT6),NULL
	STS(adr_DIGIT5),NULL
	STS(adr_DIGIT4),NULL

	STS(adr_DIGIT3),NULL						; ZEILE1 CLEAR				
	STS(adr_DIGIT2),NULL
	STS(adr_DIGIT1),NULL
	STS(adr_DIGIT0),NULL
	rcall WAIT_50ms
	; read										
	ldi temp1,(ADS_ADR)							; TWI-ADR					
	rcall TWI_MASTER_RECEIVER_START_TEMP1
	rcall TWI_MASTER_RECEIVER_BYTE_TEMP1		; MSB						
	STS(adr_ADS_MSB),temp1
	rcall TWI_MASTER_RECEIVER_LAST_BYTE_TEMP1	; LSB						
	STS(adr_ADS_LSB),temp1
ret
; ##############################################################################
; ##############################################################################
; ##############################################################################
ADS_CONFIG_READ:
	; Zeiger auf Config Register				
	ldi temp1,(ADS_ADR)							; TWI-ADR					
	rcall TWI_MASTER_TRANSMITTER_START_TEMP1
	ldi temp1,0b0000001 						; Config register			
	rcall TWI_MASTER_TRANSMITTER_DATEN_TEMP1
	; read (2Bytes)								
	rcall ADS_READ_2_BYTES
	; Text "CONF"								
	ldi temp,(ASCII_C)
	STS(adr_DIGIT7),temp
	ldi temp,(ASCII_o_)	
	STS(adr_DIGIT6),temp
	ldi temp,(ASCII_n_)	
	STS(adr_DIGIT5),temp
	ldi temp,(ASCII_F)
	STS(adr_DIGIT4),temp
	; Wert										
	LDS temp1,(adr_ADS_LSB)						; LSB	x83					
	rcall FUNKTION_HEX_TEMP1
	STS(adr_DIGIT3),temp2
	STS(adr_DIGIT2),temp1	
	LDS temp1,(adr_ADS_MSB)						; MSB	x85					
	rcall FUNKTION_HEX_TEMP1
	STS(adr_DIGIT1),temp2
	STS(adr_DIGIT0),temp1
	rcall WAIT_500ms
ret
; ##############################################################################
; ##############################################################################
; ##############################################################################
ADS_ADC_READ:
	; Zeiger auf Conversion Register		
	ldi temp1,(ADS_ADR)							; TWI-ADR					
	rcall TWI_MASTER_TRANSMITTER_START_TEMP1
	ldi temp1,0b0000000 						; Conversion Register		
	rcall TWI_MASTER_TRANSMITTER_DATEN_TEMP1
	; read (2Bytes)								
	rcall ADS_READ_2_BYTES

;	rcall ADS_ADC_HEX							; Anzeige hexadezimal		
	rcall ADS_ADC_DEZIMAL						; Anzeige Dezimal			
ret
; ##############################################################################
; ##############################################################################
; ##############################################################################
; Bsp Si-Diode																	
; Ref: 1.024V ADC-Wert: 21.572(dez)												
; Ref: 6.144V ADC-Wert:  3.593(dez)												
ADS_ADC_DEZIMAL:
	LDS temp2,(adr_ADS_MSB)
	LDS temp1,(adr_ADS_LSB)
	clr temp3
	clr temp4
	rcall FUNKTION_BIN_ASC_32
	ldi temp,(ASCII_D)
	STS(adr_DIGIT7),temp8
	STS(adr_DIGIT6),temp7
	STS(adr_DIGIT5),temp6
	STS(adr_DIGIT4),temp5

	STS(adr_DIGIT3),temp4
	STS(adr_DIGIT2),temp3
	STS(adr_DIGIT1),temp2
	STS(adr_DIGIT0),temp1
	rcall WAIT_500ms		
ret
; ##############################################################################
; ##############################################################################
; ##############################################################################
; Bsp Si-Diode																	
; Ref: 1.024V ADC-Wert: 541c(hex)												
; Ref: 6.144V ADC-Wert: 0e09(hex)												
ADS_ADC_HEX:
	; Wert(hex)									
	ldi temp,(ASCII_A)
	STS(adr_DIGIT7),temp
	ldi temp,(ASCII_D)
	STS(adr_DIGIT6),temp
	ldi temp,(ASCII_c)
	STS(adr_DIGIT5),temp

	LDS temp1,(adr_ADS_MSB)
	rcall FUNKTION_HEX_TEMP1
	STS(adr_DIGIT3),temp2
	STS(adr_DIGIT2),temp1

	LDS temp1,(adr_ADS_LSB)
	rcall FUNKTION_HEX_TEMP1
	STS(adr_DIGIT1),temp2
	STS(adr_DIGIT0),temp1
	rcall WAIT_500ms
ret
; ##############################################################################
; ##############################################################################
; ##############################################################################

