; ##############################################################################
; ##############################################################################
; ##############################################################################
TIMER_AKTIVIEREN:
;																			
; Timer 0+1+2 berlauf-Int aktivieren (Timer/Counter Interrupt Mask)		
;																			
; TIMSK ==> OCIE2 TOIE2 TICIE1 OCIE1A OCIE1B TOIE1 R TOIE0  				
;																			
	ldi temp,(0<<OCIE2)|(0<<TOIE2)|(0<<TICIE1)|(0<<OCIE1A)|(0<<OCIE1B)|(1<<TOIE1)|(1<<TOIE0)
	out TIMSK,temp       
ret
; ##############################################################################
; ##############################################################################
; ##############################################################################
; TIMER0 (8Bit) Vorteiler													
;																			
; CS02 CS01 CS00 	Description												
;	0 	0 	0 		No clock source (Timer/Counter stopped).				
;	0 	0 	1 		clkI/O/		(No prescaling)								
; *	0 	1 	0 		clkI/O/8 	(From prescaler)							
; 	0 	1 	1 		clkI/O/64 	(From prescaler)							
; 	1 	0 	0 		clkI/O/256 	(From prescaler)							
; 	1 	0 	1 		clkI/O/1024 (From prescaler)							
;	1 	1 	0 		External clock source on T0 pin. Clock on falling edge.	
;	1 	1 	1 		External clock source on T0 pin. Clock on rising edge.	
TIMER0_INITIALISIERUNG:
	ldi temp,(0<<CS02)|(1<<CS01)|(0<<CS00)
	OUT TCCR0,temp
ret
; ##############################################################################
; ##############################################################################
; ##############################################################################
TIM0_OVF:
	sei					; interrupts freigeben					
	push TEMP		    ; Sichern von "TEMP" im Stack			
	in	 TEMP,SREG		; Einlesen des SREG 					
	push TEMP	    	; Schreiben von  SREG  im Stack (KOPIE)	
	push TEMP1			; Sichern von "TEMP1" im Stack			

	rcall ANZEIGE

	pop TEMP1			; Wiederherstellen von "TEMP1" 			
	pop	TEMP			; LESEN von SREG vom STACK (KOPIE)		
	out	SREG,TEMP		; Wiederherstellen von SREG				
	pop	TEMP			; Wiederherstellen von "TEMP" 			
reti
; ##############################################################################
; ##############################################################################
; ##############################################################################
; ##############################################################################
; ##############################################################################
; ##############################################################################
; Clock	High																	
.macro DISPLAY_DAT_H
	sbi (DAT_PORT),(DAT_PIN_NR)	; Data-Pin auf HIGH	
.endm							
; ##############################################################################
; ##############################################################################
; ##############################################################################
; Clock Low																		
.macro DISPLAY_DAT_L
	cbi (DAT_PORT),(DAT_PIN_NR)	; Data-Pin auf LOW	
.endm
; ##############################################################################
; ##############################################################################
; ##############################################################################
; Data shifts one place to the right on each LOW-to-HIGH transition of the clock (CP) input							
; and enters into Q0, which is the logical AND of the two data inputs (DSA and DSB) that							
;																													
; Bei jedem bergang von LOW nach HIGH des Takteingangs (CP) werden die Daten um eine Stelle nach rechts verschoben	
; und geht in Q0 ein, das das logische UND der beiden Dateneingnge (DSA und DSB) ist								
.macro ENABLE
	cbi (CLOCK_PORT),(CLOCK_PIN_NR)	; Clock-Pin auf LOW	
;	nop								; ggf.Pause			
	sbi (CLOCK_PORT),(CLOCK_PIN_NR)	; Clock-Pin auf HIGH
;	nop								; ggf.Pause			
.endm
ANZEIGE:
	mov temp,COUNTER_LED		; COUNTER laden							
	cpi temp,0
	breq DISPLAY_DIGIT0			; vergleich								
	cpi temp,1
	breq DISPLAY_DIGIT1			; vergleich								
	cpi temp,2
	breq DISPLAY_DIGIT2			; vergleich								
	cpi temp,3
	breq DISPLAY_DIGIT3			; vergleich								
	cpi temp,4
	breq DISPLAY_DIGIT4			; vergleich								
	cpi temp,5
	breq DISPLAY_DIGIT5			; vergleich								
	cpi temp,6
	breq DISPLAY_DIGIT6			; vergleich								
	rjmp DISPLAY_DIGIT7
;-------------------------------------------------------------------------------
;-------------------------------------------------------------------------------
DISPLAY_DIGIT0:
	inc COUNTER_LED				; Counter+1								
	LDS temp,(adr_DIGIT0)		; Balken laden							
	rcall DISPLAY_DATA_TEMP		; Balken anzeigen						
	ldi temp,0b01111111
	rjmp DISPLAY_DATA_TEMP
;-------------------------------------------------------------------------------
;-------------------------------------------------------------------------------
DISPLAY_DIGIT1:
	inc COUNTER_LED
	LDS temp,(adr_DIGIT1)
	rcall DISPLAY_DATA_TEMP
	ldi temp,0b10111111
	rjmp DISPLAY_DATA_TEMP
;-------------------------------------------------------------------------------
;-------------------------------------------------------------------------------
DISPLAY_DIGIT2:
	inc COUNTER_LED
	LDS temp,(adr_DIGIT2)
	rcall DISPLAY_DATA_TEMP
	ldi temp,0b11011111
	rjmp DISPLAY_DATA_TEMP
;-------------------------------------------------------------------------------
;-------------------------------------------------------------------------------
DISPLAY_DIGIT3:
	inc COUNTER_LED
	LDS temp,(adr_DIGIT3)
	rcall DISPLAY_DATA_TEMP
	ldi temp,0b11101111
	rjmp DISPLAY_DATA_TEMP
;-------------------------------------------------------------------------------
;-------------------------------------------------------------------------------
DISPLAY_DIGIT4:
	inc COUNTER_LED
	LDS temp,(adr_DIGIT4)
	rcall DISPLAY_DATA_TEMP
	ldi temp,0b11110111
	rjmp DISPLAY_DATA_TEMP
;-------------------------------------------------------------------------------
;-------------------------------------------------------------------------------
DISPLAY_DIGIT5:
	inc COUNTER_LED
	LDS temp,(adr_DIGIT5)
	rcall DISPLAY_DATA_TEMP
	ldi temp,0b11111011
	rjmp DISPLAY_DATA_TEMP
;-------------------------------------------------------------------------------
;-------------------------------------------------------------------------------
DISPLAY_DIGIT6:
	inc COUNTER_LED
	LDS temp,(adr_DIGIT6)
	rcall DISPLAY_DATA_TEMP
	ldi temp,0b11111101
	rjmp DISPLAY_DATA_TEMP
;-------------------------------------------------------------------------------
;-------------------------------------------------------------------------------
DISPLAY_DIGIT7:
	clr COUNTER_LED				; Counter NULL								
	LDS temp,(adr_DIGIT7)
	rcall DISPLAY_DATA_TEMP
	ldi temp,0b11111110
	rjmp DISPLAY_DATA_TEMP
; ##############################################################################
; ##############################################################################
; ##############################################################################
DISPLAY_DATA_TEMP:
;-------------------------------------------------------------------------------
; Punkt 			(L=on)														
	sbrc temp,7				; Skip if Bit in Register Cleared		
	DISPLAY_DAT_L		
	sbrs temp,7				; Skip if Bit in Register is Set		
	DISPLAY_DAT_H
	ENABLE
;-------------------------------------------------------------------------------
; g		 			(L=on)														
	sbrc temp,6				; Skip if Bit in Register Cleared		
	DISPLAY_DAT_L		
	sbrs temp,6				; Skip if Bit in Register is Set		
	DISPLAY_DAT_H
	ENABLE
;-------------------------------------------------------------------------------
; f		 			(L=on)														
	sbrc temp,5				; Skip if Bit in Register Cleared		
	DISPLAY_DAT_L		
	sbrs temp,5				; Skip if Bit in Register is Set		
	DISPLAY_DAT_H
	ENABLE
;-------------------------------------------------------------------------------
; e		 			(L=on)														
	sbrc temp,4				; Skip if Bit in Register Cleared		
	DISPLAY_DAT_L		
	sbrs temp,4				; Skip if Bit in Register is Set		
	DISPLAY_DAT_H
	ENABLE
;-------------------------------------------------------------------------------
; d		 			(L=on)														
	sbrc temp,3				; Skip if Bit in Register Cleared		
	DISPLAY_DAT_L		
	sbrs temp,3				; Skip if Bit in Register is Set		
	DISPLAY_DAT_H
	ENABLE
;-------------------------------------------------------------------------------
; c		 			(L=on)														
	sbrc temp,2				; Skip if Bit in Register Cleared		
	DISPLAY_DAT_L		
	sbrs temp,2				; Skip if Bit in Register is Set		
	DISPLAY_DAT_H
	ENABLE
;-------------------------------------------------------------------------------
; b		 			(L=on)														
	sbrc temp,1				; Skip if Bit in Register Cleared		
	DISPLAY_DAT_L		
	sbrs temp,1				; Skip if Bit in Register is Set		
	DISPLAY_DAT_H
	ENABLE
;-------------------------------------------------------------------------------
; a		 			(L=on)														
	sbrc temp,0				; Skip if Bit in Register Cleared		
	DISPLAY_DAT_L		
	sbrs temp,0				; Skip if Bit in Register is Set		
	DISPLAY_DAT_H
	ENABLE
ret
; ##############################################################################
; ##############################################################################
; ##############################################################################



