; ##############################################################################
; ##############################################################################
; ##############################################################################
;																				
;	Value: 0...	99.999.999														
;																				
;	INPUT: 	temp1	(BYTE1)														
;	 		temp2	(BYTE2)														
;			temp3	(BYTE3)														
;			temp4	(BYTE4)														
;																				
;	OUTPUT:	temp1	(		   1-er Stelle)										
;			temp2	(		  10-er Stelle)										
;			temp3	(        100-er Stelle)										
;			temp4	(      1.000-er Stelle)										
;			temp5	(     10.000-er Stelle)										
;			temp6	(    100.000-er Stelle)										
;			temp7	(  1.000.000-er Stelle)										
;			temp8	( 10.000.000-er Stelle)										
; 																				
; rcall FUNKTION_HEX_ASC_32	; INPUT: temp1...4 OUTPUT: Temp1...8				
; 																				
FUNKTION_BIN_ASC_32:
	clr temp
FUNKTION_HEX_ASC_10000000:; 10.000.000
	inc temp
	subi temp1, BYTE1    (10000000)
	sbci temp2, BYTE2    (10000000)
	sbci temp3, BYTE3    (10000000)
	sbci temp4, BYTE4    (10000000)
	brcc FUNKTION_HEX_ASC_10000000
	dec  temp
	subi temp, -48		; HEX->ASC
	push temp           ; temp (wird temp8) auf dem Stack sichern            
	subi temp1, BYTE1   (-10000000)
	sbci temp2, BYTE2   (-10000000)
	sbci temp3, BYTE3   (-10000000)
	sbci temp4, BYTE4   (-10000000)
	clr temp
FUNKTION_HEX_ASC_1000000:
	inc temp
	subi temp1, BYTE1    (1000000)
	sbci temp2, BYTE2    (1000000)
	sbci temp3, BYTE3    (1000000)
	brcc FUNKTION_HEX_ASC_1000000
	dec  temp
	subi temp, -48		; HEX->ASC
	push temp           ; temp (wird temp7) auf dem Stack sichern            
	subi temp1, BYTE1   (-1000000)
	sbci temp2, BYTE2   (-1000000)
	sbci temp3, BYTE3   (-1000000)
	clr temp
FUNKTION_HEX_ASC_100000:
	inc temp
	subi temp1, BYTE1    (100000)
	sbci temp2, BYTE2    (100000)
	sbci temp3, BYTE3    (100000)
	brcc FUNKTION_HEX_ASC_100000
	dec  temp
	subi temp, -48		; HEX->ASC
	push temp           ; temp (wird temp6) auf dem Stack sichern            
	subi temp1, BYTE1   (-100000)
	sbci temp2, BYTE2   (-100000)
	sbci temp3, BYTE3   (-100000)
	clr temp
FUNKTION_HEX_ASC_10000:
	inc temp
	subi temp1, BYTE1    (10000)
	sbci temp2, BYTE2    (10000)
	sbci temp3, BYTE3    (10000)
	brcc FUNKTION_HEX_ASC_10000
	dec  temp
	subi temp, -48		; HEX->ASC
	push temp           ; temp (wird temp5) auf dem Stack sichern            
	subi temp1, BYTE1  (-10000)
	sbci temp2, BYTE2  (-10000)
	sbci temp3, BYTE3  (-10000)
	clr temp
FUNKTION_HEX_ASC_1000:
	inc temp
	subi temp1, low  (1000)
	sbci temp2, HIGH (1000)
	brcc FUNKTION_HEX_ASC_1000
	dec temp
	subi temp, -48		; HEX->ASC
	push temp           ; temp (wird temp4) auf dem Stack sichern            
	subi temp1, low  (-1000)
	sbci temp2, HIGH (-1000)
	clr temp
FUNKTION_HEX_ASC_100:
	inc temp
	subi temp1, low  (100)
	sbci temp2, HIGH (100)
	brcc FUNKTION_HEX_ASC_100
	dec temp
	subi temp, -48		; HEX->ASC
	push temp           ; temp (wird temp3) auf dem Stack sichern            
	subi temp1, low  (-100)
	sbci temp2, HIGH (-100)
	clr temp
FUNKTION_HEX_ASC_10:
	inc temp
	subi temp1, low  (10)
	sbci temp2, HIGH (10)
	brcc FUNKTION_HEX_ASC_10
	dec temp
	subi temp, -48		; HEX->ASC
	push temp           ; temp (wird temp2) auf dem Stack sichern            
	subi temp1, low  (-10)
	sbci temp2, HIGH (-10)
FUNKTION_HEX_ASC_1:	
	subi temp1, -48		; HEX->ASC

	pop	TEMP2			; LESEN vom STACK (KOPIE)
	pop	TEMP3			; LESEN vom STACK (KOPIE)
	pop	TEMP4			; LESEN vom STACK (KOPIE)
	pop	TEMP5			; LESEN vom STACK (KOPIE)
	pop	TEMP6			; LESEN vom STACK (KOPIE)
	pop	TEMP7			; LESEN vom STACK (KOPIE)
	pop	TEMP8			; LESEN vom STACK (KOPIE)

	; auf 7 SEGNMENT
	mov temp,temp1
	rcall FUNKTION_7_SEGMENT
	mov temp1,temp

	mov temp,temp2
	rcall FUNKTION_7_SEGMENT
	mov temp2,temp


	mov temp,temp3
	rcall FUNKTION_7_SEGMENT
	mov temp3,temp

	mov temp,temp4
	rcall FUNKTION_7_SEGMENT
	mov temp4,temp

	mov temp,temp5
	rcall FUNKTION_7_SEGMENT
	mov temp5,temp

	mov temp,temp6
	rcall FUNKTION_7_SEGMENT
	mov temp6,temp

	mov temp,temp7
	rcall FUNKTION_7_SEGMENT
	mov temp7,temp

	mov temp,temp8
	rcall FUNKTION_7_SEGMENT
	mov temp8,temp
; Nullstellen																	

	cpi temp8,(ASCII_0)
	brne FUNKTION_HEX_ASC_RUN
	clr temp8

	cpi temp7,(ASCII_0)
	brne FUNKTION_HEX_ASC_RUN
	clr temp7

	cpi temp6,(ASCII_0)
	brne FUNKTION_HEX_ASC_RUN
	clr temp6

	cpi temp5,(ASCII_0)
	brne FUNKTION_HEX_ASC_RUN
	clr temp5

	cpi temp4,(ASCII_0)
	brne FUNKTION_HEX_ASC_RUN
	clr temp4

	cpi temp3,(ASCII_0)
	brne FUNKTION_HEX_ASC_RUN
	clr temp3

	cpi temp2,(ASCII_0)
	brne FUNKTION_HEX_ASC_RUN
	clr temp2

FUNKTION_HEX_ASC_RUN:
ret
; ##############################################################################
; ##############################################################################
; ##############################################################################
FUNKTION_7_SEGMENT:
	cpi temp,'0'
	breq FUNKTION_7_SEGMENT_0
	cpi temp,'1'
	breq FUNKTION_7_SEGMENT_1
	cpi temp,'2'
	breq FUNKTION_7_SEGMENT_2
	cpi temp,'3'
	breq FUNKTION_7_SEGMENT_3
	cpi temp,'4'
	breq FUNKTION_7_SEGMENT_4
	cpi temp,'5'
	breq FUNKTION_7_SEGMENT_5
	cpi temp,'6'
	breq FUNKTION_7_SEGMENT_6
	cpi temp,'7'
	breq FUNKTION_7_SEGMENT_7
	cpi temp,'8'
	breq FUNKTION_7_SEGMENT_8
	cpi temp,'9'
	breq FUNKTION_7_SEGMENT_9
	; ERROR
	ldi temp, (ASCII_E)
	ret
FUNKTION_7_SEGMENT_0:
	ldi temp, (ASCII_0)
	ret
FUNKTION_7_SEGMENT_1:
	ldi temp, (ASCII_1)
	ret
FUNKTION_7_SEGMENT_2:
	ldi temp, (ASCII_2)
	ret
FUNKTION_7_SEGMENT_3:
	ldi temp, (ASCII_3)
	ret
FUNKTION_7_SEGMENT_4:
	ldi temp, (ASCII_4)
	ret
FUNKTION_7_SEGMENT_5:
	ldi temp, (ASCII_5)
	ret
FUNKTION_7_SEGMENT_6:
	ldi temp, (ASCII_6)
	ret
FUNKTION_7_SEGMENT_7:
	ldi temp, (ASCII_7)
	ret
FUNKTION_7_SEGMENT_8:
	ldi temp, (ASCII_8)
	ret
FUNKTION_7_SEGMENT_9:
	ldi temp, (ASCII_9)
ret
;######################################################################## 	
;########################################################################	
;######################################################################## 	
NULLSTELLENUNTERDRUECKUNG:

	cpi temp8,(ASCII_0)
	brne NULL_FERTIG
	ldi temp8,(ASCII_AUS)

	cpi temp7,(ASCII_0)
	brne NULL_FERTIG
	ldi temp7,(ASCII_AUS)

	cpi temp6,(ASCII_0)
	brne NULL_FERTIG
	ldi temp6,(ASCII_AUS)

	cpi temp5,(ASCII_0)
	brne NULL_FERTIG
	ldi temp5,(ASCII_AUS)

	cpi temp4,(ASCII_0)
	brne NULL_FERTIG
	ldi temp4,(ASCII_AUS)

	cpi temp3,(ASCII_0)
	brne NULL_FERTIG
	ldi temp3,(ASCII_AUS)

	cpi temp2,(ASCII_0)
	brne NULL_FERTIG
	ldi temp2,(ASCII_AUS)

	cpi temp1,(ASCII_0)
	brne NULL_FERTIG
	ldi temp1,(ASCII_0)

NULL_FERTIG:

ret
;######################################################################## 	
;########################################################################	
;######################################################################## 	
; INP: temp1																
; OUT: temp1+2 (z.B."FF") 													
FUNKTION_HEX_TEMP1:
	; SICHERUNGSKOPIE						
	push temp
	; 1-er STELLE		
	mov temp2,temp1
	mov temp,temp1	

	rcall FUNKTION_HEX_UMWANDLUNG
	mov temp1,temp
	; 10-er STELLE		
	mov temp,temp2	
	; NIBBLES tausch	
	swap temp
	rcall FUNKTION_HEX_UMWANDLUNG
	mov temp2,temp
	; SICHERUNGSKOPIE wieder herstellen		
	pop temp
	ret
;-------------------------------------------------------------------------------
FUNKTION_HEX_UMWANDLUNG:
	; BITMUSTER	
	andi temp,0b00001111
	; vergleich	
	cpi temp,0
	breq FUNKTION_HEX_0
	cpi temp,1
	breq FUNKTION_HEX_1
	cpi temp,2
	breq FUNKTION_HEX_2
	cpi temp,3
	breq FUNKTION_HEX_3
	cpi temp,4
	breq FUNKTION_HEX_4
	cpi temp,5
	breq FUNKTION_HEX_5
	cpi temp,6
	breq FUNKTION_HEX_6
	cpi temp,7
	breq FUNKTION_HEX_7
	cpi temp,8
	breq FUNKTION_HEX_8
	cpi temp,9
	breq FUNKTION_HEX_9
	cpi temp,10
	breq FUNKTION_HEX_A
	cpi temp,11
	breq FUNKTION_HEX_B
	cpi temp,12
	breq FUNKTION_HEX_C
	cpi temp,13
	breq FUNKTION_HEX_D
	cpi temp,14
	breq FUNKTION_HEX_E
	cpi temp,15
	breq FUNKTION_HEX_F

FUNKTION_HEX_0:
	ldi temp,(ASCII_0)
	ret
FUNKTION_HEX_1:
	ldi temp,(ASCII_1)
	ret
FUNKTION_HEX_2:
	ldi temp,(ASCII_2)
	ret
FUNKTION_HEX_3:
	ldi temp,(ASCII_3)
	ret
FUNKTION_HEX_4:
	ldi temp,(ASCII_4)
	ret
FUNKTION_HEX_5:
	ldi temp,(ASCII_5)
	ret
FUNKTION_HEX_6:
	ldi temp,(ASCII_6)
	ret
FUNKTION_HEX_7:
	ldi temp,(ASCII_7)
	ret
FUNKTION_HEX_8:
	ldi temp,(ASCII_8)
	ret
FUNKTION_HEX_9:
	ldi temp,(ASCII_9)
	ret
FUNKTION_HEX_A:
	ldi temp,(ASCII_A)
	ret
FUNKTION_HEX_B:
	ldi temp,(ASCII_B)
	ret
FUNKTION_HEX_C:
	ldi temp,(ASCII_C)
	ret
FUNKTION_HEX_D:
	ldi temp,(ASCII_D)
	ret
FUNKTION_HEX_E:
	ldi temp,(ASCII_E)
	ret
FUNKTION_HEX_F:
	ldi temp,(ASCII_F)
ret
;######################################################################## 	
;########################################################################	
;######################################################################## 	
