;												
; LED 3xSA23  7-SEGMENT							
;												
; ATmega8										
; 1 MHz											
;												
; Bernhard.Erfurt@gmx.de						
; 12/2025										
;												


; Anschlussbelegung PINS						
;												
; PB0 ==> 
; PB1 ==> 
; PB2 ==> 
; PB3 ==> 
; PB4 ==> 
; PB5 ==> 
; PB6 ==> 
; PB7 ==> 
;												
; PC0 ==> LED Data								
; PC1 ==> LED CLC								
; PC2 ==> 										
; PC3 ==> 										
; PC4 ==> 										
; PC5 ==> 
;												
; PD0 ==> 
; PD1 ==> 
; PD2 ==> 										
; PD3 ==> 										
; PD4 ==> 
; PD5 ==> 
; PD6 ==> 
; PD7 ==> 
;												


; ATmega8 										
.include "m8def.inc"
.include "MACRO.asm"
; KONSTANTEN									
.equ TAKT					=1000000			
; LED-CP(Clock)									
.equ CLOCK_PIN_NR		= 0
.equ CLOCK_DDR			= DDRB
.equ CLOCK_PORT			= PORTB
; LED-DAT(Daten)								
.equ DAT_PIN_NR			= 1
.equ DAT_DDR			= DDRB
.equ DAT_PORT			= PORTB
; LED-GRUEN										
.equ GRUEN_PIN_NR		= 5
.equ GRUEN_DDR			= DDRD
.equ GRUEN_PORT			= PORTD
; LED-GELB										
.equ GELB_PIN_NR		= 6
.equ GELB_DDR			= DDRD
.equ GELB_PORT			= PORTD
; LED-ROT										
.equ ROT_PIN_NR			= 7
.equ ROT_DDR			= DDRD
.equ ROT_PORT			= PORTD
; ZEICHEN-DARSTELLUNG - 7-SEGMENT								
.equ ASCII_0			=0b00111111	; 0 
.equ ASCII_1			=0b00000110	; 1 
.equ ASCII_2			=0b01011011	; 2 
.equ ASCII_3			=0b01001111	; 3 
.equ ASCII_4			=0b01100110	; 4 
.equ ASCII_5			=0b01101101	; 5 
.equ ASCII_6			=0b01111101	; 6 
.equ ASCII_7			=0b00000111	; 7 
.equ ASCII_8			=0b01111111	; 8 
.equ ASCII_9			=0b01101111	; 9 

.equ ASCII_AUS			=0b00000000	; ''
.equ ASCII_PUNKT		=0b10000000	; . 
.equ ASCII_VOLL			=0b11111111	; 8.
.equ ASCII_MINUS		=0b01000000	; - 
.equ ASCII_GRD			=0b01100011	;  
.equ ASCII_POS			=0b00100011	;/\ 
.equ ASCII_NEG			=0b00011100	;\/ 

.equ ASCII_A			=0b01110111	; A 
.equ ASCII_B			=0b01111100	; B 
.equ ASCII_C			=0b00111001	; C 
.equ ASCII_D			=0b01011110	; D 
.equ ASCII_E			=0b01111001	; E 
.equ ASCII_F			=0b01110001	; F 
.equ ASCII_P			=0b01110011	; P	
.equ ASCII_S			=0b01101101	; S
 
.equ ASCII_o_			=0b01011100	; o	
.equ ASCII_n_			=0b01010100	; n	

; SRAM-BELEGUNG ATmega8							
.equ adr_DATEN					=0x0060			; 0x0060 START Adresse 		

.equ adr_ZEIGER					=adr_DATEN+15

.equ adr_DIGIT0					=adr_DATEN+20 
.equ adr_DIGIT1					=adr_DATEN+21 
.equ adr_DIGIT2					=adr_DATEN+22 
.equ adr_DIGIT3					=adr_DATEN+23 
.equ adr_DIGIT4					=adr_DATEN+24 
.equ adr_DIGIT5					=adr_DATEN+25 
.equ adr_DIGIT6					=adr_DATEN+26 
.equ adr_DIGIT7					=adr_DATEN+27 

.equ adr_ADS_MSB				=adr_DATEN+100
.equ adr_ADS_LSB				=adr_DATEN+101

; REGISTER										

.def ERROR			= R9

.def NULL 			= R10
.def EINS 			= R11
.def VOLL			= R12
.def COUNTER_LED	= R13

.def temp 			= R16
.def temp1 			= R17
.def temp2 			= R18
.def temp3 			= R19
.def temp4 			= R20
.def temp5 			= R21
.def temp6 			= R22
.def temp7 			= R23
.def temp8 			= R24
.def temp9 			= R25





.cseg					;Beginn eines Code-Segmentes
.org 0					;Startadresse=0

rjmp RESET      		; Reset Handler                           				
rjmp INTERRUPT_ERROR	;rjmp EXT_INT0   ; IRQ0 Handler                      	
rjmp INTERRUPT_ERROR	;rjmp EXT_INT1   ; IRQ1 Handler                      	
rjmp INTERRUPT_ERROR	;rjmp TIM2_COMP  ; Timer2 Compare Handler            	
rjmp INTERRUPT_ERROR	;rjmp TIM2_OVF   ; Timer2 Overflow Handler           	
rjmp INTERRUPT_ERROR	;rjmp TIM1_CAPT  ; Timer1 Capture Handler            	
rjmp INTERRUPT_ERROR	;rjmp TIM1_COMPA ; Timer1 CompareA Handler           	
rjmp INTERRUPT_ERROR	;rjmp TIM1_COMPB ; Timer1 CompareB Handler           	
rjmp INTERRUPT_ERROR	;rjmpTIM1_OVF    ; Timer1 Overflow Handler       		
rjmp TIM0_OVF   		;Timer0 Overflow Handler           						
rjmp INTERRUPT_ERROR	;rjmp SPI_STC    ; SPI Transfer Complete Handler     	
rjmp INTERRUPT_ERROR	; USART RX Complete Handler         					
rjmp INTERRUPT_ERROR	;rjmp USART_UDRE ; UDR Empty Handler                 	
rjmp INTERRUPT_ERROR	;rjmp USART_TXC  ; USART TX Complete Handler         	
rjmp INTERRUPT_ERROR	;rjmp ADC        ; ADC Conversion Complete Handler   	
rjmp INTERRUPT_ERROR	;rjmp EE_RDY     ; EEPROM Ready Handler              	
rjmp INTERRUPT_ERROR	;rjmp ANA_COMP   ; Analog Comparator Handler         	
rjmp INTERRUPT_ERROR	;rjmp TWSI       ; Two-wire Serial Interface Handler 	
rjmp INTERRUPT_ERROR	;rjmp SPM_RDY    ; Store Program Memory Ready Handler	


; Bei unkorrekten Interrupt aufrufen erfolgt ein RESET ber WDR	
INTERRUPT_ERROR:
	GRUEN_ON
	GELB_ON
	ROT_ON
	rcall WAIT_100ms
	GRUEN_OFF
	GELB_OFF
	ROT_OFF
	rcall WAIT_100ms
	rjmp INTERRUPT_ERROR

RESET:                        
; STACK initialisieren								
	ldi temp, LOW(RAMEND)
    out SPL, temp
    ldi temp, HIGH(RAMEND)
    out SPH, temp
; Watchdog aktivieren (max. Zeit)					
	ldi TEMP,(1<<WDCE)|(1<<WDE)  
	out wdtcr,TEMP       
	ldi TEMP,(1<<WDE) | (1<<WDP2)|(1<<WDP1)|(1<<WDP0) 
	out wdtcr,temp
; SRAM lschen										
SRAM_CLEAR:
	ldi ZL, LOW (adr_DATEN)
	ldi ZH, HIGH(adr_DATEN)
	clr temp
SRAM_CLEAR_w:
	ST z+,temp
	cpi ZH, HIGH(RAMEND); Vergleich?		
	brlo SRAM_CLEAR_w	; kleiner => SPRUNG	
	cpi ZL, LOW(RAMEND)	; Vergleich?		
	brlo SRAM_CLEAR_w	; kleiner => SPRUNG	
	breq SRAM_CLEAR_w	; gleich  => SPRUNG	
; TIMER_INITIALISIERUNG								
	rcall TIMER0_INITIALISIERUNG
; TIMER_AKTIVIEREN									
	rcall TIMER_AKTIVIEREN
; Port Initialisierung								
	rcall PORT_INITIALISIERUNG
; STARTWERTE										
	rcall STARTWERTE
; TWI Initialisierung								
	rcall TWI_INI
; interrupts freigeben								
	sei
; Begrssung "ADS1115"										
	ldi temp,(ASCII_A)
	STS(adr_DIGIT7),temp
	ldi temp,(ASCII_d)
	STS(adr_DIGIT6),temp
	ldi temp,(ASCII_S)
	STS(adr_DIGIT5),temp
	clr temp
	STS(adr_DIGIT4),temp

	ldi temp,(ASCII_1)
	STS(adr_DIGIT3),temp
	ldi temp,(ASCII_1)
	STS(adr_DIGIT2),temp
	ldi temp,(ASCII_1)
	STS(adr_DIGIT1),temp
	ldi temp,(ASCII_5)
	STS(adr_DIGIT0),temp
	rcall WAIT_1000ms

	rcall ADS_INI
; ##############################################################################
; ##############################################################################
; ##############################################################################
LOOP:
	rcall PROGRAMM_CHECK
	rcall ADS_ADC_READ
rjmp LOOP
; ##############################################################################
; ##############################################################################
; ##############################################################################
.include "ZAHLEN.asm"
.include "TIMER.asm"
.include "ADS115.asm"
.include "TWI.asm"
.include "SONSTIGES.asm"
.include "WAIT.asm"
