#include <stdbool.h>
#include <stdint.h> 
#include <stdlib.h>
#include <avr/pgmspace.h>
#include "main.h"
#include <util/delay.h>
#include "i2clcd.h"
#include "i2cmaster.h"

// constant string in Flash, user char 7 at the end

const char string_flash[] PROGMEM = "Hello Flash! \x7";

// user char, euro symbol

const char my_char1[] PROGMEM = {0x06, 0x09, 0x10, 0x0E, 0x10, 0x09, 0x06, 0x00};

int main(void)
{
	char string1[] = "Hello World!";
    uint16_t start, end;
    int i;

    // timer 1 for performance test
    TCCR1B = (1<<CS12) | (1<<CS10);         // prescaler 1024 -> 7,8kHz

	i2c_init();
    // now with support for up to 8 LCDs 
    lcd_set_i2c_addr(0, 0x20);    // 7 bit I2C address!
    lcd_set_i2c_addr(1, 0x21);
    lcd_set_i2c_addr(2, 0x22);

    for (i=0; i<3; i++) { 
        lcd_select_display(i);
    	lcd_init();    
        // always set all three parameters  (ON/OFF) when using this command
	    lcd_command(LCD_DISPLAYON | LCD_CURSORON | LCD_BLINKINGON);
        lcd_light(true);
    }

    lcd_select_display(0);
	lcd_print(string1);

    //while(1);
	lcd_nextline();
    lcd_print_P(PSTR("I2CLCD V0.12"));
        
    // define user character
    lcd_def_char(my_char1, 7);

    _delay_ms(3000);

    lcd_command(LCD_CLEAR);
    _delay_ms(2);
    lcd_print_P(string_flash);
    lcd_printlc_P(2, 2, string_flash);
    _delay_ms(3000);

    lcd_command(LCD_CLEAR);
    _delay_ms(2);
    lcd_printlc_P(1, 1, PSTR("*** Hallo Achim! ***"));
    lcd_printlc_P(2, 1, PSTR("  Poll** hat sch" "\xEF" "ne "));
    lcd_printlc_P(3, 1, PSTR("     4x20 LCDs      "));
    lcd_printlc_P(4, 1, PSTR(";-) ;-) ;-) ;-) ;-) "));    

	lcd_command(LCD_DISPLAYON | LCD_CURSOROFF | LCD_BLINKINGOFF);
    _delay_ms(3000);

    // performance test

    start = TCNT1;
    lcd_gotolc(1,1);
    lcd_print_P(PSTR("123456789ABCDEFGHIJ"));
    lcd_gotolc(2,1);
    lcd_print_P(PSTR("123456789ABCDEFGHIJ"));
    lcd_gotolc(3,1);
    lcd_print_P(PSTR("123456789ABCDEFGHIJ"));
    lcd_gotolc(4,1);
    lcd_print_P(PSTR("123456789ABCDEFGHIJ"));
    end = TCNT1;

    lcd_command(LCD_CLEAR);
    _delay_ms(5);
    lcd_print_P(PSTR("Counts:"));
    itoa(end-start, string1, 10);
    lcd_print(string1);
    lcd_nextline();
    itoa((end-start)*(1024000000/F_CPU)/80, string1, 10);
    lcd_print(string1);
    lcd_print_P(PSTR("us/char"));

    //-	Endless loop
	
    while (1) {
    
    }
}
