
.equ ADS_ADR=0x48   ; 8 Bit Adresse, R/W bit = 0

.equ ADS_MODE       =0
.equ ADS_PGA0       =1
.equ ADS_PGA1       =2
.equ ADS_PGA2       =3
.equ ADS_MUX0       =4
.equ ADS_MUX1       =5
.equ ADS_MUX2       =6
.equ ADS_OS         =7

.equ ADS_COMP_QUE0  =0
.equ ADS_COMP_QUE1  =1
.equ ADS_COMP_LAT   =2
.equ ADS_COMP_POL   =3
.equ ADS_COMP_MODE  =4
.equ ADS_DR0        =5
.equ ADS_DR1        =6
.equ ADS_DR2        =7
; ##############################################################################
; ##############################################################################
; ##############################################################################
;                                                                               
;BIT        15  14      13      12      11      10      9       8               
;NAME       OS  MUX2    MUX1    MUX0    PGA2    PGA1    PGA0    MODE            
;Default    1   0       0       0       0       1       0       1       X85(MSB)
;                                                                               
;BIT        7   6   5   4           3           2        1          0           
;NAME       DR2 DR1 DR0 COMP_MODE   COMP_POL    COMP_LAT COMP_QUE1  COMP_QUE0   
;Default    1   0   0   0           0           0       1           1   x83(LSB)
;Default = 8583h                                                                
;                                                                               
; Bits [14:12] MUX[2:0]: Input multiplexer configuration (ADS1115 only)         
; 000 : AIN0 vs. AIN1 (default)                                                 
; 001 : AIN0 vs. AIN3                                                           
; 010 : AIN1 vs. AIN3                                                           
; 011 : AIN2 vs. AIN3                                                           
;*100 : AIN0 vs. GND                                                            
; 101 : AIN1 vs. GND                                                            
; 110 : AIN2 vs. GND                                                            
;                                                                               
; Bits [11:9] PGA[2:0]: Programmable gain amplifier configuration               
;*000 : FS = 6.144V                                                            
; 001 : FS = 4.096V                                                            
; 010 : FS = 2.048V (default)                                              
; 011 : FS = 1.024V                                                            
; 100 : FS = 0.512V                                                            
; 101 : FS = 0.256V                                                            
; 110 : FS = 0.256V                                                            
; 111 : FS = 0.256V                                                            
;                                                                               
ads_init:
    ; Config RESET                                                              
    ldi     temp1, ADS_ADR
    rcall   TWI_MASTER_TRANSMITTER_START_TEMP1
    ldi     temp1,1                                 ; Config register               
    rcall   TWI_MASTER_TRANSMITTER_DATEN_TEMP1
    ldi     temp1,0x85                              ; 0x85 default                  
    rcall   TWI_MASTER_TRANSMITTER_DATEN_TEMP1
    ldi     temp1,0x83                              ; 0x83 default                  
    rcall   TWI_MASTER_TRANSMITTER_DATEN_TEMP1  
    rcall   TWI_STOP
    ; Config read                                                               
    rcall   ads_read_config
    rcall   display_config
    rcall   WAIT_500ms
    ; Config ERROR ?                                                            
    lds     temp, ads_lsb
    cpi     temp,0x83
    brne    ADS_ERROR   
    lds     temp, ads_msb
    cpi     temp, 0x85
    brne    ads_error   
    ; Config Write                                                              
    ldi     temp1, ADS_ADR
    rcall   TWI_MASTER_TRANSMITTER_START_TEMP1
    ldi     temp1,1                                 ; Config register               
    rcall   TWI_MASTER_TRANSMITTER_DATEN_TEMP1

;   ldi     temp1, 1<<ADS_OS|0<<ADS_MUX2|0<<ADS_MUX1|0<<ADS_MUX0|0<<ADS_PGA2|0<<ADS_PGA1|0<<ADS_PGA0|1<<ADS_MODE    ; AIN0 vs AIN0 (default) X85 (LSB)                  
    ldi     temp1, 1<<ADS_OS|1<<ADS_MUX2|0<<ADS_MUX1|0<<ADS_MUX0|0<<ADS_PGA2|0<<ADS_PGA0|0<<ADS_PGA0|0<<ADS_MODE    ; AIN0 vs GND PGA000 6.144V ADC:x0e05  
;   ldi     temp1, 1<<ADS_OS|1<<ADS_MUX2|0<<ADS_MUX1|0<<ADS_MUX0|0<<ADS_PGA2|0<<ADS_PGA1|1<<ADS_PGA0|0<<ADS_MODE    ; AIN0 vs GND PGA001 4.096V ADC:x1507  
;   ldi     temp1, 1<<ADS_OS|1<<ADS_MUX2|0<<ADS_MUX1|0<<ADS_MUX0|0<<ADS_PGA2|1<<ADS_PGA1|0<<ADS_PGA0|0<<ADS_MODE    ; AIN0 vs GND PGA010 2.048V ADC:x2a0e  
;   ldi     temp1, 1<<ADS_OS|1<<ADS_MUX2|0<<ADS_MUX1|0<<ADS_MUX0|0<<ADS_PGA2|1<<ADS_PGA1|1<<ADS_PGA0|0<<ADS_MODE    ; AIN0 vs GND PGA011 1.024V ADC:x5422  
;   ldi     temp1, 1<<ADS_OS|1<<ADS_MUX2|0<<ADS_MUX1|0<<ADS_MUX0|1<<ADS_PGA2|0<<ADS_PGA1|0<<ADS_PGA0|0<<ADS_MODE    ; AIN0 vs GND PGA100 0.512V ADC:x7fff  
;   ldi     temp1, 1<<ADS_OS|1<<ADS_MUX2|0<<ADS_MUX1|0<<ADS_MUX0|1<<ADS_PGA2|0<<ADS_PGA1|1<<ADS_PGA0|0<<ADS_MODE    ; AIN0 vs GND PGA101 0.256V ADC:x7fff  
;   ldi     temp1, 1<<ADS_OS|1<<ADS_MUX2|0<<ADS_MUX1|0<<ADS_MUX0|1<<ADS_PGA2|1<<ADS_PGA1|0<<ADS_PGA0|0<<ADS_MODE    ; AIN0 vs GND PGA110 0.256V ADC:x7fff  
;   ldi     temp1, 1<<ADS_OS|1<<ADS_MUX2|0<<ADS_MUX1|0<<ADS_MUX0|1<<ADS_PGA2|1<<ADS_PGA1|1<<ADS_PGA0|0<<ADS_MODE    ; AIN0 vs GND PGA111 0.256V ADC:x7fff  
    rcall   TWI_MASTER_TRANSMITTER_DATEN_TEMP1
    ldi     temp1, 1<<ADS_COMP_QUE1 | 1<<ADS_COMP_QUE0  ; default 0x83 (MSB)
    rcall   TWI_MASTER_TRANSMITTER_DATEN_TEMP1
    rcall   TWI_STOP
    rcall   WAIT_100ms
    ret
;-------------------------------------------------------------------------------
ads_error:
    GRUEN_OFF
    GELB_ON
    ROT_ON
    rcall   WAIT_100ms
    GELB_OFF
    ROT_OFF
    rcall   WAIT_100ms
    rjmp    ADS_ERROR
; ##############################################################################
; ##############################################################################
; ##############################################################################
ads_read_2_bytes:
    ldi     temp1, ADS_ADR
    rcall   TWI_MASTER_RECEIVER_START_TEMP1
    rcall   TWI_MASTER_RECEIVER_BYTE_TEMP1
    sts     ADS_MSB, temp1
    rcall   TWI_MASTER_RECEIVER_LAST_BYTE_TEMP1
    sts     ADS_LSB, temp1
    ret
; ##############################################################################
; ##############################################################################
; ##############################################################################
ads_read_config:
    ldi     temp1, ADS_ADR
    rcall   TWI_MASTER_TRANSMITTER_START_TEMP1
    ldi     temp1, 1                                ; Config register           
    rcall   TWI_MASTER_TRANSMITTER_DATEN_TEMP1
    rcall   ADS_READ_2_BYTES
    ret
; ##############################################################################
; ##############################################################################
; ##############################################################################
ads_read_adc:
    ldi     temp1, ADS_ADR
    rcall   TWI_MASTER_TRANSMITTER_START_TEMP1
    ldi     temp1,0                                 ; Conversion Register       
    rcall   TWI_MASTER_TRANSMITTER_DATEN_TEMP1
    rcall   ADS_READ_2_BYTES
    ret
; ##############################################################################
; ##############################################################################
; ##############################################################################
; Anzeige des ADC Ergebnisses in dezimal
; Bsp Si-Diode                                                                  
; Ref: 1.024V ADC-Wert: 21.572                                              
; Ref: 6.144V ADC-Wert:  3.593                                              
ads_display_adc_decimal:
    lds     temp1, ADS_LSB
    lds     temp2, ADS_MSB
    clr     temp3
    clr     temp4
    rcall   bin_to_ASCII_32
    rcall   ASCII_to_display_8x
    rcall   zero_supp               ; fhrende Nullen unterdrcken
    rcall   copy_decimal_display
    rcall   wait_500ms      
    ret
; ##############################################################################
; ##############################################################################
; ##############################################################################
; Anzeige des ADC Ergebnisses in hexadezimal
; Bsp Si-Diode                                                                  
; Ref: 1.024V ADC-Wert: 0x541c                                              
; Ref: 6.144V ADC-Wert: 0x0e09                                              
ads_display_adc_hex:
    ldi     temp, DISP_A
    sts     DIGITS+0, temp
    ldi     temp, DISP_D
    sts     DIGITS+1, temp
    ldi     temp, DISP_c
    sts     DIGITS+2, temp
    ldi     temp, DISP_AUS
    sts     DIGITS+3, temp

    lds     temp, ADS_MSB
    rcall   bin_to_display_2x
    sts     DIGITS+4, temp1
    sts     DIGITS+5, temp2

    lds     temp, ADS_LSB
    rcall   bin_to_display_2x
    sts     DIGITS+6, temp1
    sts     DIGITS+7, temp2

    rcall   WAIT_500ms
    ret
; ##############################################################################
; ##############################################################################
; ##############################################################################

