; ##############################################################################
; ##############################################################################
; ##############################################################################
TWI_INI:
    ; SCL(Hz) = CPU(Hz) / (16 + 2 * TWBR * 4^TWPS)  
    ; Beispiel:                                     
    ; 100.000 = 16.000.000 / (16 + 2 * 18 * 4^1)    

.equ TWI_BIT_RATE           = 20    ; 2...100 Bit-Rate                      
.equ TWI_PRESCALER          = 1     ; 0,1,2,3 Vorteiler: 0=1 1=4 2=16 3=64  
        
    ldi     temp, TWI_BIT_RATE
    out     TWBR, temp          
    ldi     temp, TWI_PRESCALER
    out     TWSR, temp
    ; TWI TWAR Adress-Register (nur fuer SLAVE)         
    clr     temp
    out     TWAR,temp
    ldi     temp, 1<<TWINT|1<<TWEA|0<<TWSTA|0<<TWSTO|0<<TWWC|1<<TWEN|0<<TWIE
    out     TWCR,temp
    ret
; ##############################################################################
; ##############################################################################
; ##############################################################################
TWI_AUS:
    ldi     temp, 1<<TWINT|0<<TWEA|0<<TWSTA|0<<TWSTO|0<<TWWC|0<<TWEN|0<<TWIE
    out     TWCR,temp
    ret
; ##############################################################################
; ##############################################################################
; ##############################################################################
;                                                                               
; START-ROUTINE (MASTER TRANSMITTER)                                            
;                                                                               
; INPUT:    temp1 <= ADRESSE SLAVE                                              
; OUT:      FEHLER_CODE                                                         
TWI_MASTER_TRANSMITTER_START_TEMP1:
    ; INITIALISIERUNG   
    clr     ERROR                           ; FEHLER lschen    
    WDR
    ; START-MT          
    ldi     temp, (1<<TWINT)|(1<<TWSTA)|(1<<TWEN)
    out     TWCR, temp  
    rcall   TWI_TWINT_wait                      ; warten, bis TWINT wieder = 1  
    ; Check TWSR                        
    in      temp,TWSR                                                   
    andi    temp, 0xF8
    cpi     temp,  0x08                             ; 0x08 START erfolgreich
    breq    TWI_MASTER_TRANSMITTER_START_w
    cpi     temp,  0x10                             ; 0x10 (repeated START)
    breq    TWI_MASTER_TRANSMITTER_START_w
    ; ERROR                             
    rjmp    TWI_MASTER_TRANSMITTER_START_ERROR
;-------------------------------------------------------------------------------
TWI_MASTER_TRANSMITTER_START_w:
    ; Load SLA + "W"  (W=0)             
    LSL     temp1                                   ; Adresse 1 x links 
    out     TWDR, temp1
    ; senden - Clear TWINT              
    ldi     temp, (1<<TWINT) | (1<<TWEN)                            
    out     TWCR, temp
    rcall   TWI_TWINT_wait                      ; warten, bis TWINT wieder = 1                              
    ; Check TWSR                        
    in      temp,TWSR                                               
    andi    temp, 0xF8
    cpi     temp,  0x18                             ; 0x18              
    brne    TWI_MASTER_TRANSMITTER_START_ERROR
    GRUEN_ON
    ROT_OFF
    ret
;-------------------------------------------------------------------------------
TWI_MASTER_TRANSMITTER_START_ERROR:
    ROT_ON
    GRUEN_OFF
    ; ERROR                             
    mov ERROR, VOLL
ret
; ##############################################################################
; ##############################################################################
; ##############################################################################
;                                                                               
; Ein BYTE zum SLAVE zu senden                                                  
;                                                                               
; INPUT:    temp1 <= DATEN                                                      
; OUT:      FEHLER_CODE                                                         
;                                                                               
TWI_MASTER_TRANSMITTER_DATEN_TEMP1:
    WDR
    ; ERROR                             
    tst     ERROR                               ; Fehler =0 ?   
    breq    TWI_MASTER_TRANSMITTER_DATEN_RUN    ; ja            
    ret                                     ; zurck        
;-------------------------------------------------------------------------------
TWI_MASTER_TRANSMITTER_DATEN_RUN:
    out     TWDR, temp1                         ;   Load DATA   
    ; senden - Clear TWINT              
    ldi     temp, (1<<TWINT) | (1<<TWEN)                            
    out     TWCR, temp
    rcall   TWI_TWINT_wait                  ; warten, bis TWINT wieder = 1      
    ; Check TWSR                        
    in      temp,TWSR
    andi    temp, 0xF8
    cpi     temp, 0x28  ; 0x28
    brne    TWI_MASTER_TRANSMITTER_DATEN_ERROR
    ret
;-------------------------------------------------------------------------------
TWI_MASTER_TRANSMITTER_DATEN_ERROR:
    ; ERROR                             
    ROT_ON
    mov     ERROR, VOLL
    ret
; ##############################################################################
; ##############################################################################
; ##############################################################################
;                                                                               
; TWI/I2C START-ROUTINE                                                         
;                                                                               
;   INPUT:  temp1 <= ADRESSE SLAVE                                              
;   OUT:    FEHLER_CODE                                                         
;                                                                               
TWI_MASTER_RECEIVER_START_TEMP1:
    ; INITIALISIERUNG   
    clr     ERROR
    WDR
    ; START-MR                                          
    ldi     temp, (1<<TWINT | 1<<TWEA | 1<<TWSTA | 1<<TWEN )
    out     TWCR, temp  
    rcall   TWI_TWINT_wait                      ; warten, bis TWINT wieder = 1                      
    ; Check TWSR                                        
    in      temp,TWSR       
    andi    temp, 0xF8
    cpi     temp,  0x08                             ; 0x08 START erfolgreich
    breq    TWI_MASTER_RECEIVER_START_RUN
    cpi     temp,  0x10                             ; 0x10 (repeated START) 
    breq    TWI_MASTER_RECEIVER_START_RUN
    rjmp    TWI_MASTER_RECEIVER_ERROR
;-------------------------------------------------------------------------------
TWI_MASTER_RECEIVER_START_RUN:
    ; Load SLA +"R" (R=1)                               
    LSL     temp1                   ; 1 x links 
    ori     temp1, 0b00000001       ; R=1       
    out     TWDR, temp1
    ; senden - Clear TWINT                              
    ldi     temp, (1<<TWINT | 1<<TWEA  | 1<<TWEN )
    out     TWCR, temp
    rcall   TWI_TWINT_wait      ; warten, bis TWINT wieder = 1                      
    ; Check TWSR                                        
    in      temp,TWSR
    andi    temp, 0xF8
    cpi     temp, 0x40              ;SLA+R gesendet; ACK empfangen
    brne    TWI_MASTER_RECEIVER_ERROR
    ret
;-------------------------------------------------------------------------------
TWI_MASTER_RECEIVER_ERROR:
    ; ERROR                     
    ROT_ON
    mov     ERROR, VOLL
ret
; ##############################################################################
; ##############################################################################
; ##############################################################################
;                                                                               
; Achtung, diese Routine verwenden, wenn                                        
; mehrere! BYTES empfangen werden sollen                                        
;                                                                               
;   OUT:    temp1                                                               
;   OUT:    FEHLER_CODE                                                         
;                                                                               
TWI_MASTER_RECEIVER_BYTE_TEMP1:
    WDR
    ; ERROR                             
    tst     ERROR
    breq    TWI_MASTER_RECEIVER_BYTE_RUN
    ret
;-------------------------------------------------------------------------------
TWI_MASTER_RECEIVER_BYTE_RUN:
    ; senden "ACK" (TWEA=1) fr mehrere Daten-Bytes     
    ldi     temp, (1<<TWINT | 1<<TWEA  | 1<<TWEN )
    out     TWCR, temp
    rcall   TWI_TWINT_wait; TWINT abfragen                                  
    ; Check TWSR                                        
    in      temp,TWSR
    andi    temp, 0xF8
    cpi     temp, 0x50  ; Data Byte empfangen- ACK zurckgesendet
    brne    TWI_MASTER_RECEIVER_BYTE_ERROR
    ; DATEN einlesen                            
    in      temp1, TWDR                     
    ret
;-------------------------------------------------------------------------------
TWI_MASTER_RECEIVER_BYTE_ERROR:
    ; ERROR                             
    ROT_ON  
    clr     temp1
    mov     ERROR, VOLL
ret
; ##############################################################################
; ##############################################################################
; ##############################################################################
;                                                                               
; Achtung, diese Routine verwenden, wenn                                        
; nur ein! BYTE empfangen werden soll, oder wenn                                
; das letzte! BYTE empfangen werden soll                                        
;                                                                               
; OUTPUT: temp1                                                                 
;                                                                               
TWI_MASTER_RECEIVER_LAST_BYTE_TEMP1:
    ; ERROR                             
    tst     ERROR
    breq    TWI_MASTER_RECEIVER_LAST_BYTE_RUN
    ret
;-------------------------------------------------------------------------------
TWI_MASTER_RECEIVER_LAST_BYTE_RUN:
    ; senden "NOT ACK" (TWEA=0) fr letztes bzw fr ein Daten-Byte
    ldi     temp, (1<<TWINT | 0<<TWEA  | 1<<TWEN )
    out     TWCR, temp
    rcall   TWI_TWINT_wait  ; TWINT abfragen                                    
    ; Check TWSR                                        
    in      temp,TWSR
    andi    temp, 0xF8
    cpi     temp, 0x58  ; letztes Data Byte empfangen-NOT ACK zurckgesendet
    brne    TWI_MASTER_RECEIVER_LAST_BYTE_ERROR
    ; DATEN einlesen        
    in      temp1, TWDR
    ret
;-------------------------------------------------------------------------------
TWI_MASTER_RECEIVER_LAST_BYTE_ERROR:
    ; ERROR                             
    ROT_ON  
    clr     temp1
    mov     ERROR, VOLL 
    ret
; ##############################################################################
; ##############################################################################
; ##############################################################################
;                                                                              
; STOP- Routine                                                                
;                                                                              
TWI_STOP:
    ; kleine Pause
    ldi     temp, (1<<TWINT)|(1<<TWEN)|(1<<TWSTO)|0<<TWIE   ; STOP                              
    out     TWCR, temp  
    ; kleine Pause
    rcall   wait_1ms
    ret
; ##############################################################################
; ##############################################################################
; ##############################################################################
;                                                                              
; ERROR- Routine                                                               
;                                                                              
TWI_ERROR_SCHWER:
    rcall   TWI_STOP
    rcall   wait_100ms  
    rcall   TWI_STOP
    rcall   wait_100ms  
    rcall   TWI_STOP
    rcall   wait_100ms  
    rcall   TWI_AUS
    rcall   wait_100ms  
    rcall   TWI_INI
    ret
; ##############################################################################
; ##############################################################################
; ##############################################################################
;                                                                              
; warten, bis das TWINT Flag gesetzt ist                                       
;                                                                              
TWI_TWINT_wait:
    GELB_ON
    in      temp, TWCR
    sbrs    temp, TWINT ; nchsten Befehl berspringen, wenn TWINT FLAG  gesetzt ist
    rjmp    TWI_TWINT_wait  
    GELB_OFF
    ret
; ##############################################################################
; ##############################################################################
; ##############################################################################

