; ##############################################################################
; ##############################################################################
; ##############################################################################
;                                                                               
;   Value: 0... 99.999.999                                                      
;                                                                               
;   INPUT:  temp1   (LSB)                                                       
;           temp2   (BYTE2)                                                     
;           temp3   (BYTE3)                                                     
;           temp4   (MSB)                                                       
;                                                                               
;   OUTPUT: buffer (8 Byte, ASCII)                              
;                                                                               
; rcall HEX_ASC_32
;                                                                               
bin_to_ASCII_32:
    ldi     zl, low(buffer)
    ldi     zh, high(buffer)
    clr     temp
bin_to_ASCII_32_10M:
    inc     temp
    subi    temp1, BYTE1(10000000)
    sbci    temp2, BYTE2(10000000)
    sbci    temp3, BYTE3(10000000)
    sbci    temp4, BYTE4(10000000)
    brcc    bin_to_ASCII_32_10M
    dec     temp
    subi    temp, -48       ; HEX->ASC
    st      z+, temp
    subi    temp1, BYTE1(-10000000)
    sbci    temp2, BYTE2(-10000000)
    sbci    temp3, BYTE3(-10000000)
    sbci    temp4, BYTE4(-10000000)

    clr     temp
bin_to_ASCII_32_1M:
    inc temp
    subi    temp1, BYTE1(1000000)
    sbci    temp2, BYTE2(1000000)
    sbci    temp3, BYTE3(1000000)
    sbci    temp4, BYTE4(1000000)
    brcc    bin_to_ASCII_32_1M
    dec     temp
    subi    temp, -48       ; HEX->ASC
    st      z+, temp
    subi    temp1, BYTE1(-1000000)
    sbci    temp2, BYTE2(-1000000)
    sbci    temp3, BYTE3(-1000000)
    sbci    temp4, BYTE3(-1000000)

    clr     temp
bin_to_ASCII_32_100k:
    inc     temp
    subi    temp1, BYTE1(100000)
    sbci    temp2, BYTE2(100000)
    sbci    temp3, BYTE3(100000)
    brcc    bin_to_ASCII_32_100k
    dec     temp
    subi    temp, -48       ; HEX->ASC
    st      z+, temp
    subi    temp1, BYTE1(-100000)
    sbci    temp2, BYTE2(-100000)
    sbci    temp3, BYTE3(-100000)

    clr     temp
bin_to_ASCII_32_10k:
    inc     temp
    subi    temp1, BYTE1(10000)
    sbci    temp2, BYTE2(10000)
    sbci    temp3, BYTE3(10000)
    brcc    bin_to_ASCII_32_10k
    dec     temp
    subi    temp, -48       ; HEX->ASC
    st      z+, temp
    subi    temp1, BYTE1(-10000)
    sbci    temp2, BYTE2(-10000)
    sbci    temp3, BYTE3(-10000)

    clr     temp
bin_to_ASCII_32_1k:
    inc     temp
    subi    temp1, BYTE1(1000)
    sbci    temp2, BYTE2(1000)
    brcc    bin_to_ASCII_32_1k
    dec     temp
    subi    temp, -48       ; HEX->ASC
    st      z+, temp
    subi    temp1, BYTE1(-1000)
    sbci    temp2, BYTE2(-1000)

    clr     temp
bin_to_ASCII_32_100:
    inc     temp
    subi    temp1, BYTE1(100)
    sbci    temp2, BYTE2(100)
    brcc    bin_to_ASCII_32_100
    dec     temp
    subi    temp, -48       ; HEX->ASC
    st      z+, temp
    subi    temp1, low  (-100)
    sbci    temp2, HIGH (-100)

    clr     temp
bin_to_ASCII_32_10:
    inc     temp
    subi    temp1, BYTE1(10)
    sbci    temp2, BYTE2(10)
    brcc    bin_to_ASCII_32_10
    dec     temp
    subi    temp, -48       ; HEX->ASC
    st      z+, temp
    subi    temp1, BYTE1(-10)
    sbci    temp2, BYTE2(-10)
bin_to_ASCII_32_1:  
    subi    temp1, -48      ; HEX->ASC
    st      z+, temp
    ret
;########################################################################   
;########################################################################   
;########################################################################   
; fhrende Nullstellen in buffer (Display Code) unterdrcken
zero_supp:
    ldi     zl, low(buffer)
    ldi     zh, high(buffer)
    ldi     temp1, 8
zero_supp_loop:
    ld      temp, z
    cpi     temp, DISP_0
    brne    zero_supp_exit
    ldi     temp, DISP_AUS
    st      z+, temp
    dec     temp1
    brne    zero_supp_loop
zero_supp_exit:
    ret

;########################################################################   
;########################################################################   
;########################################################################   
; buffer in DISPLAY Code wandeln, 8 Bytes 
ASCII_to_display_8x:
    ; in 7 SEGMENT wandeln
    ldi     yl, low(buffer)
    ldi     yh, high(buffer)
    ldi     temp1, 8
ASCII_to_display_8x_loop:
    ld      temp, z
    rcall   ASCII_to_display
    st      y+, temp
    dec     temp1
    brne    ASCII_to_display_8x_loop

;########################################################################   
;########################################################################   
;########################################################################   
; INPUT : temp (bin)                                                                
; OUTPUT: temp1+2 (display code)                                                    
bin_to_display_2x:
    push    temp                    ; SICHERUNGSKOPIE                       
    rcall   bin_to_display
    mov     temp2, temp
    pop     temp
    swap    temp
    rcall   bin_to_display
    mov     temp1, temp 
    ret

; ##############################################################################
; ##############################################################################
; ##############################################################################
; ASCII 0-9 in Displaycode wandeln, > 9 ergibt 'E' 
; INPUT : temp (ASCII)                                                              
; OUTPUT: temp (display code)                                                   
ASCII_to_display:
    subi    temp, 48    ; ASCII -> bin
    cpi     temp, 10
    brge    ASCII_to_display_error
    ldi     zl, low(table_hex2display * 2)
    ldi     zh, high(table_hex2display * 2)
    add     zl, temp
    ldi     temp, 0
    adc     zh, temp
    lpm     temp, z
    ret
ASCII_to_display_error:
    ldi     temp, DISP_E
    ret
;########################################################################   
;########################################################################   
;########################################################################   
; unteres Nibble in Displaycode wandeln
; INPUT : temp (bin)                                                                
; OUTPUT: temp (display code)
bin_to_display:
    andi    temp, 0x0F
    ldi     zl, low(table_hex2display * 2)
    ldi     zh, high(table_hex2display * 2)
    add     zl, temp
    ldi     temp, 0
    adc     zh, temp
    lpm     temp, z
    ret

table_hex2display:
    .db DISP_0, DISP_1, DISP_2, DISP_3, DISP_4, DISP_5, DISP_6, DISP_7
    .db DISP_8, DISP_9, DISP_A, DISP_B, DISP_C, DISP_D, DISP_E, DISP_F 

; ##############################################################################
; ##############################################################################
; ##############################################################################
; dezimal in DISPLAY kopieren

copy_decimal_display:
    ldi     zl, low(digits)
    ldi     zh, high(digits)
    ldi     yl, low(buffer)
    ldi     yh, high(buffer)
    ldi     temp, 8
copy_decimal_display_loop:
    ld      temp, y+
    st      z+, temp
    dec     temp1
    brne    copy_decimal_display_loop
    ret
