;                                               
; LED 3xSA23  7-SEGMENT                         
;                                               
; ATmega8 @1MHz                                         
;                                               
; Bernhard.Erfurt@gmx.de                        
; 12/2025                                       
;                                               
; berarbeitung
; Falk.Brunner@gmx.de
; 02/2026

; Anschlussbelegung                        
;                                               
; PB0 ==> Display clock
; PB1 ==> Display  data
; PB2 ==> 
; PB3 ==> 
; PB4 ==> 
; PB5 ==> 
; PB6 ==> 
; PB7 ==> 
;                                               
; PC0 ==>                               
; PC1 ==>                               
; PC2 ==>                                       
; PC3 ==>                                       
; PC4 ==> I2C SDA
; PC5 ==> I2C SCL
;                                               
; PD0 ==> 
; PD1 ==> 
; PD2 ==>                                       
; PD3 ==>                                       
; PD4 ==> 
; PD5 ==> LED gruen
; PD6 ==> LED gelb
; PD7 ==> LED rot

.include "m8def.inc"    ; ATmega8
.include "MACRO.asm"

; KONSTANTEN                                    
.equ TAKT           = 1000000            
; Display Clock                                
.equ CLOCK_PIN      = 0
.equ CLOCK_DDR      = DDRB
.equ CLOCK_PORT     = PORTB
; Display data                                
.equ DATA_PIN       = 1
.equ DATA_DDR       = DDRB
.equ DATA_PORT      = PORTB
; LED GRUEN                                     
.equ GRUEN_PIN      = 5
.equ GRUEN_DDR      = DDRD
.equ GRUEN_PORT     = PORTD
; LED GELB                                      
.equ GELB_PIN       = 6
.equ GELB_DDR       = DDRD
.equ GELB_PORT      = PORTD
; LED ROT                                       
.equ ROT_PIN        = 7
.equ ROT_DDR        = DDRD
.equ ROT_PORT       = PORTD
; Display Codes - 7-SEGMENT                             
.equ DISP_0         =0b00111111 ; 0 
.equ DISP_1         =0b00000110 ; 1 
.equ DISP_2         =0b01011011 ; 2 
.equ DISP_3         =0b01001111 ; 3 
.equ DISP_4         =0b01100110 ; 4 
.equ DISP_5         =0b01101101 ; 5 
.equ DISP_6         =0b01111101 ; 6 
.equ DISP_7         =0b00000111 ; 7 
.equ DISP_8         =0b01111111 ; 8 
.equ DISP_9         =0b01101111 ; 9 

.equ DISP_AUS       =0b00000000 ; ' '
.equ DISP_PUNKT     =0b10000000 ; . 
.equ DISP_VOLL      =0b11111111 ; 8.
.equ DISP_MINUS     =0b01000000 ; - 
.equ DISP_GRD       =0b01100011 ;  
.equ DISP_POS       =0b00100011 ;/\ 
.equ DISP_NEG       =0b00011100 ;\/ 

.equ DISP_A         =0b01110111 ; A 
.equ DISP_B         =0b01111100 ; B 
.equ DISP_C         =0b00111001 ; C 
.equ DISP_D         =0b01011110 ; D 
.equ DISP_E         =0b01111001 ; E 
.equ DISP_F         =0b01110001 ; F 
.equ DISP_P         =0b01110011 ; P 
.equ DISP_S         =0b01101101 ; S
 
.equ DISP_o_        =0b01011100 ; o 
.equ DISP_n_        =0b01010100 ; n 
                        
; SRAM Daten                            
.dseg
.org SRAM_START
data_p:     .byte 2     ; Zeiger auf MUX Daten fr Display
mux:        .byte 1     ; Auswahl der Stelle fr Multiplexer, low active
digits:     .byte 8     ; Daten fr Anzeige
buffer:     .byte 8     ; Puffer fr grose Dezimalzahl
ads_msb:    .byte 1     ; ADS1115 Ergebnis
ads_lsb:    .byte 1

; REGISTER                                      

.def ERROR  = R9
.def NULL   = R10
.def EINS   = R11
.def VOLL   = R12
.def temp   = R16
.def temp1  = R17
.def temp2  = R18
.def temp3  = R19
.def temp4  = R20
.def temp5  = R21
.def temp6  = R22
.def temp7  = R23
.def temp8  = R24
.def temp9  = R25


.cseg                   ; Begin eines Code-Segmentes
.org 0                  ; Startadresse

rjmp RESET              ; Reset Handler                                         
rjmp interrupt_error    ; rjmp EXT_INT0   ; IRQ0 Handler                         
rjmp interrupt_error    ; rjmp EXT_INT1   ; IRQ1 Handler                         
rjmp interrupt_error    ; rjmp TIM2_COMP  ; Timer2 Compare Handler               
rjmp interrupt_error    ; rjmp TIM2_OVF   ; Timer2 Overflow Handler              
rjmp interrupt_error    ; rjmp TIM1_CAPT  ; Timer1 Capture Handler               
rjmp interrupt_error    ; rjmp TIM1_COMPA ; Timer1 CompareA Handler              
rjmp interrupt_error    ; rjmp TIM1_COMPB ; Timer1 CompareB Handler              
rjmp interrupt_error    ; rjmp TIM1_OVF   ; Timer1 Overflow Handler              
rjmp TIM0_OVF           ; Timer0 Overflow Handler                                
rjmp interrupt_error    ; rjmp SPI_STC    ; SPI Transfer Complete Handler        
rjmp interrupt_error    ; rjmp USART_RXC  ; USART RX Complete Handler                             
rjmp interrupt_error    ; rjmp USART_UDRE ; UDR Empty Handler                    
rjmp interrupt_error    ; rjmp USART_TXC  ; USART TX Complete Handler            
rjmp interrupt_error    ; rjmp ADC        ; ADC Conversion Complete Handler      
rjmp interrupt_error    ; rjmp EE_RDY     ; EEPROM Ready Handler                 
rjmp interrupt_error    ; rjmp ANA_COMP   ; Analog Comparator Handler            
rjmp interrupt_error    ; rjmp TWSI       ; Two-wire Serial Interface Handler    
rjmp interrupt_error    ; rjmp SPM_RDY    ; Store Program Memory Ready Handler   

; Bei unkorrekten Interrupt aufrufen erfolgt ein RESET ber WDR 
interrupt_error:
    GRUEN_ON
    GELB_ON
    ROT_ON
    rcall WAIT_100ms
    GRUEN_OFF
    GELB_OFF
    ROT_OFF
    rcall WAIT_100ms
    rjmp interrupt_error

reset:                        
; STACK initialisieren                              
    ldi     temp, LOW(RAMEND)
    out     SPL, temp
    ldi     temp, HIGH(RAMEND)
    out     SPH, temp
; Watchdog aktivieren (max. Zeit)                   
    ldi     temp, (1<<WDCE) | (1<<WDE)  
    out     wdtcr, temp       
    ldi     temp, (1<<WDE) | (1<<WDP2) | (1<<WDP1) | (1<<WDP0) 
    out     wdtcr,temp
; SRAM lschen                                      
    ldi     ZL, LOW (SRAM_START)
    ldi     ZH, HIGH(SRAM_START)
    clr     temp
sram_loop:
    st      z+, temp
    cpi     zh, high(RAMEND)    ; Vergleich?        
    brne    sram_loop           ; kleiner => SPRUNG 
    cpi     zl, low(RAMEND)     ; Vergleich?        
    brne    sram_loop           ; kleiner => SPRUNG 
; TIMER_INITIALISIERUNG                             
    rcall   init_timer0
; TIMER_AKTIVIEREN                                  
    rcall   init_timer0_isr
; Port Initialisierung                              
    rcall   init_ports
; STARTWERTE                                        
    rcall   init_data
; TWI Initialisierung                               
    rcall   TWI_INI
; interrupts freigeben                              
    sei
; Begrssung "ADS 1115"                                     
    ldi     zl, low(digits)
    ldi     zh, HIGH(digits)
    
    ldi     temp, DISP_A
    st      z+, temp
    ldi     temp, DISP_d
    st      z+, temp
    ldi     temp, DISP_S
    st      z+, temp
    ldi     temp, DISP_AUS
    st      z+, temp
    ldi     temp, DISP_1 
    st      z+, temp 
    ldi     temp, DISP_1 
    st      z+, temp 
    ldi     temp, DISP_1 
    st      z+, temp 
    ldi     temp, DISP_5 
    st      z+, temp
    rcall   WAIT_1000ms
    rcall   ads_init
; ##############################################################################
; ##############################################################################
; ##############################################################################
; endlose Hauptschleife
loop:
    rcall   check_programm
    rcall   ads_read_adc 
;   rcall   ads_display_adc_hex
    rcall   ads_display_adc_decimal
    rjmp    loop

; ##############################################################################
; ##############################################################################
; ##############################################################################

.include "ZAHLEN.asm"
.include "TIMER.asm"
.include "ADS115.asm"
.include "TWI.asm"
.include "SONSTIGES.asm"
.include "WAIT.asm"
.include "Anzeige.asm"
