; ##############################################################################
; ##############################################################################
; ##############################################################################
display_line0_clear:
    STS     digits+0, NULL
    STS     digits+1, NULL
    STS     digits+2, NULL
    STS     digits+3, NULL
    ret
; ##############################################################################
; ##############################################################################
; ##############################################################################
display_line1_clear:
    STS     digits+4, NULL
    STS     digits+5, NULL
    STS     digits+6, NULL
    STS     digits+7, NULL
    ret
; ##############################################################################
; ##############################################################################
; ##############################################################################
; Multiplexing fuer Anzeige, eine Stelle / Aufruf
; Aufruf im Timerinterrupt, alle benutzten Register sichern und wieder herstellen
display_mux:
    push    temp
    push    temp1
    push    zl
    push    zh
    ldi     zl, data_p
    ldi     zh, data_p+1
    ld      temp, z+
    rcall   send_byte
    ldi     temp, mux
    rcall   send_byte

    ldi     temp, mux
    sec
    ror     temp
    cpi     temp, 0xFF
    brne    display_mux_end
    ldi     temp, 0b01111111    ; Neustart der MUX bei Digit 0
    ldi     zl, low(digits)
    ldi     zh, high(digits)
display_mux_end:
    sts     mux, temp
    sts     data_p, zl
    sts     data_p+1, zh
    pop     zh
    pop     zl
    pop     temp1
    pop     temp
    ret

send_byte:
    ldi     temp1, 8       ; Bitzeahler
send_byte_loop:
    sbrs    temp, 7        ; Daten Pin setzen
    DISPLAY_DATA_L
    sbrc    temp, 7
    DISPLAY_DATA_H
    CLOCK_PULSE
    rol     temp           ; naechstes Bit, MSB zuerst
    dec     temp1
    brne    send_byte_loop
    DISPLAY_DATA_L
    ret

display_config:
    ldi     xl, low(digits)
    ldi     xh, high(digits)                                
    WRITE_DISPLAY DISP_C
    WRITE_DISPLAY DISP_o_
    WRITE_DISPLAY DISP_n_
    WRITE_DISPLAY DISP_F
    ; Wert(hex)                                      
    lds     temp, ADS_MSB
    rcall   bin_to_display_2x
    st      x+, temp1
    st      x+, temp2
    lds     temp, ADS_LSB
    rcall   bin_to_display_2x
    st      x+, temp1
    st      x+, temp2 
    WAIT_MS 500
    ret

