; ##############################################################################
; ##############################################################################
; ##############################################################################
restart_with_wdt:
    WDR
    in      temp, MCUCSR
    andi    temp,0b00001000
    tst     temp
    breq    restart_with_wdt_error
    ; MCUCSR clear      
    out     MCUCSR,NULL
    ret
restart_with_wdt_error:
    rjmp    restart_with_wdt_error
; ##############################################################################
; ##############################################################################
; ##############################################################################
; PORT B+C+D initialisieren                         
init_ports:
    ldi     temp, 0
    out     DDRB, temp
    out     PORTB, temp             
    out     DDRC, temp
    out     PORTC, temp             
    out     DDRD, temp
    out     PORTD, temp             

;-------------------------------------------------------------------------------
; Ausgaenge fuer Display                                     
    sbi     CLOCK_DDR, CLOCK_PIN 
    sbi     DATA_DDR, DATA_PIN  
; Ausgaenge fuer LED                                    
    sbi     GRUEN_DDR, GRUEN_PIN
    sbi     GELB_DDR , GELB_PIN 
    sbi     ROT_DDR  , ROT_PIN 

    WAIT_MS     500
    GRUEN_OFF
    GELB_OFF
    ROT_OFF

    ROT_ON
    WAIT_MS     100
    ROT_OFF
            
    GELB_ON
    WAIT_MS     100
    GELB_OFF
    
    GRUEN_ON
    WAIT_MS     100
    GRUEN_OFF
    ret
; ##############################################################################
; ##############################################################################
; ##############################################################################
; Variablen initialisieren
init_data:
    ; NULL              
    clr     NULL
    ; EINS              
    ldi     temp,1
    mov     EINS,temp
    ; VOLL              
    ldi     temp,255
    mov     VOLL,temp
    ldi     temp, 0b01111111
    sts     mux, temp
    ldi     temp, low(digits)
    sts     data_p, temp
    ldi     temp, high(digits)
    sts     data_p+1, temp
    ret
; ##############################################################################
; ##############################################################################
; ##############################################################################
check_programm:
    ; NULL      
    tst     NULL
    brne    check_programm_error
    ; EINS      
    mov     temp,EINS
    cpi     temp,1
    brne    check_programm_error
    ; VOLL      
    mov     temp,VOLL
    cpi     temp,255
    brne    check_programm_error
    ret

; SCHLEIFE                          
check_programm_error:
    ROT_ON
    WAIT_MS 100
    ROT_OFF
    WAIT_MS 100
    rjmp    check_programm_error

