; ##############################################################################
; ##############################################################################
; ##############################################################################
; Timer 0 berlauf Int aktivieren (Timer/Counter Interrupt Mask)        
init_timer0_isr:
    ldi     temp, 1<<TOIE0
    out     TIMSK, temp       
    ret
; ##############################################################################
; ##############################################################################
; ##############################################################################
; TIMER0 (8Bit) Vorteiler                                                   
;                                                                           
; CS02 CS01 CS00    Description                                             
;   0   0   0       No clock source (Timer/Counter stopped).                
;   0   0   1       clkI/O/     (No prescaling)                             
; * 0   1   0       clkI/O/8    (From prescaler)                            
;   0   1   1       clkI/O/64   (From prescaler)                            
;   1   0   0       clkI/O/256  (From prescaler)                            
;   1   0   1       clkI/O/1024 (From prescaler)                            
;   1   1   0       External clock source on T0 pin. Clock on falling edge. 
;   1   1   1       External clock source on T0 pin. Clock on rising edge.  
init_timer0:
    ldi     temp, (0<<CS02)|(1<<CS01)|(0<<CS00)
    OUT     TCCR0, temp
    ret
; ##############################################################################
; ##############################################################################
; ##############################################################################
; Timer 0 Ueberlauf ISR
TIM0_OVF:
    push    temp            ; Sichern von "TEMP" im Stack
    in      temp, SREG      ; Einlesen des SREG                     

    rcall   display_mux

    out     SREG, temp      ; Wiederherstellen von SREG             
    pop     temp            ; Wiederherstellen von "TEMP"           
    reti
; ##############################################################################
; ##############################################################################
; ##############################################################################

