/* USER CODE BEGIN Header */
/**
  ******************************************************************************
  * @file           : usbd_cdc_if.c
  * @version        : v1.0_Cube
  * @brief          : Usb device for Virtual Com Port.
  ******************************************************************************
  * @attention
  *
  * Copyright (c) 2026 STMicroelectronics.
  * All rights reserved.
  *
  * This software is licensed under terms that can be found in the LICENSE file
  * in the root directory of this software component.
  * If no LICENSE file comes with this software, it is provided AS-IS.
  *
  ******************************************************************************
  */
/* USER CODE END Header */

/* Includes ------------------------------------------------------------------*/
#include "usbd_cdc_if.h"

/* USER CODE BEGIN INCLUDE */

/* USER CODE END INCLUDE */

/* Private typedef -----------------------------------------------------------*/
/* Private define ------------------------------------------------------------*/
/* Private macro -------------------------------------------------------------*/

/* USER CODE BEGIN PV */
/* Private variables ---------------------------------------------------------*/

/* USER CODE END PV */

/** @addtogroup STM32_USB_OTG_DEVICE_LIBRARY
  * @brief Usb device library.
  * @{
  */

/** @addtogroup USBD_CDC_IF
  * @{
  */

/** @defgroup USBD_CDC_IF_Private_TypesDefinitions USBD_CDC_IF_Private_TypesDefinitions
  * @brief Private types.
  * @{
  */

/* USER CODE BEGIN PRIVATE_TYPES */

/* USER CODE END PRIVATE_TYPES */

/**
  * @}
  */

/** @defgroup USBD_CDC_IF_Private_Defines USBD_CDC_IF_Private_Defines
  * @brief Private defines.
  * @{
  */

/* USER CODE BEGIN PRIVATE_DEFINES */
/* USER CODE END PRIVATE_DEFINES */

/**
  * @}
  */

/** @defgroup USBD_CDC_IF_Private_Macros USBD_CDC_IF_Private_Macros
  * @brief Private macros.
  * @{
  */

/* USER CODE BEGIN PRIVATE_MACRO */

/* USER CODE END PRIVATE_MACRO */

/**
  * @}
  */

/** @defgroup USBD_CDC_IF_Private_Variables USBD_CDC_IF_Private_Variables
  * @brief Private variables.
  * @{
  */


/* USER CODE BEGIN PRIVATE_VARIABLES */
USBD_CDC_LineCodingTypeDef LineCoding =
{
  115200, /* baud rate*/
  0x00,   /* stop bits-1*/
  0x00,   /* parity - none*/
  0x08    /* nb. of bits 8*/
};
/* CDC Instance 0 Variables */
uint8_t UserRxBuffer0[APP_RX_DATA_SIZE];/* Received Data over USB are stored in this buffer */
uint8_t UserTxBuffer0[APP_TX_DATA_SIZE];/* Received Data over UART (CDC interface) are stored in this buffer */
uint32_t BuffLength0;
uint32_t UserTxBufPtrIn0 = 0;/* Increment this pointer or roll it back to
                               start address when data are received over USART */
uint32_t UserTxBufPtrOut0 = 0; /* Increment this pointer or roll it back to
                                 start address when data are sent over USB */
/* TIM handler declaration */
TIM_HandleTypeDef  TimHandle;

//TIM_HandleTypeDef htim3;

//UART_HandleTypeDef huart3;

/* CDC Instance 1 Variables */
uint8_t UserRxBuffer1[APP_RX_DATA_SIZE];/* Received Data over USB are stored in this buffer */
uint8_t UserTxBuffer1[APP_TX_DATA_SIZE];/* Received Data over UART (CDC interface) are stored in this buffer */
uint32_t BuffLength1;
uint32_t UserTxBufPtrIn1 = 0;/* Increment this pointer or roll it back to
                               start address when data are received over USART */
uint32_t UserTxBufPtrOut1 = 0; /* Increment this pointer or roll it back to
                                 start address when data are sent over USB */


/* USER CODE END PRIVATE_VARIABLES */

/**
  * @}
  */

/** @defgroup USBD_CDC_IF_Exported_Variables USBD_CDC_IF_Exported_Variables
  * @brief Public variables.
  * @{
  */

extern USBD_HandleTypeDef hUsbDeviceFS;

/* USER CODE BEGIN EXPORTED_VARIABLES */

/* USER CODE END EXPORTED_VARIABLES */

/**
  * @}
  */

/** @defgroup USBD_CDC_IF_Private_FunctionPrototypes USBD_CDC_IF_Private_FunctionPrototypes
  * @brief Private functions declaration.
  * @{
  */

static int8_t CDC_0_Init_FS(void);
static int8_t CDC_0_DeInit_FS(void);
static int8_t CDC_0_Control_FS(uint8_t cmd, uint8_t* pbuf, uint16_t length);
static int8_t CDC_0_Receive_FS(uint8_t* pbuf, uint32_t *Len);
static int8_t CDC_0_TransmitCplt_FS(uint8_t *pbuf, uint32_t *Len, uint8_t epnum);

static int8_t CDC_1_Init_FS(void);
static int8_t CDC_1_DeInit_FS(void);
static int8_t CDC_1_Control_FS(uint8_t cmd, uint8_t* pbuf, uint16_t length);
static int8_t CDC_1_Receive_FS(uint8_t* pbuf, uint32_t *Len);
static int8_t CDC_1_TransmitCplt_FS(uint8_t *pbuf, uint32_t *Len, uint8_t epnum);


/* USER CODE BEGIN PRIVATE_FUNCTIONS_DECLARATION */

/* USER CODE END PRIVATE_FUNCTIONS_DECLARATION */

/**
  * @}
  */

USBD_CDC_ItfTypeDef USBD_Interface_fops_FS0 =
{
  CDC_0_Init_FS,
  CDC_0_DeInit_FS,
  CDC_0_Control_FS,
  CDC_0_Receive_FS,
  CDC_0_TransmitCplt_FS
};

USBD_CDC_ItfTypeDef USBD_Interface_fops_FS1 =
{
  CDC_1_Init_FS,
  CDC_1_DeInit_FS,
  CDC_1_Control_FS,
  CDC_1_Receive_FS,
  CDC_1_TransmitCplt_FS
};


/* Private functions ---------------------------------------------------------*/
/**
  * @brief  Initializes the CDC media low layer over the FS USB IP
  * @retval USBD_OK if all operations are OK else USBD_FAIL
  */
static int8_t CDC_0_Init_FS(void)
{
  /* USER CODE BEGIN 3 */
  /* Set Application Buffers */
/* Check if the class ID corresponds to instance 0 */
  if (hUsbDeviceFS.classId == USBD_CMPSIT_GetClassID(&hUsbDeviceFS, CLASS_TYPE_CDC, 0))
  {
    /*##-5- Set Application Buffers ############################################*/

    USBD_CDC_SetTxBuffer(&hUsbDeviceFS, UserTxBuffer0, 0,0);
    USBD_CDC_SetRxBuffer(&hUsbDeviceFS, UserRxBuffer0);

    return (USBD_OK);
  }
  else
  {
    /* Error: no instancecorresponds to this class ID */
     return USBD_FAIL;
  }
  /* USER CODE END 3 */
}

static int8_t CDC_1_Init_FS(void)
{
  /* USER CODE BEGIN 3 */
  /* Check if the class ID corresponds to instance 1 */
  if (hUsbDeviceFS.classId == USBD_CMPSIT_GetClassID(&hUsbDeviceFS, CLASS_TYPE_CDC, 1))
  {
    /* Set Application Buffers */

    USBD_CDC_SetTxBuffer(&hUsbDeviceFS, UserTxBuffer1, 0,1);
    USBD_CDC_SetRxBuffer(&hUsbDeviceFS, UserRxBuffer1);

    return (USBD_OK);
  }
  else
  {
    /* Error: no instancecorresponds to this class ID */
     return USBD_FAIL;
  }
  /* USER CODE END 3 */
}


/**
  * @brief  DeInitializes the CDC media low layer
  * @retval USBD_OK if all operations are OK else USBD_FAIL
  */
static int8_t CDC_0_DeInit_FS(void)
{
  /* USER CODE BEGIN 4 */
/* Check if the class ID corresponds to instance 0 */
  if (hUsbDeviceFS.classId == USBD_CMPSIT_GetClassID(&hUsbDeviceFS, CLASS_TYPE_CDC, 0))
  {
    /* Reset pointers */
    BuffLength0= 0;
    UserTxBufPtrIn0= 0;
    UserTxBufPtrOut0= 0;
    return (USBD_OK);
  }
  else
  {
    /* Error: no instancecorresponds to this class ID */
     return USBD_FAIL;
  }  
  /* USER CODE END 4 */
}

/**
  * @brief  DeInitializes the CDC media low layer
  * @retval USBD_OK if all operations are OK else USBD_FAIL
  */
static int8_t CDC_1_DeInit_FS(void)
{
  /* USER CODE BEGIN 4 */
  /* Check if the class ID corresponds to instance 1 */
  if (hUsbDeviceFS.classId == USBD_CMPSIT_GetClassID(&hUsbDeviceFS, CLASS_TYPE_CDC, 1))
  {
    /* Reset pointers */
    BuffLength1 = 0;
    UserTxBufPtrIn1 = 0;
    UserTxBufPtrOut1 = 0;

    return (USBD_OK);
  }
  else
  {
    /* Error: no instancecorresponds to this class ID */
     return USBD_FAIL;
  }  
  /* USER CODE END 4 */
}

/**
  * @brief  Manage the CDC class requests
  * @param  cmd: Command code
  * @param  pbuf: Buffer containing command data (request parameters)
  * @param  length: Number of data to be sent (in bytes)
  * @retval Result of the operation: USBD_OK if all operations are OK else USBD_FAIL
  */
static int8_t CDC_0_Control_FS(uint8_t cmd, uint8_t* pbuf, uint16_t length)
{
  /* USER CODE BEGIN 5 */
  switch(cmd)
  {
    case CDC_SEND_ENCAPSULATED_COMMAND:

    break;

    case CDC_GET_ENCAPSULATED_RESPONSE:

    break;

    case CDC_SET_COMM_FEATURE:

    break;

    case CDC_GET_COMM_FEATURE:

    break;

    case CDC_CLEAR_COMM_FEATURE:

    break;

  /*******************************************************************************/
  /* Line Coding Structure                                                       */
  /*-----------------------------------------------------------------------------*/
  /* Offset | Field       | Size | Value  | Description                          */
  /* 0      | dwDTERate   |   4  | Number |Data terminal rate, in bits per second*/
  /* 4      | bCharFormat |   1  | Number | Stop bits                            */
  /*                                        0 - 1 Stop bit                       */
  /*                                        1 - 1.5 Stop bits                    */
  /*                                        2 - 2 Stop bits                      */
  /* 5      | bParityType |  1   | Number | Parity                               */
  /*                                        0 - None                             */
  /*                                        1 - Odd                              */
  /*                                        2 - Even                             */
  /*                                        3 - Mark                             */
  /*                                        4 - Space                            */
  /* 6      | bDataBits  |   1   | Number Data bits (5, 6, 7, 8 or 16).          */
  /*******************************************************************************/
    case CDC_SET_LINE_CODING:
       LineCoding.bitrate    = (uint32_t)(pbuf[0] | (pbuf[1] << 8) |\
                            (pbuf[2] << 16) | (pbuf[3] << 24));
    LineCoding.format     = pbuf[4];
    LineCoding.paritytype = pbuf[5];
    LineCoding.datatype   = pbuf[6];

    /* Manage HW only for instance 0 */
    if (hUsbDeviceFS.classId == USBD_CMPSIT_GetClassID(&hUsbDeviceFS, CLASS_TYPE_CDC, 0))
    {
      /* Set the new configuration */
      //ComPort_Config();
    }

    break;

    case CDC_GET_LINE_CODING:
        pbuf[0] = (uint8_t)(LineCoding.bitrate);
    pbuf[1] = (uint8_t)(LineCoding.bitrate >> 8);
    pbuf[2] = (uint8_t)(LineCoding.bitrate >> 16);
    pbuf[3] = (uint8_t)(LineCoding.bitrate >> 24);
    pbuf[4] = LineCoding.format;
    pbuf[5] = LineCoding.paritytype;
    pbuf[6] = LineCoding.datatype;
    break;

    case CDC_SET_CONTROL_LINE_STATE:

    break;

    case CDC_SEND_BREAK:

    break;

  default:
    break;
  }

  return (USBD_OK);
  /* USER CODE END 5 */
}

/**
  * @brief  Manage the CDC class requests
  * @param  cmd: Command code
  * @param  pbuf: Buffer containing command data (request parameters)
  * @param  length: Number of data to be sent (in bytes)
  * @retval Result of the operation: USBD_OK if all operations are OK else USBD_FAIL
  */
static int8_t CDC_1_Control_FS(uint8_t cmd, uint8_t* pbuf, uint16_t length)
{
  /* USER CODE BEGIN 5 */
  switch(cmd)
  {
    case CDC_SEND_ENCAPSULATED_COMMAND:

    break;

    case CDC_GET_ENCAPSULATED_RESPONSE:

    break;

    case CDC_SET_COMM_FEATURE:

    break;

    case CDC_GET_COMM_FEATURE:

    break;

    case CDC_CLEAR_COMM_FEATURE:

    break;

    case CDC_SET_LINE_CODING:

    break;

    case CDC_GET_LINE_CODING:
    pbuf[0] = (uint8_t)(LineCoding.bitrate);
    pbuf[1] = (uint8_t)(LineCoding.bitrate >> 8);
    pbuf[2] = (uint8_t)(LineCoding.bitrate >> 16);
    pbuf[3] = (uint8_t)(LineCoding.bitrate >> 24);
    pbuf[4] = LineCoding.format;
    pbuf[5] = LineCoding.paritytype;
    pbuf[6] = LineCoding.datatype;
    break;

    case CDC_SET_CONTROL_LINE_STATE:

    break;

    case CDC_SEND_BREAK:

    break;

    default:
    break;
  }
  return (USBD_OK);
  /* USER CODE END 5 */
}


/**
  * @brief  Data received over USB OUT endpoint are sent over CDC interface
  *         through this function.
  *
  *         @note
  *         This function will issue a NAK packet on any OUT packet received on
  *         USB endpoint until exiting this function. If you exit this function
  *         before transfer is complete on CDC interface (ie. using DMA controller)
  *         it will result in receiving more data while previous ones are still
  *         not sent.
  *
  * @param  Buf: Buffer of data to be received
  * @param  Len: Number of data received (in bytes)
  * @retval Result of the operation: USBD_OK if all operations are OK else USBD_FAIL
  */
static int8_t CDC_0_Receive_FS(uint8_t* Buf, uint32_t *Len)
{
  /* USER CODE BEGIN 6 */
  USBD_CDC_SetRxBuffer(&hUsbDeviceFS, &Buf[0]);
  USBD_CDC_ReceivePacket(&hUsbDeviceFS);
  CDC_0_Transmit_FS(Buf, *Len);
  return (USBD_OK);
  /* USER CODE END 6 */
}
static int8_t CDC_1_Receive_FS(uint8_t* Buf, uint32_t *Len)
{
  /* USER CODE BEGIN 6 */
  USBD_CDC_SetRxBuffer(&hUsbDeviceFS, &Buf[0]);
  USBD_CDC_ReceivePacket(&hUsbDeviceFS);
  CDC_1_Transmit_FS(Buf, *Len);
  return (USBD_OK);
  /* USER CODE END 6 */
}


/**
  * @brief  CDC_0_TransmitCplt_FS
  *         Data transmitted callback
  *
  *         @note
  *         This function is IN transfer complete callback used to inform user that
  *         the submitted Data is successfully sent over USB.
  *
  * @param  Buf: Buffer of data to be received
  * @param  Len: Number of data received (in bytes)
  * @retval Result of the operation: USBD_OK if all operations are OK else USBD_FAIL
  */
static int8_t CDC_0_TransmitCplt_FS(uint8_t *Buf, uint32_t *Len, uint8_t epnum)
{
  uint8_t result = USBD_OK;
  /* USER CODE BEGIN 13 */
  UNUSED(Buf);
  UNUSED(Len);
  UNUSED(epnum);
  /* USER CODE END 13 */
  return result;
}
static int8_t CDC_1_TransmitCplt_FS(uint8_t *Buf, uint32_t *Len, uint8_t epnum)
{
  uint8_t result = USBD_OK;
  /* USER CODE BEGIN 13 */
  UNUSED(Buf);
  UNUSED(Len);
  UNUSED(epnum);
  /* USER CODE END 13 */
  return result;
}


/* USER CODE BEGIN PRIVATE_FUNCTIONS_IMPLEMENTATION */

/**
  * @brief  CDC_Transmit_FS
  *         Data to send over USB IN endpoint are sent over CDC interface
  *         through this function.
  *         @note
  *
  *
  * @param  Buf: Buffer of data to be sent
  * @param  Len: Number of data to be sent (in bytes)
  * @retval USBD_OK if all operations are OK else USBD_FAIL or USBD_BUSY
  */
uint8_t CDC_0_Transmit_FS(uint8_t* Buf, uint32_t Len)
{
  uint8_t result = USBD_OK;
  /* USER CODE BEGIN 7 */
  uint32_t classID = USBD_CMPSIT_GetClassID(&hUsbDeviceFS, CLASS_TYPE_CDC, 0);
  
  //USBD_CDC_HandleTypeDef *hcdc = (USBD_CDC_HandleTypeDef*)hUsbDeviceFS.pClassData;
  //if (hcdc->TxState != 0){
  //  return USBD_BUSY;
  //}
  USBD_CDC_SetTxBuffer(&hUsbDeviceFS, Buf, Len, classID);
  result = USBD_CDC_TransmitPacket(&hUsbDeviceFS, classID);
  /* USER CODE END 7 */
  return result;
}

uint8_t CDC_1_Transmit_FS(uint8_t* Buf, uint32_t Len)
{
  uint8_t result = USBD_OK;
  /* USER CODE BEGIN 7 */
  uint32_t classID = USBD_CMPSIT_GetClassID(&hUsbDeviceFS, CLASS_TYPE_CDC, 1);
  
  //USBD_CDC_HandleTypeDef *hcdc = (USBD_CDC_HandleTypeDef*)hUsbDeviceFS.pClassData;
  //if (hcdc->TxState != 0){
  //  return USBD_BUSY;
  //}
  USBD_CDC_SetTxBuffer(&hUsbDeviceFS, Buf, Len, classID);
  result = USBD_CDC_TransmitPacket(&hUsbDeviceFS, classID);
  /* USER CODE END 7 */
  return result;
}


/* USER CODE END PRIVATE_FUNCTIONS_IMPLEMENTATION */

/**
  * @}
  */

/**
  * @}
  */
