// --- [global.h ] ------------------------------------------------------------

#ifndef EXTERN
#define EXTERN extern
#endif

#define ATTINY										//

#define TRUE 					1
#define FALSE 					0

#define EEPROM_SIZE 			128

#define LED_DDR				DDRD
#define LED_PORT				PORTD
#define LED_PIN				PIND
#define LED1					PD5

#define ADR_AUTOSTART		3					// Adresse fr das Autostart-Byte im EEPROM
#define ADR_MESSINTERVALL	5					// Adresse des Messintervalls im EEPROM (fr int16 !!)
#define MESSINTERVALL		5					// Lnge des Messintervalls als Vorgabe in Sekunden

EXTERN char     msg[10];						// globale Variable zur Zeichenkonvertierung
EXTERN uint8_t  ow_buffer[9];					// fr den ROM-Adressen und Scratchboard
EXTERN uint8_t  start_modus;					// Nach dem Einschalten automatisch mit Messungen beginnen / inaktiv
EXTERN volatile uint8_t pause;				// keine Messungen durchfhren, wenn TRUE
EXTERN uint16_t messintervall;				// bis 127 * 10 Sekunden einstellbar
EXTERN volatile uint8_t time_flag;			// zeigt den Ablauf des Messintervalls an
EXTERN uint8_t  sensor_cnt;					// Anzahl der erfolgreich angelernten Sensoren
EXTERN uint32_t time32; 						// Zhler fr die Anzahl der Sekunden seit Programmstart

/* ATMEGA
EXTERN volatile uint8_t rx_in;				// zur bergabe des empfangenen Bytes an main()
EXTERN volatile uint8_t rx_flag;				// die Variable wird in ein Register verlegt, spart 8 Byte
EXTERN          uint8_t rx_received			// die Variable wird in ein Register verlegt, spart ca. 30 Byte
*/
// ATTINY											// nur fr den TINY, um ein paar Byte SRAM zu sparen 
#define rx_flag     GPIOR2						// das macht nur dann Sinn, wenn die Registeradr < 32
#define rx_received GPIOR1
#define rx_in       GPIOR0						// das gilt beim ATMEGAx8 nur fr GPIOR0
//

// --- [ eof ] ----------------------------------------------------------------