// --- [owi_lib.h ] -----------------------------------------------------------

#define ONE_WIRE_PORT		PORTB
#define ONE_WIRE_PIN			PINB
#define ONE_WIRE_DDR			DDRB
#define ONE_WIRE_PORT_PIN	PB0
#define ONE_WIRE_POWER_PIN PB1

#define DQ_LOW					ONE_WIRE_PORT &= ~(1<<ONE_WIRE_PORT_PIN)
#define DQ_HIGH				ONE_WIRE_PORT |=   1<<ONE_WIRE_PORT_PIN
#define DQ_OUTPUT				ONE_WIRE_DDR  |=   1<<ONE_WIRE_PORT_PIN
#define DQ_INPUT				ONE_WIRE_DDR  &= ~(1<<ONE_WIRE_PORT_PIN)
#define DQ_READ				ONE_WIRE_PIN  &    1<<ONE_WIRE_PORT_PIN

#define SEARCH_ROM			0xF0
#define READ_ROM				0x33
#define MATCH_ROM				0x55
#define SKIP_ROM				0xCC
#define ALARM_SEARCH			0xEC
#define CONVERT				0x44
#define WRITE_SCRATCHPAD	0x4E
#define READ_SCRATCHPAD		0xBE
#define COPY_SCRATCHPAD		0x48
#define RECALL_E				0xB8
#define READ_POWER_SUPPLY	0xB4

#define DS18B20				0x28			// Family-Code fr DS18B20

#define DELAY_A				6				// Wartezeiten gem. APP-NOTE 126, Page 2-3
#define DELAY_B				64				// fr Standard Speed
#define DELAY_C				60
#define DELAY_D				10
#define DELAY_E				9
#define DELAY_F				55
#define DELAY_G				1				// anstelle 0
#define DELAY_H				480
#define DELAY_I				70
#define DELAY_J				410

// --- public Funktionen ------------------------------------------------------

uint8_t OW_read_rom_code(void);
uint8_t OW_read_scratchpad(uint8_t idx);
uint8_t OW_rom_code_exists(void);
uint8_t OW_eeprom_free(void);
void    OW_read_eeprom(void);
void    OW_convert_all(void);
uint8_t EEPROM_read_rom_code(uint8_t idx);
void    EEPROM_write_rom_code(uint8_t idx);
uint8_t EEPROM_compare_rom_code(uint8_t idx);
uint8_t OWReset(void);
void    DS18B20_convert_temperatur(void);

// --- [ eof ] ----------------------------------------------------------------