// --- [ rs232.c ] -----------------------------------------------------------
// fr Senden und Empfangen via RS232
// Empfangene Daten werden in einen Ringpuffer abgelegt.
// Zu sendende Daten (zum Debuggen) werden direkt pollend ausgegeben.

#include <avr/io.h>
#include <avr/pgmspace.h>
#include <inttypes.h>
#include <avr/interrupt.h>
//#include <stdlib.h>  
#include "rs232.h"
#include "global.h"

// ----------------------------------------------------------------------------
// 
void RS232_init(void)
{
/* ATMEGA8
UBRRL = TEILER;									// siehe rs232.h
UBRRH = 0;
UCSRB = (0<<RXCIE | 1<<TXEN | 0<<RXEN);
//UCSRC = (1<<URSEL | 0<<UMSEL) | (1<<UCSZ1) | (1<<UCSZ0);
// URSEL - Achtung bei ATmega 8
UCSRC = (0<<UMSEL) | (1<<UCSZ1) | (1<<UCSZ0);
*/

/* ATMEGA88
UBRR0L = TEILER;									// siehe rs232.h
//UBRR0H = 0;
UCSR0C = (0<<UMSEL01) | (1<<UCSZ01) | (1<<UCSZ00);
// RX/Tx und Rx_Interrupt enablen
UCSR0B =	(1<<RXCIE0 | 0<<TXCIE0 | 0<<UDRIE0 | 1<<RXEN0 | 1<<TXEN0);
// hier nur zum Senden von Debug-Informationen vorbereiten
//UCSR0B =	(0<<RXCIE0 | 0<<TXCIE0 | 0<<UDRIE0 | 0<<RXEN0 | 1<<TXEN0);
*/

// ATTINY2313
UBRRL = TEILER;									// siehe rs232.h
UBRRH = 0;
UCSRC = (0<<UMSEL) | (1<<UCSZ1) | (1<<UCSZ0);
UCSRB =	(1<<RXCIE | 0<<TXCIE   |  0<<UDRIE | 1<<RXEN | 1<<TXEN);
//
}

// ----------------------------------------------------------------------------
// legt ein via RS232 eingegangenes Byte in der Variablen rx_received ab
// und setzt die Variable rx_flag.
ISR (USART_RX_vect)
{

/* ATMEGA48
rx_in = UDR0;
*/

// ATTINY2313
rx_in = UDR;
//

rx_flag = TRUE;
}

// ----------------------------------------------------------------------------
// ein einzelnes Zeichen auf COM ausgeben
void put_c(uint8_t Zeichen)
{
/* ATMEGA
while(!(UCSR0A & (1<<UDRE0)));
UDR0 = Zeichen;
*/
// ATTINY2313
while(!(UCSRA & (1<<UDRE)));
UDR = Zeichen;
//
}

// ----------------------------------------------------------------------------
// einen String auf COM ausgeben
void put_s(char *s)
{
while(*s) put_c(*s++);
}

/*
// ----------------------------------------------------------------------------
// gibt einen String aus dem Flash aus
void puts_p(const char *progmem_s)
{
register char c;
while ( (c = pgm_read_byte(progmem_s++)) )
	{
   put_c(c);
	}
}
*/
// --- [ eof ] ----------------------------------------------------------------