// --- [ owi_main.c ] ----------------------------------------------------------
//       tab = 3
//
//      Test fr die Konvertierung der Messwerte des Sensors DS18B20 in Temperaturwerte
//      
// ----------------------------------------------------------------------------

#define EXTERN

#include <avr/io.h>
#include <avr/interrupt.h>
#include <inttypes.h>
#include <stdlib.h>
#include <util/delay.h>
#include <stdio.h>
#include "rs232.h"

// --- lokale Variablen ------------------------------------------------------

uint8_t ow_buffer[2];
char msg[10];

// --- lokale Funktionen ------------------------------------------------------

void DS18B20_convert_temperatur(void);
// ----------------------------------------------------------------------------
int main(void)
{
uint16_t t, i;


// --- die Serielle Schnittstelle aktivieren
RS232_init();
asm volatile ("sei");							// fr Timer und RX erforderlich

put_s("start");
put_c(13);

t = 255;												// t zhlt von +128 bis -128
i = 512;

put_c(13);

while(i--) 
	{
	ow_buffer[0] = (uint8_t) (t);				// das low-Byte
	ow_buffer[1] = (uint8_t) (t >> 8);		// das high-Byte
	
	put_s(itoa(t, msg, 10));					// Zhler dezimal ausgeben
	put_s(" : ");
	
	put_s("0x");
	put_s(itoa(t, msg, 16));					// Zhler hexadezimal ausgeben
	put_s(" : ");

	DS18B20_convert_temperatur();				// Temperatur konvertieren
	put_s(msg);										// und ausgeben
	put_c(13);
	t--;
	}
	
put_s("ready");

while(1);											// das wars
}
	

// ----------------------------------------------------------------------------
// wandelt den Messwert, der aus 2 Byte besteht, in einen String (mit einer Nachkommastelle) um.
// Der Messwert steht rechtsbndig in den globalen Variablen ow_buffer[0] und ow_buffer[1],
// (die Werte entsprechen scratchpad.Byte[0] / scratchpad.Byte[1])
// Das Ergebnis wird ber den globalen String msg[] zurckgegeben.
// Die Dezimalstellen knnen entweder berechnet oder aus einer Tabelle entnommen werden
// letzter Weg sollte schneller sein - bentigt aber mehr SRAM.
void DS18B20_convert_temperatur(void)
{
//const uint8_t dez_tabelle[16] ={ 0, 0, 1, 1, 2, 3, 3 ,4 ,5 ,5 ,6 ,7 ,7 ,8 ,9, 9 };
int16_t temp16;
uint8_t i = 0;

temp16  = (ow_buffer[1] << 8);					// das high-Byte nach links in die 16bit-Variable schieben 
temp16 += (ow_buffer[0] & 0xF0);					// das low-Byte ohne Dezimalstellen addieren
temp16 /= 16;											// durch Division alles um 4 Stellen nach rechts schieben (dabei Sign-Bits einfgen !!)
temp16 *= 10;											// und mit 10 multiplizieren, um Platz fr die Nachkommastelle zu machen

// die Nachkommastelle: temp_lo * 0.625 = temp_lo * 625 / 1000 = temp_lo * 640 / 1024
ow_buffer[0] &= 0x0F; 								// die Nachkommastelle freistellen 
temp16 += (int16_t)ow_buffer[0] * 640 / 1024;// von 16 Stellen auf 10 Stellen umrechnen
//temp16 += dez_tabelle[ow_buffer[0]];			// oder aus einer Tabelle einlesen
															// Nun das Dezimaltrennzeichen einschmuggeln:
itoa(temp16, msg, 10);								// die Zahl in einen String umwandeln

while(msg[i]) i++;									// die Position der terminierende /0 finden
msg[i] = msg[i - 1];									// die Nachkommastelle nach rechts schieben
msg[i - 1] = '.';										// statt dessen ein Dezimaltrennzeichen einfgen
msg[++i] = 0;											// Am Ende wieder eine /0 anfgen

}

// --- [ eof ] ----------------------------------------------------------------