#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <errno.h>
#include <stropts.h>
#include <unistd.h>
#include <string.h>


#define NTSC 0
#define PAL 1
#define OFF 0
#define ON 1

#define DISPLAY_HEIGHT 220
#define DISPLAY_WIDTH 176

#define TV_WIDTH 768
#define TV_HEIGHT 576

int TvTurn(int tv, int on) {
    //0x7A02 => ON
    //0x7A03 => OFF
    unsigned int val = (on == 1) ? (0x7A02) : (0x7A03);
    if(ioctl(tv, val) < 0) {
        printf("ioctl() error '%i' in TvTurn.\n", errno);
        return -1;
    }
    return 0;
}

//mode = 0 means NTSC-mode
//mode = 1 means PAL-mode
int TvInitVideoEncoder(int tv, unsigned int mode) {
    if(ioctl(tv, 0x7A01, mode) < 0) {
        printf("ioctl() error '%i' in TvInitVideoEncoder.\n", errno);
        return -1;
    }
    return 0;
}

int TvClear(int tv) {
    return 0;
}

int TvOpen(char* link) {
    int f = open(link, 0x801);
    if(f < 0) {
        printf("An error occurred while trying to open the device: %i\n", errno);
        return -1;
    }
    int e = fcntl(f, 0x1);
    if(e < 0) {
        printf("fcntl() error: %i\n, line: %i\n", errno, __LINE__);
        return -1;
    }
    e = fcntl(f, 0x2);
    if(e < 0) {
        printf("fcntl() error: %i\n, line: %i\n", errno, __LINE__);
        return -1;
    }
    return f;
}

int TvClose(int tv) {
    if(close(tv) < 0) {
        printf("close() error: %i, line: %i\n", errno, __LINE__);
        return -1;
    }
    return 0;
}

int TvGetParameters(int tv, FILE* fb) {
    if(ioctl(tv, 0x7A08, fb)) {
        printf("ioctl() error: %i, line: %i\n", errno, __LINE__);
        return -1;
    }
    return 0;
}

int main(int argc, char* argv[])
{
    printf("Vx500 TVlink tester v0.1\n");
    if(argc < 2) {
        printf("Too few arguments.\nUsage: %s <cmd>\n", argv[0]);
        printf("Commands: on, off, cleartv, cleardisplay, ntsc, pal\n");
        return -1;
    }
    
    //OpenTvLink
    int tv = TvOpen("/dev/tvlink");
    if(tv < 0)
        return -1;
    
    TvTurn(tv, ON);
    
    if(strcmp(argv[1], "on") == 0) {
        TvTurn(tv, ON);
        TvClose(tv);
    } 
    else if(strcmp(argv[1], "off") == 0) {
        TvTurn(tv, OFF);
        TvClose(tv);
    }
    else if(strcmp(argv[1], "ntsc") == 0) {
        printf("Changing mode to NTSC\n");
        TvInitVideoEncoder(tv, NTSC);
        TvTurn(tv, OFF);
        TvTurn(tv, ON);
        TvClose(tv);
    }
    else if(strcmp(argv[1], "pal") == 0) {
        printf("Changing mode to PAL\n");
        TvInitVideoEncoder(tv, PAL);
        TvTurn(tv, OFF);
        TvTurn(tv, ON);
        TvClose(tv);
    }
    else if(strncmp(argv[1], "clear", 5) == 0) {
        printf("Clearing screen\n");
        char fbstr[9];
        int pixels;
        if(strcmp(argv[1], "cleartv") == 0) {
            pixels = TV_HEIGHT*TV_WIDTH;
            strcpy(fbstr, "/dev/fb2");
        } else if(strcmp(argv[1], "cleardisplay") == 0) {
            pixels = DISPLAY_HEIGHT*DISPLAY_WIDTH;
            strcpy(fbstr, "/dev/fb0");
        } else {
            printf("Please choose cleartv or cleardisplay!\n");
            return -1;
        }
        FILE *fb2 = fopen(fbstr, "wb");
        
        TvGetParameters(tv, fb2);
        TvClose(tv);
        
        unsigned char rgbx[] = {0x00, 0x00, 0x00, 0x00};
        int a;
        for(a = 0; a < pixels; a++) {
            fwrite(rgbx, 4, 1, fb2);
        }
    }
    
	printf("Finished.\n");
	return 0;
}
