Public Class Form1
    Public Const div_y = 10
    Public Const div_x = 12
    Public Const box_delta_y = 40
    Public Const box_delta_x = 40
    Public Const c_RX_Count = 650 '512

    Dim Data(c_RX_Count + 1) As Byte
    Dim Time_Bytes_Print As Integer
    Dim Time_div_set As Byte
    Dim restart_count As Byte
    Dim TrigPos As Boolean
    Dim trigoff As Byte
    Dim trigger_delay As Byte
    Dim trigger_prev As Boolean
    Dim sync_plus As Boolean
    Dim hold As Boolean
    Private TimeLineX1 As Decimal
    Private TimeLineX2 As Decimal
    Dim myColorT1 = Color.DarkBlue
    Dim myColorT2 = Color.DarkRed
    Dim movingTimeL1 As Boolean
    Dim movingTimeL2 As Boolean
    Dim visbleTimeL As Boolean
    Dim TimeBase As Decimal
    Dim TimeDim As String
    Dim FrequenzDim As String
    Dim PictureBox_Width As Decimal
    Dim Uss_corr As Decimal = 22.8
    Dim UssGr_corr As Decimal = 1.175
    Dim Y0_line As Decimal = 146



    Private Sub Form1_Load(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.Load
        Dim ports() As String
        Dim port As String
        Dim count As Integer
        visbleTimeL = False
        movingTimeL1 = False
        movingTimeL2 = False
        TimeLineX1 = box_delta_x
        TimeLineX2 = box_delta_x
        PictureBox_Width = PictureBox1.Width
        Time_Bytes_Print = 100
        Write_Spectrum()
        Timer1.Start()
        'Com Ports suchen und in Liste eintragen
        ports = System.IO.Ports.SerialPort.GetPortNames
        ComboBox_ComPort.Text = ports(0)
        For Each port In ports
            ComboBox_ComPort.Items.Add(port)
        Next port

        For count = 0 To c_RX_Count
            Data(count) = Y0_line
        Next
        ComboBox_ComPort.Text = ReadIniValue(My.Application.Info.DirectoryPath & "\MyScope.ini", "Default", "Port")
        Time_div_set = ReadIniValue(My.Application.Info.DirectoryPath & "\MyScope.ini", "Scope", "Time-div")
        If (Time_div_set < 0) And (Time_div_set > 14) Then
            Time_div_set = 12       ' Zeitbasis auf 1 ms
            TextBox_Zeit_x.Text = "1 ms"
        Else
            TextBox_Zeit_x.Text = ReadIniValue(My.Application.Info.DirectoryPath & "\MyScope.ini", "Scope", "Time-Text")
        End If
        TrackBar2.Value = ReadIniValue(My.Application.Info.DirectoryPath & "\MyScope.ini", "Scope", "Triggervalue")
        If (TrackBar2.Value < 0) And (TrackBar2.Value > 255) Then
            TrackBar2.Value = 170
        End If
        TrackBar1.Value = ReadIniValue(My.Application.Info.DirectoryPath & "\MyScope.ini", "Scope", "Y-Position")
        If (TrackBar1.Value < 0) And (TrackBar1.Value > 255) Then
            TrackBar1.Value = 128
        End If
        Uss_corr = ReadIniValue(My.Application.Info.DirectoryPath & "\MyScope.ini", "Measurement-correction", "Uss-corr")
        If (Uss_corr = 0) Or (Uss_corr > 1000) Then
            TextBox4.Visible = False
            Uss_corr = 1
        End If
        UssGr_corr = ReadIniValue(My.Application.Info.DirectoryPath & "\MyScope.ini", "Measurement-correction", "UssGraph-corr")
        Y0_line = ReadIniValue(My.Application.Info.DirectoryPath & "\MyScope.ini", "Measurement-correction", "Y0-Line")
        SerialPort1.PortName() = ComboBox_ComPort.Text
    End Sub
    Private Sub Write_Spectrum()

        Dim U_low As Decimal = 256
        Dim U_high As Decimal = 0
        Dim Uss As Decimal
        Dim myGrafik As Graphics
        Dim myPen1 As New Pen(Color.Black, 2)
        Dim myPen2 As New Pen(Color.DarkGray, 1)
        Dim myPen3 As New Pen(Color.DarkGray, 3)
        Dim myPen4 As New Pen(Color.DarkRed, 3)
        Dim myPen41 As New Pen(Color.DarkRed, 2)

        Dim myPen5 As New Pen(Color.DarkRed, 2)
        Dim myPen6 As New Pen(Color.DarkBlue, 2)
        Dim count As Decimal

        Dim pb_x As Decimal
        Dim pb_y As Decimal

        Dim delta_y As Decimal
        Dim delta_x As Decimal

        Dim delta_y1 As Decimal
        Dim delta_x1 As Decimal

        Dim grafx As BufferedGraphics
        Dim context As BufferedGraphicsContext

        Dim trigger_marker As Byte = 1

        context = BufferedGraphicsManager.Current
        context.MaximumBuffer = New Size(PictureBox1.Width + 1, PictureBox1.Height + 1)
        grafx = context.Allocate(PictureBox1.CreateGraphics(), New Rectangle(0, 0, PictureBox1.Width, PictureBox1.Height))

        'clear buffer
        grafx.Graphics.FillRectangle(Brushes.ForestGreen, 0, 0, PictureBox1.Width, PictureBox1.Height)

        myGrafik = Graphics.FromHwnd(hwnd:=PictureBox1().Handle)

        If Time_Bytes_Print = 0 Then Time_Bytes_Print = 1 '512


        pb_x = PictureBox1.Width - (2 * box_delta_x)
        pb_y = PictureBox1.Height - (2 * box_delta_y)

        delta_y = pb_y / div_y
        delta_x = pb_x / div_x

        delta_y1 = pb_y / 255              'AD-Wandler max. Digitalwert
        delta_x1 = pb_x / Time_Bytes_Print 'RX_DATA

        'paint horizontal lines
        For count = 0 To div_y
            If count = 5 Then
                grafx.Graphics.DrawLine(myPen3, box_delta_x, (delta_y * count) + box_delta_y, pb_x + box_delta_x, (delta_y * count) + box_delta_y)
            Else
                grafx.Graphics.DrawLine(myPen2, box_delta_x, (delta_y * count) + box_delta_y, pb_x + box_delta_x, (delta_y * count) + box_delta_y)
            End If
        Next

        'paint vertical lines
        For count = 0 To div_x
            If count = 6 Then
                grafx.Graphics.DrawLine(myPen3, (delta_x * count) + box_delta_x, box_delta_y, (delta_x * count) + box_delta_x, pb_y + box_delta_y)
            Else
                grafx.Graphics.DrawLine(myPen2, (delta_x * count) + box_delta_x, box_delta_y, (delta_x * count) + box_delta_x, pb_y + box_delta_y)
            End If
        Next

        'paint data line
        For count = 1 To Time_Bytes_Print 'RX_DATA
            grafx.Graphics.DrawLine(myPen1, ((count) * delta_x1) - delta_x1 + box_delta_x, (255 - Data(count)) * UssGr_corr * delta_y1 + box_delta_y, (count * delta_x1) + box_delta_x, (255 - Data(count + 1)) * UssGr_corr * delta_y1 + box_delta_y)
            If (U_high < Data(count)) Then
                U_high = Data(count)
            End If
            If (U_low > Data(count)) Then
                U_low = Data(count)
            End If
            If (trigger_marker > 0) Then
                If (Data(count) >= trigoff) Then
                    If (trigger_delay > 0) And Not (trigger_prev) Then 'bei Vortriggerung Dreieck darstellen
                        grafx.Graphics.DrawLine(myPen41, box_delta_x - 2, (255 - trigoff) * UssGr_corr * delta_y1 + box_delta_y, box_delta_x + 4, (255 - trigoff) * UssGr_corr * delta_y1 + box_delta_y + 4)
                        grafx.Graphics.DrawLine(myPen41, box_delta_x - 2, (255 - trigoff) * UssGr_corr * delta_y1 + box_delta_y, box_delta_x + 4, (255 - trigoff) * UssGr_corr * delta_y1 + box_delta_y - 4)
                        grafx.Graphics.DrawLine(myPen41, box_delta_x + 4, (255 - trigoff) * UssGr_corr * delta_y1 + box_delta_y + 4, box_delta_x + 4, (255 - trigoff) * UssGr_corr * delta_y1 + box_delta_y - 4)
                        trigger_marker = 0
                    Else
                        If TrigPos Then 'Triggerpunkt auf steigende Flanke
                            grafx.Graphics.DrawEllipse(myPen4, ((count) * delta_x1) - delta_x1 + box_delta_x - 2, (255 - trigoff) * UssGr_corr * delta_y1 + box_delta_y, 2, 2)
                            trigger_marker = 0
                        Else
                            trigger_marker = 2
                        End If
                    End If
                ElseIf (Data(count) <= trigoff) And (trigger_marker = 2) Then 'Triggerpunkt auf abfallende Flanke
                    grafx.Graphics.DrawEllipse(myPen4, ((count) * delta_x1) - delta_x1 + box_delta_x - 2, (255 - trigoff) * UssGr_corr * delta_y1 + box_delta_y, 2, 2)
                    trigger_marker = 0
                End If
                End If
        Next
        If Not (trigger_marker = 0) Then  'Wenn TriggerMarker nicht gezeichnet werden konnte, trotzdem links zeichnen
            grafx.Graphics.DrawEllipse(myPen4, box_delta_x - 2, (255 - trigoff) * UssGr_corr * delta_y1 + box_delta_y, 2, 2)
        End If
        If visbleTimeL Then 'Cursor-Linien zeichnen
            Dim startVert1 As New Point(TimeLineX2, box_delta_y)
            Dim endVert1 As New Point(TimeLineX2, PictureBox1.Height - box_delta_y + 2)
            ' Linie zeichnen 
            grafx.Graphics.DrawRectangle(myPen5, TimeLineX2 - 3, box_delta_y - 5, 5, 5)
            grafx.Graphics.DrawLine(myPen5, startVert1, endVert1)
            Dim startVert2 As New Point(TimeLineX1, box_delta_y)
            Dim endVert2 As New Point(TimeLineX1, PictureBox1.Height - box_delta_y + 2)
            ' Linie zeichnen 
            grafx.Graphics.DrawRectangle(myPen6, TimeLineX1 - 3, box_delta_y - 5, 5, 5)
            grafx.Graphics.DrawLine(myPen6, startVert2, endVert2)
        End If

        'display buffer
        grafx.Render(myGrafik)
        Uss = (U_high - U_low) / Uss_corr
        TextBox4.Text = "Uss " + Format(Uss, "0.0 V")
    End Sub
    Private Sub Form1_SizeChanged(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.SizeChanged
        If PictureBox_Width = 0 Then
            PictureBox_Width = 1
        End If
        TimeLineX2 = ((TimeLineX2 - box_delta_x) * (PictureBox1.Width) / (PictureBox_Width)) + box_delta_x
        TimeLineX1 = ((TimeLineX1 - box_delta_x) * (PictureBox1.Width) / (PictureBox_Width)) + box_delta_x
        PictureBox_Width = PictureBox1.Width
        Write_Spectrum()
    End Sub

    Private Sub Timer1_Tick(ByVal sender As Object, ByVal e As System.EventArgs) Handles Timer1.Tick
        If SerialPort1.IsOpen = True Then
            SerialPort1.Write("GET")
            SerialPort1.Write(Chr(13))
        End If
        CalculateTime()
        Write_Spectrum()
    End Sub
    Private Sub SerialPort1_DataReceived(ByVal sender As Object, ByVal e As System.IO.Ports.SerialDataReceivedEventArgs) Handles SerialPort1.DataReceived
        Dim Byte_RX_Count As Integer
        Dim count As Integer
        If SerialPort1.IsOpen Then
            For Byte_RX_Count = 0 To c_RX_Count
                Try
                    While SerialPort1.BytesToRead = 0
                    End While
                    Data(Byte_RX_Count) = SerialPort1.ReadByte()
                Catch
                End Try
            Next
            If hold Then
                For count = 1 To Time_Bytes_Print
                    If TrigPos Then
                        If Data(count) >= trigoff Then
                            Timer1.Stop()
                            Exit Sub
                        End If
                    Else
                        If Data(count) <= trigoff Then
                            Timer1.Stop()
                            Exit Sub
                        End If
                    End If
                Next
            End If
        End If
    End Sub


    Private Sub Button_ComPort_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button_ComPort.Click
        'Button COM Port Open/Close
        If SerialPort1.IsOpen = False Then
            Try
                SerialPort1.Open()
            Catch
                MsgBox("Error open " + ComboBox_ComPort.Text)
                Exit Sub
            End Try
            Button_ComPort.Text = "CLOSE"
            Button_ComPort.BackColor = SystemColors.Control
            ComboBox_ComPort.Enabled = False

            '            Time_div_set = 12       ' Zeitbasis auf 1 ms
            Time_print()
            set_AC()                ' AC
            '           TrackBar2.Value = 170   ' Trigger_Offset
            set_triggeroff()
            set_trigfl()            ' positive Flanke
            TrackBar3.Value = 0     ' keine Triggerverzgerung
            set_trigger_delay()
            sync_plus = True        ' wird gleich zurckgeschaltet, damit nicht mit sync_plus (gelb) anfngt
            set_trigger_del()       ' Schalter auf Triggerverzgerung
            sync_plus = False       ' sonst msste im ungnstigsten Fall Button 2 mal bettigt werden
            hold = True
            set_hold()
            '            TrackBar1.Value = 128
            set_y_pos()             ' Y-Position Offset
        Else
            Button_ComPort.Text = "OPEN"
            ComboBox_ComPort.Enabled = True
            Button_ComPort.BackColor = Color.Red
            SerialPort1.Close()
            Button_AC.BackColor = SystemColors.Control
            Button_DC.BackColor = SystemColors.Control
            Button_Tr_pos.BackColor = SystemColors.Control
            Button_Tr_neg.BackColor = SystemColors.Control
            Button_Tr_prev.BackColor = SystemColors.Control
            Button_Tr_prev.ForeColor = SystemColors.ControlText
            Button_Tr_delay.BackColor = SystemColors.Control
            Button_Tr_delay.ForeColor = SystemColors.ControlText
            Button_Hold.BackColor = SystemColors.Control
            GroupBox7.ForeColor = SystemColors.ControlText
        End If
    End Sub

    Private Sub Button_t_plus_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button_t_plus.Click
        If SerialPort1.IsOpen = True Then
            If Time_div_set < 14 Then
                Time_div_set = Time_div_set + 1
            End If
            Time_print()
        End If
    End Sub

    Private Sub Button_t_minus_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button_t_minus.Click
        If SerialPort1.IsOpen = True Then
            If Time_div_set > 0 Then
                Time_div_set = Time_div_set - 1
            End If
            Time_print()
        End If
    End Sub
    Private Sub Time_print()
        If (Time_div_set = 0) Then
            ' 100 ns
            Time_Bytes_Print = 60
            '1 * 20ns * 60 Sampels /12Div = 100ns ** H
            SerialPort1.Write("DIV 0,0")
            SerialPort1.Write(Chr(13))
            TimeBase = 100
            TimeDim = " ns"
            FrequenzDim = "MHz"
        End If

        If (Time_div_set = 1) Then
            ' 250 ns
            Time_Bytes_Print = 150
            '1 * 20ns * 150 Sampels /12Div = 250ns ** H
            SerialPort1.Write("DIV 0,0")
            SerialPort1.Write(Chr(13))
            TimeBase = 250
            TimeDim = " ns"
            FrequenzDim = "MHz"
        End If

        If (Time_div_set = 2) Then
            ' 500 ns
            Time_Bytes_Print = 300
            '1 * 20ns * 300 Sampels / 12Div = 500ns ** H
            SerialPort1.Write("DIV 0,0")
            SerialPort1.Write(Chr(13))
            TimeBase = 500
            TimeDim = " ns"
            FrequenzDim = "MHz"
        End If
        If (Time_div_set = 3) Then
            ' 1 s
            Time_Bytes_Print = 600
            '1 * 20ns * 600Sampels / 12 Div = 1000ns 1s ** H
            SerialPort1.Write("DIV 0,0")
            SerialPort1.Write(Chr(13))
            TimeBase = 1
            TimeDim = " s"
            FrequenzDim = "KHz"
        End If
        If (Time_div_set = 4) Then
            ' 2.5 s
            Time_Bytes_Print = 500
            '3 * 20ns * 500Sampels / 12 Div = 2500ns 2,5s ** H
            SerialPort1.Write("DIV 0,2")
            SerialPort1.Write(Chr(13))
            TimeBase = 2.5
            TimeDim = " s"
            FrequenzDim = "KHz"
        End If

        If (Time_div_set = 5) Then
            '5 s
            Time_Bytes_Print = 600
            '5 * 20ns * 600Sampels / 12 Div = 5000ns 5s ** H
            SerialPort1.Write("DIV 0,4")
            SerialPort1.Write(Chr(13))
            TimeBase = 5
            TimeDim = " s"
            FrequenzDim = "KHz"
        End If

        If (Time_div_set = 6) Then
            ' 10 s
            Time_Bytes_Print = 600
            '10 * 20ns * 600 Sampels / 12Div = 10000 ns 10 s ** H
            SerialPort1.Write("DIV 0,9")
            SerialPort1.Write(Chr(14))
            TimeBase = 10
            TimeDim = " s"
            FrequenzDim = "KHz"
        End If

        If (Time_div_set = 7) Then
            ' 25 s
            Time_Bytes_Print = 625
            '12 * 2 * 20ns * 625 Sampels /12Div = 25000 ns 25 s ** H
            SerialPort1.Write("DIV 3,11")
            SerialPort1.Write(Chr(13))
            TimeBase = 25
            FrequenzDim = "KHz"
            TimeDim = " s"
        End If

        If (Time_div_set = 8) Then
            ' 50 s
            Time_Bytes_Print = 469
            '2 * 32 * 20ns * 469 Sampels /12Div = 50027 ns ca 50 s ** H
            SerialPort1.Write("DIV 1,1")
            SerialPort1.Write(Chr(13))
            TimeBase = 50
            TimeDim = " s"
            FrequenzDim = "KHz"
        End If

        If (Time_div_set = 9) Then
            ' 100 s
            Time_Bytes_Print = 625
            '3 * 32 * 20ns * 625 Sampels /12Div = 100000ns 100s ** H
            SerialPort1.Write("DIV 1,2")
            SerialPort1.Write(Chr(13))
            TimeBase = 100
            TimeDim = " s"
            FrequenzDim = "KHz"
        End If

        If (Time_div_set = 10) Then
            ' 250 s
            Time_Bytes_Print = 521
            '9 * 32 * 20ns * 521 Sampels /12Div = 250080ns ca 250s ** H
            SerialPort1.Write("DIV 1,8")
            SerialPort1.Write(Chr(13))
            TimeBase = 250
            TimeDim = " s"
            FrequenzDim = "KHz"
        End If

        If (Time_div_set = 11) Then
            ' 500 s
            Time_Bytes_Print = 625
            '15 * 32 * 20ns * 625Sampels /12Div = 500000ns 500s ** H
            SerialPort1.Write("DIV 1,14")
            SerialPort1.Write(Chr(13))
            TimeBase = 500
            TimeDim = " s"
            FrequenzDim = "KHz"
        End If

        If (Time_div_set = 12) Then
            ' 1 ms
            Time_Bytes_Print = 469
            '5 * 256 * 20ns * 469Sampels /12Div = 1000533ns ca 1ms
            SerialPort1.Write("DIV 2,4")
            SerialPort1.Write(Chr(13))
            TimeBase = 1
            TimeDim = " ms"
            FrequenzDim = "Hz"
        End If

        If (Time_div_set = 13) Then
            ' 2.5 ms
            Time_Bytes_Print = 586
            '10 * 256 * 20ns * 586Sampels /12Div = 2500267ns ca 2.5ms
            SerialPort1.Write("DIV 2,9")
            SerialPort1.Write(Chr(13))
            TimeBase = 2.5
            TimeDim = " ms"
            FrequenzDim = "Hz"
        End If

        If (Time_div_set = 14) Then
            ' 5 ms
            Time_Bytes_Print = 558
            '21 * 256 * 20ns * 558Sampels /12Div = 4999680ns ca 5ms
            SerialPort1.Write("DIV 2,20")
            SerialPort1.Write(Chr(13))
            TimeBase = 5
            TimeDim = " ms"
            FrequenzDim = "Hz"
        End If
        TextBox_Zeit_x.Text = Format(TimeBase, "") + TimeDim
        CalculateTime()
    End Sub

    Private Sub Button_set_AC_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button_AC.Click
        set_AC()
    End Sub
    Private Sub set_AC()
        If SerialPort1.IsOpen = True Then
            Button_AC.BackColor = Color.LightGreen()
            Button_DC.BackColor = SystemColors.Control
            SerialPort1.Write("AC")
            SerialPort1.Write(Chr(13))
        End If
    End Sub

    Private Sub Button_set_DC_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button_DC.Click
        set_DC()
    End Sub
    Private Sub set_DC()
        If SerialPort1.IsOpen = True Then
            Button_DC.BackColor = Color.LightGreen()
            Button_AC.BackColor = SystemColors.Control
            SerialPort1.Write("DC")
            SerialPort1.Write(Chr(13))
        End If
    End Sub
    Private Sub TrackBar1_Scroll(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles TrackBar1.Scroll
        set_y_pos()
    End Sub
    Private Sub set_y_pos()
        Dim offset As Byte
        If SerialPort1.IsOpen = True Then
            offset = TrackBar1.Value
            SerialPort1.Write("OFFSET")
            SerialPort1.Write(Str(offset))
            SerialPort1.Write(Chr(13))
        End If
    End Sub


    Private Sub ComboBox_ComPort_SelectedIndexChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles ComboBox_ComPort.SelectedIndexChanged
        SerialPort1.PortName() = ComboBox_ComPort.Text
    End Sub

    Private Sub Button_Pr_print_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button_Pr_print.Click
        If PrintDialog1.ShowDialog() = Windows.Forms.DialogResult.OK Then
            PrintDocument1.Print()
        End If
    End Sub

    Private Sub Button_Pr_prev_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button_Pr_prev.Click
        PrintPreviewDialog1.Document = PrintDocument1
        If PrintPreviewDialog1.ShowDialog() = Windows.Forms.DialogResult.OK Then
            PrintDocument1.Print()
        End If
    End Sub

    Private Sub PrintDocument1_PrintPage(ByVal sender As System.Object, ByVal e As System.Drawing.Printing.PrintPageEventArgs) Handles PrintDocument1.PrintPage
        Dim grafx As Graphics = e.Graphics
        Dim myPen1 As New Pen(Color.Black, 1)
        Dim myPen2 As New Pen(Color.DarkGray, 1)
        Dim myPen3 As New Pen(Color.DarkGray, 3)
        Dim count As Integer

        Dim pb_x As Integer
        Dim pb_y As Integer

        Dim delta_y As Decimal
        Dim delta_x As Decimal

        Dim delta_y1 As Decimal
        Dim delta_x1 As Decimal

        If Time_Bytes_Print > c_RX_Count Then Time_Bytes_Print = c_RX_Count
        If Time_Bytes_Print = 0 Then Time_Bytes_Print = c_RX_Count

        pb_x = 650 - (2 * box_delta_x)
        pb_y = 520 - (2 * box_delta_y)

        delta_y = pb_y / div_y
        delta_x = pb_x / div_x

        delta_y1 = pb_y / 255
        delta_x1 = pb_x / Time_Bytes_Print 'RX_DATA
        'paint horizontal lines
        For count = 0 To div_y
            If count = 5 Then
                grafx.DrawLine(myPen3, box_delta_x, (delta_y * count) + box_delta_y, pb_x + box_delta_x, (delta_y * count) + box_delta_y)
            Else
                grafx.DrawLine(myPen2, box_delta_x, (delta_y * count) + box_delta_y, pb_x + box_delta_x, (delta_y * count) + box_delta_y)
            End If
        Next

        'paint vertical lines
        For count = 0 To div_x
            If count = 6 Then
                grafx.DrawLine(myPen3, (delta_x * count) + box_delta_x, box_delta_y, (delta_x * count) + box_delta_x, pb_y + box_delta_y)
            Else
                grafx.DrawLine(myPen2, (delta_x * count) + box_delta_x, box_delta_y, (delta_x * count) + box_delta_x, pb_y + box_delta_y)
            End If
        Next

        'paint data line
        For count = 1 To Time_Bytes_Print 'RX_DATA
            grafx.DrawLine(myPen1, ((count) * delta_x1) - delta_x1 + box_delta_x, (255 - Data(count)) * UssGr_corr * delta_y1 + box_delta_y, (count * delta_x1) + box_delta_x, (255 - Data(count + 1)) * UssGr_corr * delta_y1 + box_delta_y)
        Next
    End Sub

    Private Sub TrackBar2_Scroll(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles TrackBar2.Scroll
        set_triggeroff()
    End Sub
    Private Sub set_triggeroff()
        If SerialPort1.IsOpen = True Then
            trigoff = TrackBar2.Value
            SerialPort1.Write("TRIGOFF")
            SerialPort1.Write(Str(trigoff))
            SerialPort1.Write(Chr(13))
        End If
    End Sub
    Private Sub Button_Tr_pos_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button_Tr_pos.Click
        set_trigfl()
    End Sub
    Private Sub set_trigfl()
        If SerialPort1.IsOpen = True Then
            Button_Tr_pos.BackColor = Color.LightGreen()
            Button_Tr_neg.BackColor = SystemColors.Control
            TrigPos = True
            SerialPort1.Write("TRIGFL")
            SerialPort1.Write(Chr(13))
        End If
    End Sub

    Private Sub Button_Tr_neg_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button_Tr_neg.Click
        set_trigfh()
    End Sub
    Private Sub set_trigfh()
        If SerialPort1.IsOpen = True Then
            Button_Tr_neg.BackColor = Color.LightGreen()
            Button_Tr_pos.BackColor = SystemColors.Control
            TrigPos = False
            SerialPort1.Write("TRIGFH")
            SerialPort1.Write(Chr(13))
        End If
    End Sub
    Private Sub CalculateTime()
        Dim pTime As Decimal
        Dim pb_x As Decimal
        Dim delta_x As Decimal
        Dim Result As Decimal
        If visbleTimeL Then
            pTime = TimeLineX1 - TimeLineX2
            If pTime < 0 Then
                pTime = pTime * -1
            End If
            pb_x = PictureBox1.Width - (2 * box_delta_x)
            delta_x = pb_x / div_x
            Result = (TimeBase * pTime / delta_x)
            If Result >= 100 Then
                TextBox3.Text = Format(Result + 0.05, "0") + TimeDim
            ElseIf Result >= 10 Then
                TextBox3.Text = Format(Result + 0.005, "0.0") + TimeDim
            ElseIf Result >= 1 Then
                TextBox3.Text = Format(Result + 0.0005, "0.00") + TimeDim
            Else
                TextBox3.Text = Format(Result + 0.00005, "0.000") + TimeDim
            End If
            If Result <> 0 Then
                Result = 1000 / Result
                If Result >= 100 Then
                    TextBox2.Text = Format(Result + 0.05, "0 ") + FrequenzDim
                ElseIf Result >= 10 Then
                    TextBox2.Text = Format(Result + 0.005, "0.0 ") + FrequenzDim
                ElseIf Result < 1 Then
                    TextBox2.Text = Format(Result + 0.00005, "0.000 ") + FrequenzDim
                Else
                    TextBox2.Text = Format(Result + 0.0005, "0.00 ") + FrequenzDim
                End If
            Else
                TextBox2.Text = ""
            End If
        End If
    End Sub
    Private Sub PictureBox1_MouseMove(ByVal sender As System.Object, ByVal e As System.Windows.Forms.MouseEventArgs) Handles PictureBox1.MouseMove
        Dim graph As Graphics = Me.PictureBox1.CreateGraphics()
        Dim tx As Decimal
        Dim myColor As Color
        Dim TimeLinePoint As Point
        Dim TimeLinePoint_old As Point
        If movingTimeL1 Or movingTimeL2 Then
            If movingTimeL1 Then
                TimeLinePoint_old = New Point(TimeLineX1, e.Y)
                myColor = myColorT1
            Else
                TimeLinePoint_old = New Point(TimeLineX2, e.Y)
                myColor = myColorT2
            End If
            ' alte Linie lschen 
            DrawLines(graph, TimeLinePoint_old, Me.PictureBox1.BackColor)
            ' neues Linie zeichnen 
            tx = e.X
            If tx < box_delta_x Then
                tx = box_delta_x
            End If
            If tx > PictureBox1.Width - box_delta_x Then
                tx = PictureBox1.Width - box_delta_x
            End If
            TimeLinePoint = New Point(tx, e.Y)
            DrawLines(graph, TimeLinePoint, myColor)
            If movingTimeL1 Then
                TimeLineX1 = tx
            Else
                TimeLineX2 = tx
            End If
            graph.Dispose()
        End If
    End Sub

    Private Sub DrawLines(ByVal graph As Graphics, ByVal p As Point, ByVal c As Color)
        If visbleTimeL Then
            Dim myPenTimeL As New Pen(c, 2)
            Dim startVert As New Point(p.X, box_delta_y)
            Dim endVert As New Point(p.X, Me.PictureBox1.Height - box_delta_y + 2)
            ' Linie zeichnen 
            graph.DrawRectangle(myPenTimeL, p.X - 3, box_delta_y - 5, 5, 5)
            graph.DrawLine(myPenTimeL, startVert, endVert)
        End If
    End Sub

    Private Sub PictureBox1_MouseDown(ByVal sender As System.Object, ByVal e As System.Windows.Forms.MouseEventArgs) Handles PictureBox1.MouseDown
        If visbleTimeL And e.Button = Windows.Forms.MouseButtons.Left Then
            If e.X - 3 <= TimeLineX1 And e.X + 2 >= TimeLineX1 Then
                movingTimeL1 = True
            ElseIf e.X - 3 <= TimeLineX2 And e.X + 2 >= TimeLineX2 Then
                movingTimeL2 = True
            End If
        End If
    End Sub

    Private Sub PictureBox1_MouseUp(ByVal sender As System.Object, ByVal e As System.Windows.Forms.MouseEventArgs) Handles PictureBox1.MouseUp
        If e.Button = Windows.Forms.MouseButtons.Left Then
            movingTimeL1 = False
            movingTimeL2 = False
            CalculateTime()
        End If
    End Sub

    Private Sub Button_Cursor_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button_Cursor.Click
        If visbleTimeL Then
            visbleTimeL = False
            Button_Cursor.Text = "on"
            TextBox3.Text = ""
            TextBox2.Text = ""
        Else
            visbleTimeL = True
            Button_Cursor.Text = "off"
            CalculateTime()
        End If
    End Sub

    Private Sub TrackBar3_Scroll(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles TrackBar3.Scroll
        set_trigger_delay()
    End Sub
    Private Sub set_trigger_delay()
        If SerialPort1.IsOpen = True Then
            trigger_delay = TrackBar3.Value
            SerialPort1.Write("TRIGDEL")
            SerialPort1.Write(Str(trigger_delay))
            SerialPort1.Write(Chr(13))
            If (trigger_delay > 0) Then
                GroupBox7.ForeColor = Color.Red
            Else
                GroupBox7.ForeColor = SystemColors.ControlText
            End If
        End If

    End Sub
    Private Sub Button_Tr_prev_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button_Tr_prev.Click
        set_trigger_prev()
    End Sub
    Private Sub set_trigger_prev()
        If SerialPort1.IsOpen = True Then
            If trigger_prev Then
                If sync_plus Then
                    sync_plus = False
                    Button_Tr_prev.ForeColor = SystemColors.ControlText
                    SerialPort1.Write("NSYNCP")
                    SerialPort1.Write(Chr(13))
                Else
                    sync_plus = True 'nur bei Synchronisation Datenbertragung
                    Button_Tr_prev.ForeColor = Color.Yellow
                    SerialPort1.Write("SYNCP")
                    SerialPort1.Write(Chr(13))
                End If
            Else
                sync_plus = False
                Button_Tr_prev.ForeColor = SystemColors.ControlText
                Button_Tr_delay.ForeColor = SystemColors.ControlText
                SerialPort1.Write("NSYNCP")
                SerialPort1.Write(Chr(13))
                trigger_prev = True
            End If
            '            Button_Tr_delay.ForeColor = SystemColors.ControlText
            Button_Tr_prev.BackColor = Color.LightGreen()
            Button_Tr_delay.BackColor = SystemColors.Control
            SerialPort1.Write("TRPREV")
            SerialPort1.Write(Chr(13))
        End If
    End Sub

    Private Sub Button_Tr_delay_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button_Tr_delay.Click
        set_trigger_del()
    End Sub
    Private Sub set_trigger_del()
        If SerialPort1.IsOpen = True Then
            If Not (trigger_prev) Then
                If sync_plus Then
                    sync_plus = False
                    Button_Tr_delay.ForeColor = SystemColors.ControlText
                    SerialPort1.Write("NSYNCP")
                    SerialPort1.Write(Chr(13))
                Else
                    sync_plus = True 'nur bei Synchronisation Datenbertragung
                    Button_Tr_delay.ForeColor = Color.Yellow
                    SerialPort1.Write("SYNCP")
                    SerialPort1.Write(Chr(13))
                End If
            Else
                sync_plus = False
                Button_Tr_delay.ForeColor = SystemColors.ControlText
                Button_Tr_prev.ForeColor = SystemColors.ControlText
                SerialPort1.Write("NSYNCP")
                SerialPort1.Write(Chr(13))
                trigger_prev = False
            End If
            Button_Tr_delay.BackColor = Color.LightGreen()
            Button_Tr_prev.BackColor = SystemColors.Control
            SerialPort1.Write("TRDEL")
            SerialPort1.Write(Chr(13))
        End If
    End Sub

    Private Sub Button_Hold_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button_Hold.Click
        set_hold()
    End Sub

    Private Sub set_hold()
        If SerialPort1.IsOpen = True Then
            If hold Then
                hold = False
                Button_Hold.BackColor = SystemColors.Control
                If Not (sync_plus) Then
                    sync_plus = False 'nur bei Synchronisation Datenbertragung
                    SerialPort1.Write("NSYNCP")
                    SerialPort1.Write(Chr(13))
                End If
                Button_Hold.BackColor = SystemColors.Control
                Timer1.Start()
            Else
                hold = True
                Button_Hold.BackColor = Color.LightGreen()
                SerialPort1.Write("SYNCP") 'bei Hold immer sync_plus verwenden, aber nicht merken
                SerialPort1.Write(Chr(13))
            End If
        End If
    End Sub

    Private Sub Form1_FormClosing(ByVal sender As System.Object, ByVal e As System.Windows.Forms.FormClosingEventArgs) Handles MyBase.FormClosing
        WriteIniValue(My.Application.Info.DirectoryPath & "\MyScope.ini", "Default", "Port", (SerialPort1.PortName()))
        WriteIniValue(My.Application.Info.DirectoryPath & "\MyScope.ini", "Scope", "Time-div", (Time_div_set))
        WriteIniValue(My.Application.Info.DirectoryPath & "\MyScope.ini", "Scope", "Time-Text", (TextBox_Zeit_x.Text))
        WriteIniValue(My.Application.Info.DirectoryPath & "\MyScope.ini", "Scope", "Triggervalue", (TrackBar2.Value))
        WriteIniValue(My.Application.Info.DirectoryPath & "\MyScope.ini", "Scope", "Y-Position", (TrackBar1.Value))
        'If TextBox4.Visible Then
        'WriteIniValue(My.Application.Info.DirectoryPath & "\MyScope.ini", "Measurement-correction", "Uss-corr", (Uss_corr))
        'WriteIniValue(My.Application.Info.DirectoryPath & "\MyScope.ini", "Measurement-correction", "UssGraph-corr", (UssGr_corr))
        'End If
        'WriteIniValue(My.Application.Info.DirectoryPath & "\MyScope.ini", "Measurement-correction", "Y0-Line", (Y0_Line))
    End Sub
End Class