/*****************************************************************************
	LCD Treiber fr Standartdisplay 162A mit 4-Bit-Mode
	Name:			******
	Datum: 			30.05.2010
	Version: 		2.0
	file: 			LCDmodul.asm
	fr: 			ATmega16
	Taktfrequenz: 	4 MHz
******************************************************************************/

.device ATmega16
.nolist
.include "m16def.inc"

;Deklaration

.def	status	= 	r0
.def	temp	=	r16
.def	data	=	r17
.def	txt		=	r18


textz1:
	.db	"     HALLO      ",0,0		//Datensegment, 16 Byte je Zeichen anlegen
									//plus 2 Byte fr 0,0
textz2:
	.db "     HALLO      ",0,0

/**************************I/O-Konfiguration**********************************/

	ldi		temp,0xFE
	out		DDRA,temp
	ser		temp			
	out		DDRB,temp
	out		DDRC,temp
	out		DDRD,temp

	clr		temp
	out		PORTA,temp
	out		PORTB,temp
	out		PORTC,temp
	out		PORTD,temp 

	
	ldi		temp,LOW(RAMEND)	
	out		SPL,temp
	ldi		temp,HIGH(RAMEND)
	out		SPH,temp


/**************************MAIN***********************************************/
Main:
	
	rcall	lcd_init
	rcall	clear_lcd

text:
	ldi		data,0b00000000	;Cursor auf 1 Zeile Zeichen 1
	rcall	data2lcd

	clr		ZH				;Z auf 1. Zeichen von 1.Zeile setzen ;Z = indexregister
	ldi		ZL,LOW(textz1*2);mal 2 weil Byte und nicht Wortadressierung

	rcall	charout			;UP zur Textausgabe
	
	ldi		data,0b11000000
	rcall	data2lcd
	
	clr		ZH
	ldi		ZL,LOW(textz2*2)
	
	rcall	charout
ende:
	sbic	PINA,PA0
	rjmp	ende

	rcall	clear_lcd

	rjmp 	text

/**************************Unterprogramme************************************/
lcd_init:

	rcall	warten_5ms
	rcall	warten_5ms		;15ms warten
	rcall	warten_5ms

	ldi		data,0b00110000
	rcall	data2lcd
	rcall	warten_5ms		;Bitmusterm muss 3mal gesendet werden
	rcall	data2lcd
	rcall	data2lcd

	ldi		data,0b00101000	;Display 2 Zeilen und 5x7 Dots und 4-Bit-Mode
	rcall	data2lcd
	ldi		data, 0b00001111;Cursor On, blinking On
	rcall	data2lcd
	
	ret

;-----------------------------DATA2LCD-------------------------------------
data2lcd:
	
	push	temp
	mov		temp,data
	swap	temp
	andi	temp,0b00001111
	out		PORTB,temp		;temp(data) auf 4-Bit-Bus legen
	sbi		PORTB,PB4		;ENABLE HIGH
	nop						;0,25s warten
	nop						
	nop						
	nop						;=1s gewartet
	cbi		PORTB,PB4		;ENABLE LOW und Daten bernehmen

	mov		temp,data		;temp(data) auf 4-Bit-Bus legen
	andi	temp, 0b00001111
	out		PORTB,temp
	sbi		PORTB,PB4		;ENABLE HIGH
	nop						;0,25s warten
	nop						
	nop						
	nop						;=1s gewartet
	cbi		PORTB,PB4
	clr 	temp
	out		PORTB,temp		;PORTB lschen
	rcall	warten_100us
	pop		temp
	ret

;------------------------------Warten---------------------------------------

warten_5ms:

	ldi		r19,50			;50x0,1ms = 5ms
warten_5_1:
	ldi		r20,100			;100 x 1us = 0,1ms
warten_5_2:
	nop						;0,25us
	dec		r20				;0,25us
	brne	warten_5_2		;0,50us
							;brne frgt zero-flag ab, wenn z=0
	
	dec		r19				;r19 erniedrigen, schleife luft 50mal
	brne	warten_5_1		;wenn z=1 ret		
	ret
;----------------------------------------------------------------------------
warten_100us:

	ldi		r19,100
warten_100us_1:
	nop						;0,25us
	dec		r19				;0,25us
	brne 	warten_100us_1	;0,50us	
	ret		
		
;---------------------------------------------------------------------------
clear_lcd:

	ldi		data, 0b00000001
	rcall	data2lcd
	rcall	warten_5ms
	ret

;----------------------------------------------------------------------------
txt2lcd:

	push	temp
	mov		temp,txt
	swap	temp
	andi	temp,0b00001111
	out		PORTB,temp		;temp auf 4-Bit-Bus legen
	sbi		PORTB,PB7		;RS HIGH
	sbi		PORTB,PB4		;ENABLE HIGH
	nop						;0,25s warten
	nop						
	nop						
	nop						;=1s gewartet
	cbi		PORTB,PB4		;ENABLE LOW und Daten bernehmen
	cbi		PORTB,PB7		;RS LOW

	mov		temp,txt
	andi	temp,0b00001111
	out		PORTB,temp		;temp auf 4-Bit-Bus legen
	sbi		PORTB,PB7		;RS HIGH
	sbi		PORTB,PB4		;ENABLE HIGH
	nop						;0,25s warten
	nop						
	nop						
	nop						;=1s gewartet
	cbi		PORTB,PB4		;ENABLE LOW und Daten bernehmen
	cbi		PORTB,PB7		;RS LOW


	clr 	temp
	out		PORTB,temp		;PORTB lschen
	rcall	warten_100us
	pop		temp
	ret

;--------------------------------------CHAROUT-----------------------------
charout:
	
//	ld		status,Z 		;ldt den Inhalt der Speicherzelle auf die 
	lpm						;Z zeigt nach R0 = status
	tst		status			;prft Status auf 0. Wenn er 
							;bei .db	"     Hallo      ",0<----,0 auf 0 stt
							;dann breq charend
	breq	charend			
	mov		txt,status		;status nach txt kopieren
	rcall 	txt2lcd			;Zeichen an txt an lcd bertragen
	inc 	ZL				;Z um 1 erhhen
	rjmp	charout			;nchstes Zeichen ausgeben
			
charend:
	
	ret
