VERSION 5.00
Object = "{F9043C88-F6F2-101A-A3C9-08002B2F49FB}#1.2#0"; "comdlg32.ocx"
Object = "{831FDD16-0C5C-11D2-A9FC-0000F8754DA1}#2.0#0"; "MSCOMCTL.OCX"
Begin VB.Form Form1 
   Caption         =   "DXF 2 Eagle Converter"
   ClientHeight    =   8205
   ClientLeft      =   165
   ClientTop       =   735
   ClientWidth     =   10395
   LinkTopic       =   "Form1"
   ScaleHeight     =   8205
   ScaleWidth      =   10395
   StartUpPosition =   3  'Windows-Standard
   Begin VB.CheckBox Chk_Polyline 
      Caption         =   "POLYLINE"
      Height          =   255
      Left            =   4320
      TabIndex        =   23
      Top             =   1800
      Value           =   1  'Aktiviert
      Width           =   1335
   End
   Begin VB.CheckBox Chk_Circle 
      Caption         =   "CIRCLE"
      Height          =   255
      Left            =   4320
      TabIndex        =   22
      Top             =   1560
      Value           =   1  'Aktiviert
      Width           =   1095
   End
   Begin VB.CheckBox Chk_Arc 
      Caption         =   "ARC"
      Height          =   255
      Left            =   4320
      TabIndex        =   21
      Top             =   1320
      Value           =   1  'Aktiviert
      Width           =   855
   End
   Begin VB.CheckBox Chk_Line 
      Caption         =   "LINE"
      Height          =   255
      Left            =   4320
      TabIndex        =   20
      Top             =   1080
      Value           =   1  'Aktiviert
      Width           =   855
   End
   Begin VB.TextBox Txt_Linienstrke 
      Height          =   285
      Left            =   7920
      TabIndex        =   18
      Text            =   "0.01"
      Top             =   1320
      Width           =   975
   End
   Begin VB.CheckBox Chk_Auto_Offset 
      Caption         =   "Offset automatisch bestimmen"
      Height          =   255
      Left            =   960
      TabIndex        =   17
      Top             =   1440
      Width           =   3135
   End
   Begin VB.TextBox Txt_Layer 
      Height          =   285
      Left            =   7920
      TabIndex        =   15
      Text            =   "20"
      Top             =   930
      Width           =   975
   End
   Begin MSComctlLib.ProgressBar ProgressBar1 
      Height          =   375
      Left            =   0
      TabIndex        =   14
      Top             =   7800
      Width           =   10335
      _ExtentX        =   18230
      _ExtentY        =   661
      _Version        =   393216
      BorderStyle     =   1
      Appearance      =   0
   End
   Begin VB.CommandButton Btn_Start 
      Caption         =   "START"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   375
      Left            =   0
      TabIndex        =   13
      Top             =   2160
      Width           =   10335
   End
   Begin VB.OptionButton Option2 
      Caption         =   "Inch"
      Enabled         =   0   'False
      Height          =   255
      Left            =   9000
      TabIndex        =   12
      Top             =   1680
      Width           =   855
   End
   Begin VB.OptionButton Option1 
      Caption         =   "mm"
      Height          =   255
      Left            =   7920
      TabIndex        =   11
      Top             =   1680
      Value           =   -1  'True
      Width           =   855
   End
   Begin VB.CommandButton Btn_SCR 
      Caption         =   "..."
      Height          =   285
      Left            =   9840
      TabIndex        =   10
      Top             =   480
      Width           =   495
   End
   Begin VB.TextBox Txt_SCR 
      Height          =   285
      Left            =   960
      TabIndex        =   9
      Top             =   480
      Width           =   8775
   End
   Begin VB.TextBox Txt_DXF 
      Height          =   285
      Left            =   960
      TabIndex        =   8
      Top             =   120
      Width           =   8775
   End
   Begin VB.CommandButton Btn_DXF 
      Caption         =   "..."
      Height          =   285
      Left            =   9840
      TabIndex        =   5
      Top             =   120
      Width           =   495
   End
   Begin MSComDlg.CommonDialog CommonDialog1 
      Left            =   9840
      Top             =   840
      _ExtentX        =   847
      _ExtentY        =   847
      _Version        =   393216
   End
   Begin VB.TextBox Txt_Offset_Y 
      Height          =   285
      Left            =   2640
      TabIndex        =   2
      Top             =   1050
      Width           =   1455
   End
   Begin VB.TextBox Txt_Offset_X 
      Height          =   285
      Left            =   960
      TabIndex        =   1
      Top             =   1050
      Width           =   1455
   End
   Begin VB.TextBox Text1 
      Height          =   5055
      Left            =   0
      MultiLine       =   -1  'True
      ScrollBars      =   2  'Vertikal
      TabIndex        =   0
      Top             =   2640
      Width           =   10335
   End
   Begin VB.Label Label7 
      AutoSize        =   -1  'True
      Caption         =   "Objekte die konvertiert werden"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   400
         Underline       =   -1  'True
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   195
      Left            =   4320
      TabIndex        =   24
      Top             =   840
      Width           =   2175
   End
   Begin VB.Label Label6 
      Alignment       =   1  'Rechts
      Caption         =   "Linenstrke:"
      Height          =   255
      Left            =   6840
      TabIndex        =   19
      Top             =   1320
      Width           =   975
   End
   Begin VB.Label Label5 
      Alignment       =   1  'Rechts
      Caption         =   "Eagle Layer:"
      Height          =   255
      Left            =   6840
      TabIndex        =   16
      Top             =   960
      Width           =   975
   End
   Begin VB.Label Label4 
      Alignment       =   1  'Rechts
      AutoSize        =   -1  'True
      Caption         =   "SCR Datei:"
      Height          =   195
      Left            =   105
      TabIndex        =   7
      Top             =   480
      Width           =   795
   End
   Begin VB.Label Label3 
      Alignment       =   1  'Rechts
      AutoSize        =   -1  'True
      Caption         =   "DXF Datei:"
      Height          =   195
      Left            =   120
      TabIndex        =   6
      Top             =   120
      Width           =   780
   End
   Begin VB.Label Label2 
      Caption         =   "Offset Y"
      Height          =   255
      Left            =   2640
      TabIndex        =   4
      Top             =   840
      Width           =   1455
   End
   Begin VB.Label Label1 
      Caption         =   "Offset X"
      Height          =   255
      Left            =   960
      TabIndex        =   3
      Top             =   840
      Width           =   1455
   End
   Begin VB.Menu Menue_Version 
      Caption         =   "Version"
   End
End
Attribute VB_Name = "Form1"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
'    DXF2Eagle converts DXF File to Eagle's SCR files.
'    Source based partly on Hank Wallace (20-Mar-03) DXF2SCR.C Code

'    Copyright (C) 2010 Ronald Bernick
'
'    This program is free software: you can redistribute it and/or modify
'    it under the terms of the GNU General Public License as published by
'    the Free Software Foundation, either version 3 of the License, or
'    (at your option) any later version.
'
'    This program is distributed in the hope that it will be useful,
'    but WITHOUT ANY WARRANTY; without even the implied warranty of
'    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
'    GNU General Public License for more details.
'
'    You should have received a copy of the GNU General Public License
'    along with this program.  If not, see <http://www.gnu.org/licenses/>.

Option Explicit

Private Sub Btn_DXF_Click()
    CommonDialog1.Filter = "DXF Dateien|*.dxf"
    CommonDialog1.ShowOpen
    Txt_DXF.Text = CommonDialog1.FileName
    Txt_SCR.Text = Left(CommonDialog1.FileName, Len(CommonDialog1.FileName) - 3) & "scr"
End Sub

Private Sub Btn_SCR_Click()
    CommonDialog1.Filter = "SCR Dateien|*.scr"
    CommonDialog1.DefaultExt = "scr"
    CommonDialog1.ShowOpen
    Txt_SCR.Text = CommonDialog1.FileName
End Sub

Private Sub Btn_Start_Click()
    
    If Txt_DXF.Text <> "" And Txt_SCR.Text <> "" Then
        
        ReDim Unbekannte_Befehle_Anzahl(0)
        
        Conv_Halbkreise = 0
        Conv_Kreise = 0
        Conv_Linien = 0
        
        Linien = 0
        Kreise = 0
        Halbkreise = 0
        
        Me.MousePointer = vbHourglass
        Me.Refresh
        
        Text1.Text = "Hinweis: Bei groen Dateien kann da Laden u.U. mehrere Minuten dauern !" & vbCrLf & vbCrLf
        Text1.Text = Text1.Text & "Lade Datei " & CommonDialog1.FileName & "..."
        ProgressBar1.Value = 0
        DoEvents
        Open Txt_DXF.Text For Binary As #1
            Dateiinhalt = Input(LOF(1), #1)
        Close #1
        Text1.Text = Text1.Text & "fertig" & vbCrLf & vbCrLf
        
        Open Txt_SCR.Text For Output As #1
            Lines = Split(Dateiinhalt, vbCrLf)
            Text1.Text = Text1.Text & UBound(Lines) & " Zeilen der DXF Datei gelesen." & vbCrLf & vbCrLf
            
            If UBound(Lines) = 0 Then
                Text1.Text = Text1.Text & "Importierte Zeilen mit CRLF = 0, versuche CR" & vbCrLf
                Lines = Split(Dateiinhalt, vbCr)
                Text1.Text = Text1.Text & "Gelesene Zeilen der DXF Datei: " & UBound(Lines) & vbCrLf & vbCrLf
            End If
            
            If UBound(Lines) = 0 Then
                Text1.Text = Text1.Text & "Importierte Zeilen mit CR = 0, versuche LF" & vbCrLf
                Lines = Split(Dateiinhalt, vbLf)
                Text1.Text = Text1.Text & "Gelesene Zeilen der DXF Datei: " & UBound(Lines) & vbCrLf & vbCrLf
            End If
        
            If UBound(Lines) = 0 Then
                Text1.Text = Text1.Text & "unbekanntes Format. BEENDE Konvertierung." & vbCrLf
                Exit Sub
            End If
            
            'eine Zeile hinzufgen um nicht bei 0 anzufangen
            Text1.Text = Text1.Text & "Konvertiere Datei..."
            DoEvents
            ReDim Preserve Lines(UBound(Lines) + 1)
            For Zhler = UBound(Lines) - 1 To 0 Step -1
                Lines(Zhler + 1) = Lines(Zhler)
                ProgressBar1.Value = (UBound(Lines) - Zhler) * 100 / UBound(Lines)
            Next
            Lines(0) = ""
            ProgressBar1.Value = 0
            Text1.Text = Text1.Text & "fertig" & vbCrLf & vbCrLf
            
            Text1.Text = Text1.Text & "Fehlermeldungen / Unbekannte Befehle der DXF Datei: " & vbCrLf
            Text1.Text = Text1.Text & "----------------------------------------------------------------------------" & vbCrLf
        
            Print #1, "# DXF2SCR generated script file."
            Print #1, "Grid mm 0.1;"
            Print #1, "Set Wire_Bend 2;"
            Print #1, "Layer " & Val(Txt_Layer.Text) & ";"
            Print #1, "Change Font Vector;"
            ProgressBar1.Value = 0
            
            Zhler = 1
            ReDim Befehle_Anzahl(0)
            Unbekannte_Befehle = ""
            
            Linien = 0
            Kreise = 0
            Halbkreise = 0
            Polyline = 0
            
            Conv_Halbkreise = 0
            Conv_Kreise = 0
            Conv_Linien = 0
            Conv_Polyline = 0
            
            While Trim(Lines(Zhler)) <> "EOF"
                
                Tempstring = Trim(Lines(Zhler))
                
                'In geraden Zeilen stehen die Befehle wie Line,Arc usw. sowie die Werte
                If Zhler Mod 2 = 0 Then
                    
                    Select Case Tempstring
                        'suche nach Ende bei Line,Arc,Circle
                        Case "LINE", "ARC", "CIRCLE", "VERTEX", "SEQEND", "POLYLINE"
                            bEnde = False
                            bBefehl = True
                            For Zhler2 = Zhler To UBound(Lines)
                                If Zhler2 Mod 2 = 1 And Trim(Lines(Zhler2)) = "0" Then
                                    bEnde = True
                                    Exit For
                                End If
                            Next
                       
                        Case Else
                            bEnde = False
                            bBefehl = False
                            If IsNumeric(Trim(Lines(Zhler))) = False And Trim(Lines(Zhler - 1)) = "0" Then
                                If InStr(1, Unbekannte_Befehle, "||" & Trim(Lines(Zhler)) & "##") = 0 Then
                                    Unbekannte_Befehle = Unbekannte_Befehle & "||" & Trim(Lines(Zhler)) & "##"
                                    Unbekannte_Befehle = Unbekannte_Befehle & "1||"
                                    Unbekannte_Befehle = Replace(Unbekannte_Befehle, "||||", "||")
                                Else
                                    Dim Position, Ende2 As Long
                                    Position = InStr(1, Unbekannte_Befehle, "||" & Trim(Lines(Zhler)) & "##")
                                    Position = InStr(Position, Unbekannte_Befehle, "##") + 2
                                    Ende2 = InStr(Position, Unbekannte_Befehle, "||")
                                    Unbekannte_Befehle = Left(Unbekannte_Befehle, Position - 1) & Val(Mid(Unbekannte_Befehle, Position, Ende2 - Position)) + 1 & Right(Unbekannte_Befehle, Len(Unbekannte_Befehle) - Ende2 + 1)
                                End If
                            End If
                            
                            
                            
                    End Select
                    
                    If bBefehl = True Then
                        If bEnde = False Then
                            'Wenn kein gltiges Ende gefunden wird Fehlermeldung
                            MsgBox "Ende nicht gefunden Abbruch", vbCritical, "Ende nicht gefunden"
                            Me.MousePointer = vbArrow
                            Close #1
                            Exit Sub
                        Else
                            'Wenn gltiges Ende gefunden wird merken
                            Befehle_Anzahl(UBound(Befehle_Anzahl)).Befehl = Tempstring
                            Befehle_Anzahl(UBound(Befehle_Anzahl)).Start = Zhler
                            Befehle_Anzahl(UBound(Befehle_Anzahl)).Ende = Zhler2
                            ReDim Preserve Befehle_Anzahl(UBound(Befehle_Anzahl) + 1)
                        End If
                    End If
                End If
                
                DoEvents
                Zhler = Zhler + 1
            Wend
            
            
            If Chk_Auto_Offset.Value = 1 Then
                Auto_Offset_X = 9999999
                Auto_Offset_Y = 9999999
                Txt_Offset_X.Text = 0
                Txt_Offset_Y.Text = 0
                
                For Zhler = 0 To UBound(Befehle_Anzahl) - 1
                    
                    ProgressBar1.Value = (Zhler * 100 / UBound(Befehle_Anzahl))
                    
                    Select Case Befehle_Anzahl(Zhler).Befehl
                    
                        Case "LINE"
                            Call Auswertung_LINE(Zhler, True)
                        Case "ARC"
                            Call Auswertung_ARC(Zhler, True)
                        Case "CIRCLE"
                            Call Auswertung_CIRCLE(Zhler, True)
                        Case "POLYLINE"
                            Call Auswertung_POLYLINE(Zhler, True)
                        
                    End Select
                Next
                Txt_Offset_X.Text = Auto_Offset_X * -1
                Txt_Offset_Y.Text = Auto_Offset_Y * -1
            End If
            
            
            For Zhler = 0 To UBound(Befehle_Anzahl) - 1
                
                ProgressBar1.Value = (Zhler * 100 / UBound(Befehle_Anzahl))
                
                Select Case Befehle_Anzahl(Zhler).Befehl
                
                    Case "LINE"
                        Linien = Linien + 1
                        Call Auswertung_LINE(Zhler, False)
                    Case "ARC"
                        Halbkreise = Halbkreise + 1
                        Call Auswertung_ARC(Zhler, False)
                    Case "CIRCLE"
                        Kreise = Kreise + 1
                        Call Auswertung_CIRCLE(Zhler, False)
                    Case "POLYLINE"
                        Polyline = Polyline + 1
                        Call Auswertung_POLYLINE(Zhler, False)
                    
                End Select
            Next
            
            
            
            Dim Tempstring_Variant, Tempstring_Variant1 As Variant
            
            Tempstring_Variant = Split(Unbekannte_Befehle, "||")
            For Zhler = 1 To UBound(Tempstring_Variant) - 1
                Tempstring_Variant1 = Split(Tempstring_Variant(Zhler), "##")
                Text1.Text = Text1.Text & "Unbekannte Befehle: " & vbTab & Tempstring_Variant1(1) & "x" & vbTab & Tempstring_Variant1(0) & vbCrLf
            Next
            
            Text1.Text = Text1.Text & "==================================================================" & vbCrLf & vbCrLf
            Text1.Text = Text1.Text & "Anzahl Linien: " & Linien & vbTab & vbTab & " davon konvertiert: " & Conv_Linien & vbCrLf
            Text1.Text = Text1.Text & "Anzahl Kreise: " & Kreise & vbTab & vbTab & " davon konvertiert: " & Conv_Kreise & vbCrLf
            Text1.Text = Text1.Text & "Anzahl Halbkreise: " & Halbkreise & vbTab & " davon konvertiert: " & Conv_Halbkreise & vbCrLf
            Text1.Text = Text1.Text & "Anzahl Polyline: " & Polyline & vbTab & vbTab & " davon konvertiert: " & Conv_Polyline & vbCrLf
            
        Close #1
        Me.MousePointer = vbArrow
    End If
End Sub

Private Sub Chk_Auto_Offset_Click()
    If Chk_Auto_Offset.Value = 0 Then
        Txt_Offset_X.Text = "0"
        Txt_Offset_Y.Text = "0"
    End If
End Sub

Private Sub Form_Load()
    Me.Caption = Me.Caption & " - Version " & App.Major & "." & App.Revision & "." & App.Minor
End Sub

Private Sub Menue_Version_Click()
    MsgBox "Version " & App.Major & "." & App.Revision & "." & App.Minor, vbInformation, "Info"
End Sub

Private Sub Txt_Linienstrke_KeyPress(KeyAscii As Integer)
    If KeyAscii = 44 Then
        KeyAscii = 46
    End If
End Sub

Private Sub Auswertung_LINE(ByVal Befehl_Nummer As Long, ByVal Nur_Min_Max_Ermitteln As Boolean)
    
    Dim Zhler_For As Long

    If Chk_Line.Value = 0 Then Exit Sub
    
    For Zhler_For = Befehle_Anzahl(Befehl_Nummer).Start To Befehle_Anzahl(Befehl_Nummer).Ende
        Tempstring = Trim(Lines(Zhler_For))
            
        Select Case Tempstring
        
            Case "10"
                X1 = Replace(Lines(Zhler_For + 1), ".", ",") + Val(Replace(Txt_Offset_X.Text, ",", "."))
            Case "20"
                Y1 = Replace(Lines(Zhler_For + 1), ".", ",") + Val(Replace(Txt_Offset_Y.Text, ",", "."))
            Case "11"
                X2 = Replace(Lines(Zhler_For + 1), ".", ",") + Val(Replace(Txt_Offset_X.Text, ",", "."))
            Case "21"
                Y2 = Replace(Lines(Zhler_For + 1), ".", ",") + Val(Replace(Txt_Offset_Y.Text, ",", "."))
                If Nur_Min_Max_Ermitteln = False Then
                    Conv_Linien = Conv_Linien + 1
                    Tempstring = "Wire " & Txt_Linienstrke & " (" & Replace(X1, ",", ".") & " " & Replace(Y1, ",", ".") & ") (" & Replace(X2, ",", ".") & " " & Replace(Y2, ",", ".") & ")"
                    Print #1, Tempstring
                Else
                    If X1 < Auto_Offset_X Then Auto_Offset_X = X1
                    If Y1 < Auto_Offset_Y Then Auto_Offset_Y = Y1
                    If X2 < Auto_Offset_X Then Auto_Offset_X = X2
                    If Y2 < Auto_Offset_Y Then Auto_Offset_Y = Y2
                End If
        
        End Select
    Next
End Sub

Private Sub Auswertung_CIRCLE(ByVal Befehl_Nummer As Long, ByVal Nur_Min_Max_Ermitteln As Boolean)
    
    Dim Zhler_For As Long

    If Chk_Circle.Value = 0 Then Exit Sub
    
    For Zhler_For = Befehle_Anzahl(Befehl_Nummer).Start To Befehle_Anzahl(Befehl_Nummer).Ende
        Tempstring = Trim(Lines(Zhler_For))
            
        Select Case Tempstring
            Case "10"
                X1 = Replace(Lines(Zhler_For + 1), ".", ",") + Val(Replace(Txt_Offset_X.Text, ",", "."))
            Case "20"
                Y1 = Replace(Lines(Zhler_For + 1), ".", ",") + Val(Replace(Txt_Offset_Y.Text, ",", "."))
            Case "40"
                X2 = Replace(Lines(Zhler_For + 1), ".", ",")
                If Nur_Min_Max_Ermitteln = False Then
                    Conv_Kreise = Conv_Kreise + 1
                    Tempstring = "Circle " & Txt_Linienstrke & " (" & Replace(X1, ",", ".") & " " & Replace(Y1, ",", ".") & ") (" & Replace(X1, ",", ".") & " " & Replace(Y1 + X2, ",", ".") & ")"
                    Print #1, Tempstring
                Else
                    If X1 < Auto_Offset_X Then Auto_Offset_X = X1
                    If Y1 < Auto_Offset_Y Then Auto_Offset_Y = Y1
                End If
        
        End Select
    Next
End Sub


Private Sub Auswertung_ARC(ByVal Befehl_Nummer As Long, ByVal Nur_Min_Max_Ermitteln As Boolean)
    
    Dim Zhler_For As Long
    Dim X11, Y11, X22, Y22, X33, Y33 As Double

    If Chk_Arc.Value = 0 Then Exit Sub

    For Zhler_For = Befehle_Anzahl(Befehl_Nummer).Start To Befehle_Anzahl(Befehl_Nummer).Ende
        Tempstring = Trim(Lines(Zhler_For))
            
        Select Case Tempstring
            Case "10"
                X1 = Replace(Lines(Zhler_For + 1), ".", ",") + Val(Replace(Txt_Offset_X.Text, ",", "."))
            Case "20"
                Y1 = Replace(Lines(Zhler_For + 1), ".", ",") + Val(Replace(Txt_Offset_Y.Text, ",", "."))
            Case "40"
                X2 = Replace(Lines(Zhler_For + 1), ".", ",")
            Case "50"
                Y2 = Replace(Lines(Zhler_For + 1), ".", ",") * (3.141592654 / 180)
            Case "51"
                X3 = Replace(Lines(Zhler_For + 1), ".", ",") * (3.141592654 / 180)
                If Nur_Min_Max_Ermitteln = False Then
                    Conv_Halbkreise = Conv_Halbkreise + 1
                    X11 = X2 * Cos(Y2) + X1
                    Y11 = X2 * Sin(Y2) + Y1
                    X22 = X1 - (2 * X2 * Cos(Y2))
                    Y22 = Y1 - (2 * X2 * Sin(Y2))
                    X33 = X2 * Cos(X3) + X1
                    Y33 = X2 * Sin(X3) + Y1
                    Tempstring = "wire " & Txt_Linienstrke & " (" & Replace(X11, ",", ".") & " " & Replace(Y11, ",", ".") & ") @+" & Replace(X2, ",", ".") & " (" & Replace(X33, ",", ".") & " " & Replace(Y33, ",", ".") & ")"
                    Print #1, Tempstring
                Else
                    If X11 < Auto_Offset_X Then Auto_Offset_X = X11
                    If Y11 < Auto_Offset_Y Then Auto_Offset_Y = Y11
                End If
        
        End Select
    Next
End Sub

Private Sub Auswertung_POLYLINE(ByVal Befehl_Nummer As Long, ByVal Nur_Min_Max_Ermitteln As Boolean)
    
    Dim Zhler_For As Long

    If Chk_Polyline.Value = 0 Then Exit Sub
    
    bPolyline_Gltig = False
    While Befehle_Anzahl(Befehl_Nummer).Befehl <> "SEQEND"
            
        'Suchen nach Vertex
        If Befehle_Anzahl(Befehl_Nummer).Befehl = "VERTEX" Then
            For Zhler_For = Befehle_Anzahl(Befehl_Nummer).Start To Befehle_Anzahl(Befehl_Nummer).Ende
                Tempstring = Trim(Lines(Zhler_For))
                    
                Select Case Tempstring
                    Case "10"
                        X2 = X1
                        X1 = Replace(Lines(Zhler_For + 1), ".", ",") + Val(Replace(Txt_Offset_X.Text, ",", "."))
                    Case "20"
                        Y2 = Y1
                        Y1 = Replace(Lines(Zhler_For + 1), ".", ",") + Val(Replace(Txt_Offset_Y.Text, ",", "."))
                    Case "30"
                        If Nur_Min_Max_Ermitteln = False Then
                            If bPolyline_Gltig = True Then
                                Tempstring = "Wire " & Txt_Linienstrke & " (" & Replace(X1, ",", ".") & " " & Replace(Y1, ",", ".") & ") (" & Replace(X2, ",", ".") & " " & Replace(Y2, ",", ".") & ")"
                                Print #1, Tempstring
                            Else
                                bPolyline_Gltig = True
                                Conv_Polyline = Conv_Polyline + 1
                            End If
                        Else
                            If X1 < Auto_Offset_X Then Auto_Offset_X = X1
                            If Y1 < Auto_Offset_Y Then Auto_Offset_Y = Y1
                        End If
                
                End Select
            Next
        End If
    Befehl_Nummer = Befehl_Nummer + 1
    Wend
    
End Sub


