/* c't Mikrocontroller-im-LAN Demo Source
 * Datei: mcu.c 
 * Info: Demo-Hauptprogramm
 * Autor: Benjamin Benz (bbe@heise.de)
 * Datum: 24.06.04
*/

#include <avr/io.h>
#include <avr/interrupt.h>
#include <avr/signal.h>

#include "uart.h"
#include "tools.h"

#define CMD_LENGTH 64
#define CMD_STARTCODE 0x7f
#define CMD_STOPCODE 0x7e

#define DEST_XPORT 0
#define DEST_COM 1
#define DEST_PASSTHROUGH 2

#define SWITCH_DEST 	0x50

//char command[CMD_LENGTH];		// Puffer fr Kommando von/an PC

volatile unsigned char data;

SIGNAL(SIG_UART_RECV){
	data = UDR;
	USART_send(UDR);
} 

//Der Mikrocontroller braucht ein paar Einstellungen, bevor wir loslegen knnen.
void init(void){
	DDRB= 0x07;  // Multiplexleitungen seriell PB0-2 als Ausgang
	
	PORTB= 0x03; // UART verbinden mit COM

	DDRA=0x10; // Piepserport PA4 auf Ausgang
	
	TCCR1A=0x00; // Timer 1 auf Normalbetrieb
	
	TCCR1B=5; // Clksoure = Quarz / 1024
	
	TCNT1H=0 ;// Timer auf 0 setzen
	TCNT1L=0 ;
	
	USART_init ();
	
	sei ();
	
	beep();
}

int main (void){
	
	init();
	
	USART_dest(DEST_XPORT);

	while(1) {	// Main Loop
	}
	
	return 0;
}