//***************************************************************************************
//***
//***	Projectname:	Control Interface	
//***	Filename:		ASCInterface.h
//***	Shortcut:		ASC
//***	Author:			Ralf Hochhausen
//***	Date:			20.10.2003
//***	Acual Version:	V1.0 (Initial Version)
//***	
//***	Description:	Hardware dirver for the asynchronous interface of the mega 128	
//***
//***	File-History:	20.10.2003
//***					V1.0	Initial Version
//***
//***************************************************************************************

#ifndef __ASC_H

#define __ASC_H

//***************************************************************************************
//***
//***	Function:		void ASC_vHandleTask(void)
//***	
//***	Return Type:	void
//***
//***	Parameters:		none
//***	
//***	Checks if date has to be send. If yes, the hardware buffer is checked. If it
//***	is empty, the next data byte is written into the hardware buffer.
//***	After this, the transmit buffer read index is set to the next read position
//***
//***************************************************************************************
void ASC_vHandleTask(void);

//***************************************************************************************
//***
//***	Function:		uchar ASC_vGetReceivedByte(void)
//***	
//***	Return Type:	Received data byte out of the ring buffer
//***
//***	Parameters:		none
//***	
//***	Returns the first received data byte out of the ring buffer. If the buffer
//***	has been full, the flags are cleared
//***
//***************************************************************************************
uchar ASC_ucGetReceivedByte(void);

//***************************************************************************************
//***
//***	Function:		uchar ASC_vTransmitByte(uchar *ucData_)
//***	
//***	Return Type:	TRUE, if data can be transmitted (data has been written
//***					into buffer), else FALSE
//***
//***	Parameters:		uchar *ucData_:	Pointer on the data byte that has to be transmitted
//***	
//***	Writes one data byte into the transmit buffer. If buffer is full or overrun
//***	has occured, status flags are set
//***
//***************************************************************************************
uchar ASC_vTransmitByte(uchar ucData_);

//***************************************************************************************
//***
//***	Function:		uchar ASC_ucIsTransmitBufferFree(void)
//***	
//***	Return Type:	TRUE: Buffer is free; FALSE: buffer is full
//***
//***	Parameters:		none
//***	
//***	returns TRUE if at least one byte is free in transmit buffer, else false
//***
//***************************************************************************************
uchar ASC_ucIsTransmitBufferFree(void);

//***************************************************************************************
//***
//***	Function:		uchar ASC_ucIsByteReceived(void)
//***	
//***	Return Type:	TRUE: Data is in buffer; FALSE: buffer is empty
//***
//***	Parameters:		none
//***	
//***	returns TRUE if at least one byte in receive buffer, else false
//***
//***************************************************************************************
uchar ASC_ucIsByteReceived(void);

//***************************************************************************************
//***
//***	Function:		void ASC_vInit(void)
//***	
//***	Return Type:	void
//***
//***	Parameters:		none
//***	
//***	Initialization of the asynchronous interface (hardware driver for the atmega128)
//***	Initialization of the transmit and receive buffer
//***	
//***	Parameters for the asynchronous interface:
//***	Baudrate:		9600
//***	Databits:		8
//***	Stopbits:		1
//***	Parity:			no
//***
//***************************************************************************************
void ASC_vInit(void);

#endif
