//***************************************************************************************
//***
//***	Projectname:	Compact Flash Interface
//***	Filename:		CF_Card_IF.c
//***	Shortcut:		CFC
//***	Author:			Ralf Hochhausen
//***	Date:			06.12.2003
//***	Acual Version:	V1.0 (Initial Version)
//***	
//***	Description:	Memory Interface to a compact flash card.
//***					Compact flash card is used in memory mapped mode
//***					Registers are located at 0xE000 in external RAM space of Mega128
//***
//***	File-History:	06.12.2003
//***					V1.0	Initial Version
//***					Identify drive and read sector functions are implemented.
//***					Writing data to the card isn't possible yet.
//***
//***************************************************************************************

#ifndef __CFC_H

#define __CFC_H

//***************************************************************************************
//***
//***	Global Types
//***
//***************************************************************************************
typedef union
{
	ulong	longbyte;
	uchar	byte[4];
}lba_address;

//***************************************************************************************
//***
//***	Global Functions
//***
//***************************************************************************************

//***************************************************************************************
//***
//***	Function:		void CFC_vReadSector(lba_address lbaSectorAddress, uchar* pucBuffer)
//***	
//***	Return Type:	void
//***
//***	Parameters:		lba_address lbaSectorAddress:		Address of the Sector that has
//***														to be read
//***					uchar* pucBuffer:					Pointer to the memory location,
//***														where the data has to be stored			
//***	
//***	Function to read one sector of the compact flash card
//***
//***************************************************************************************
void CFC_vReadSector(lba_address lbaSectorAddress_, uchar* pucBuffer_);
void CFC_vIdentifyDrive(uchar* pucBuffer_);
void CFC_vInit(void);

#endif
