//***************************************************************************************
//***
//***	Projectname:	Control Interface
//***	Filename:		IO.c
//***	Shortcut:		IO
//***	Author:			Ralf Hochhausen
//***	Date:			22.10.2003
//***	Acual Version:	V1.0 (Initial Version)
//***	
//***	Description:	Basic initialization of the IO Ports. Every port using module 
//***					has to initialize its used ports by itself
//***
//***	File-History:	22.10.2003
//***					V1.0	Initial Version
//***
//***************************************************************************************

//***************************************************************************************
//***
//***	Includes
//***
//***************************************************************************************
#include <avr\io.h>
#include "IOPorts.h"

//***************************************************************************************
//***
//***	Function:		void IO_vInit(void)
//***	
//***	Return Type:	void
//***
//***	Parameters:		none
//***	
//***	Basic initialization of the IO Ports. Every port using module has to initialize
//***	its used ports by itself
//***
//***************************************************************************************
void IO_vInit(void)
{
	//Initialize Port A as input (tristate) 
	DDRA  = 0x00;
	PORTA = 0xFF;

	//Initialize Port B as input (tristate)
	DDRB  = 0x00;
	PORTB = 0x00;

	//Initialize Port C as input (tristate)
	DDRC  = 0x00;
	PORTC = 0x00;
	
	//Initialize Port D as input (tristate)
	DDRD  = 0x00;
	PORTD = 0x00;

	//Initialize Port E as input (tristate)
	DDRE  = 0x00;
	PORTE = 0x00;

	//Initialize Port F as input (tristate)
	DDRF  = 0x00;
	PORTF = 0x00;

	//Initialize Port G as input (tristate) PORTG0..PORTG4
	DDRG  = 0x00;
	PORTG = 0x07;

}
