//***************************************************************************************
//***
//***	Projectname:	Control Interface	
//***	Filename:		Main.c
//***	Shortcut:		ASC
//***	Author:			Ralf Hochhausen
//***	Date:			20.10.2003
//***	Acual Version:	V1.0 (Initial Version)
//***	
//***	Description:	Main program with main loop	
//***
//***	File-History:	20.10.2003
//***					V1.0	Initial Version
//***
//***************************************************************************************

//***************************************************************************************
//***
//***	Includes
//***
//***************************************************************************************
#include <avr\ina90.h>
#include "Types.h"
#include "IOPorts.h"
#include "System.h"
#include "ASCInterface.h"
#include "CF_Card_IF.h"
#include "C_Interf.h"


//***************************************************************************************
//***
//***	Function:		void vInitProject(void)
//***	
//***	Return Type:	void
//***
//***	Parameters:		none
//***	
//***	Initialization of the project. Function calls all module initializers
//***
//***************************************************************************************
void vInitProject(void)
{
	IO_vInit();
	SYS_vInit();			//Init time control
	ASC_vInit();			//Init asynchronous interface
	CFC_vInit();			//Init compact flash card
//	CIF_vInit();			//init control interface

	_SEI();
}

//***************************************************************************************
//***
//***	Main function
//***
//***************************************************************************************
int main(void)
{
	vInitProject();
	while(1)
	{
		SYS_vHandleTask();
		ASC_vHandleTask();
//		CIF_vHandleTask();
	}
	return 0;
}
