#include <msp430x14x.h>
#include "pwm.h"
#include "types.h"

void initClock()
{
  uint8_t i;
  
  /* 8MHz - Oszillator */
  BCSCTL1 |= XTS;                   /* Auf externen Oszillator mit 8MHz umschalten ...              */
  for(IFG1 &= ~OFIFG; (IFG1 & OFIFG); IFG1 &= ~OFIFG)/* Schleife erst verlassen, wenn eingeschwungen*/
  {
    for (i=0; i<255; i++);          /* ... Zeit geben fr den Einschwingvorgang  ...                */
  }
  BCSCTL2 |= SELM_3;                /* Dann Haupttakt auf den externen Oszillator mit 8Mhz schalten */
}



int main()
{
  uint16_t i;
  
  initClock();
  initPWM();

  _EINT();                          /* Interrupts freigeben. BEI GCC: "eint()" verwenden            */
  TACTL   |= MC_1;                  /* TA starten, hochzhlen bis CCR0                              */
  
  i = 0;
  
  for(;;)
  {
        if(semaphoreCCR0 == TRUE)   /* semaphoreCCR0 wird in der SISR Timer_A0 gesetzt              */
        {
          semaphoreCCR0 = FALSE;        /* Semaphore ("Vertndigungssignal") wieder rcksetzen          */
      //    if ( i <= 0xffff)
      //    {
              writePWM(0xff);
      //    }
      //    i++;
        }
  }
  
  return 0;
}
