#include <msp430x14x.h>
#include "types.h"
#include "pwm.h"

static uint16_t PWM_Ton;           /* ABSOLUTE EINSCHALTZEIT Ton fr CCR1                          */

void initPWM()
{
  /* Ports */
  P1SEL   |= 0x04;                  /* P1.2 auf TimerA (CCR1) umschalten                            */
  P1DIR   |= 0x04;                  /* P1.2 auf Ausgang setzen                                      */
  P1OUT   &=~0x04;                  /* P1.2 auf 0 setzen (Durch Lschen von bit2)                   */
  
  /* TimerA, CCR0 und CCR1 konfigurieren */
  CCTL0   = OUTMOD_4 + CCIE;        /* CCU0: CCIE: Perioden-Interrupt einschalten                   */
  CCR0    = PWM_PERIOD;             /* CCU1: Tpwm=8000 in CCR0 bertragen, mehr ist nicht ntig     */

  CCTL1   = OUTMOD_7;               /* CCU1: reset/set, wie oben beschrieben                        */
  CCR1    = 0;                      /* CCU1: Compare-Wert zu Anfang 0 setzen (Spannung komplett aus)*/

  TACTL   = TASSEL_1;               /* TimerA wird von der SMCLK gespeist, welche mit 8Mhz luft    */
  
  /* variable initialisieren */
  PWM_Ton        = 0;
}

void writePWM(uint16_t period)
{
  PWM_Ton = (uint16_t) (PWMd * period); /* [0..1] * 8000 rechnen und in Ganzzahl wandeln     */
}


#pragma vector=TIMERA0_VECTOR
__interrupt void Timer_A0 (void) {  /* Perioden-Interrupt, Bei GCC "SIGNAL(...)" - Anweisung        */
   _DINT();                         /* GCC: dint(); bei SIGNAL() nicht bentigt                     */
    
  CCR1 = PWM_Ton;
    
   _EINT();                         /* GCC: eint(); bei SIGNAL() nicht bentigt                     */
}

