/*------------------------------------------------------------------------------
 Copyright:      Radig Ulrich  mailto: mail@ulrichradig.de
 Author:         Radig Ulrich
 Remarks:        
 known Problems: none
 Version:        03.12.2008
 Description:    Commando Interpreter fr AVR_DSO
 gendert:       Gerd B.
 Version:        28.06.2010

 Dieses Programm ist freie Software. Sie knnen es unter den Bedingungen der 
 GNU General Public License, wie von der Free Software Foundation verffentlicht, 
 weitergeben und/oder modifizieren, entweder gem Version 2 der Lizenz oder 
 (nach Ihrer Option) jeder spteren Version. 

 Die Verffentlichung dieses Programms erfolgt in der Hoffnung, 
 da es Ihnen von Nutzen sein wird, aber OHNE IRGENDEINE GARANTIE, 
 sogar ohne die implizite Garantie der MARKTREIFE oder der VERWENDBARKEIT 
 FR EINEN BESTIMMTEN ZWECK. Details finden Sie in der GNU General Public License. 

 Sie sollten eine Kopie der GNU General Public License zusammen mit diesem 
 Programm erhalten haben. 
 Falls nicht, schreiben Sie an die Free Software Foundation, 
 Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA. 
------------------------------------------------------------------------------*/

#include "cmd.h"

volatile unsigned int variable[MAX_VAR];

unsigned char	trigger_level = 128;
unsigned char	trigger_typ = 1;
unsigned int	loop = 0;
volatile unsigned char	d_trigger = 0;
unsigned char	trigger_prev = 0;
unsigned char	sync_plus = 0;
unsigned char	sync = 0;
volatile unsigned char	exec_get = 0;
unsigned char	hold = 0;
unsigned char	tmp_hold = 0;
unsigned char	get_hold_ram = 0;
volatile unsigned char  trigger_top_ram = 0;
unsigned char	acc_delay = 0;
unsigned int	fft = 512;

COMMAND_STRUCTUR COMMAND_TABELLE[] = // Befehls-Tabelle
{
    {"GET",command_get_data},
	{"RESET",command_reset},
    {"AC",command_set_ac},
    {"DC",command_set_dc},
    {"OFFSET",command_offset},
    {"TRIGFH",command_trigger_f_high},
    {"TRIGFL",command_trigger_f_low},
    {"TRIGOFF",command_trigger_level},
	{"TRTRAM",command_trigger_top_ram},
	{"TRRAM",command_trigger_ram},
    {"DIV",command_div},
    {"TRIGDEL",command_trigger_delay},
	{"TRDEL",command_set_delay},
	{"TRPREV",command_set_prev},
	{"SYNCP",command_set_syncp},
	{"NSYNCP",command_clear_syncp},
	{"HOLD",command_set_hold},
	{"NHOLD",command_clear_hold},
	{"HOLDRAM",command_get_hold_ram},
	{"ACC",command_accelerate},
	{"FFT",command_set_fft},
	{NULL,NULL} 
};

//------------------------------------------------------------------------------
//Commando auswerten
unsigned char extract_cmd (char *string_pointer)
{
	//Stringzeiger;
	char *string_pointer_tmp;
	unsigned char cmd_index = 0;
 
    string_pointer_tmp = strsep(&string_pointer," "); 

	//Kommando in Tabelle suchen
	while(strcasecmp(COMMAND_TABELLE[cmd_index].cmd,string_pointer_tmp))
    {
        //Abruch Whileschleife und Unterprogramm verlassen 
        if (COMMAND_TABELLE[++cmd_index].cmd == 0) return(0);
    }
    
    //Variablen finden und auswerten
	for (unsigned char a = 0; a<MAX_VAR;a++)
	{ 
        string_pointer_tmp = strsep(&string_pointer,"., ");  
		variable[a] = strtol(string_pointer_tmp,NULL,0);
	}

    //Kommando ausfhren
	COMMAND_TABELLE[cmd_index].fp();
	return(1); 
}

//------------------------------------------------------------------------------
//Reset ausfhren
void command_reset (void)
{
	RESET();
}

//------------------------------------------------------------------------------
//Eingang umschalten auf DC
void command_set_dc (void)
{
	PORTB |= (1<<PB1);
}

//------------------------------------------------------------------------------
//Eingang umschalten auf AC
void command_set_ac (void)
{
	PORTB &= ~(1<<PB1);
}

//------------------------------------------------------------------------------
//
void command_offset (void)
{
	OCR2 = variable[0];
}

//------------------------------------------------------------------------------
//
void command_div (void)
{
      switch (variable[0])
      {
        case (0):
            //Scope Time Div CPLD CLK/0
            PORTC &= ~(1<<DIV0);
            PORTC &= ~(1<<DIV1);
            break;
    
        case (1):
            //Scope Time Div CPLD CLK/2/32/256
            PORTC |= (1<<DIV0);
            PORTC &= ~(1<<DIV1);
            break;
    
        case (2):
            //Scope Time Div CPLD CLK/2/32/256
            PORTC |= (1<<DIV1);
            PORTC &= ~(1<<DIV0);
            break;
          
        case (3):
            //Scope Time Div CPLD CLK/2/32/256
            PORTC |= (1<<DIV0);
            PORTC |= (1<<DIV1);
            break;
      }
      
      loop = variable[1];
}

//------------------------------------------------------------------------------
//
void command_trigger_f_high (void)
{
	trigger_typ = 1;
}
//------------------------------------------------------------------------------
//
void command_trigger_f_low (void)
{
	trigger_typ = 0;
}
//------------------------------------------------------------------------------
//
void command_trigger_level (void)
{
	trigger_level = variable[0];
}
//------------------------------------------------------------------------------
//
void command_trigger_delay (void)
{
	d_trigger = variable[0];
}
//------------------------------------------------------------------------------
//
void command_set_delay (void)
{
	trigger_prev = 0;
}

//------------------------------------------------------------------------------
//
void command_set_prev (void)
{
	trigger_prev = 1;
}
  
//------------------------------------------------------------------------------
//
void command_trigger_top_ram (void)
{
	trigger_top_ram = 1;
}
	//------------------------------------------------------------------------------
//
void command_trigger_ram (void)
{
	trigger_top_ram = 0;
}
//------------------------------------------------------------------------------
//
void command_set_syncp (void)
{
	sync_plus = 1;
}
//------------------------------------------------------------------------------
//
void command_clear_syncp (void)
{
	sync_plus = 0;
}
//------------------------------------------------------------------------------
//
void command_get_data (void)
{
	exec_get = 1;
}
//------------------------------------------------------------------------------
//
void command_set_hold (void)
{
	tmp_hold = 1;
}
//------------------------------------------------------------------------------
//
void command_clear_hold (void)
{
	tmp_hold = 0;
}
//------------------------------------------------------------------------------
//
void command_get_hold_ram (void)
{
	get_hold_ram = 1;
}
//------------------------------------------------------------------------------
//
	void command_accelerate (void)
{
	acc_delay = variable[0];
}
//------------------------------------------------------------------------------
//
	void command_set_fft (void)
{
	fft = 512 << variable[0]; // 512 * 2 exp x
}
//------------------------------------------------------------------------------
//
void send_Data_no_loop(unsigned int end)
{
	unsigned char tmp;
	
	for(unsigned int a=0; a < end - 1;a++)
	{  
		//RAM Adresscounter +1
		PORTC |= (1<<CLK); //Clock Adresscounter +1 (High)
		asm("nop");
		tmp = PINA;
		usart_write_byte(tmp);
		PORTC &= ~(1<<CLK);//Clock Adresscounter (LOW)			
	}
}

void send_Data (unsigned int trigger_point)
{
    unsigned char tmp;
	unsigned char loop_tmp;
	
	//Daten zum PC bertragen	
	usart_write_char(0); // zur Fehlersuche ob Datenbertragung synchron zur Datendarstellung
	if (hold)
	{
		usart_write_byte(0xff); // ==> Win-Prg. Datenstream hold erkannt 
		usart_write_byte(0);
	}
	else 
	{
		usart_write_byte(0);
		usart_write_byte(0xff);
		if (!sync) trigger_point = 0;
    }
	usart_write_byte(0xf0);
	// Triggerpunkt senden
	tmp = (trigger_point) & 0xff; // lsb
	usart_write_byte(tmp);
	tmp = (trigger_point) >> 8;   // msb
	usart_write_byte(tmp);
	
	if (fft <= 512)
	{
		for(unsigned int a=0; a < 650 ;a++)
		{  
			//RAM Adresscounter +1
			PORTC |= (1<<CLK); //Clock Adresscounter +1 (High)
			asm("nop");
			tmp = PINA;
			usart_write_byte(tmp);
			PORTC &= ~(1<<CLK);//Clock Adresscounter (LOW)
			loop_tmp = loop;  
			while(loop_tmp--)
			{
				PORTC |= (1<<CLK); //Clock Adresscounter +1 (High)
				PORTC &= ~(1<<CLK);//Clock Adresscounter (LOW)
			}
		}
	}
	else
		send_Data_no_loop(fft);
	PORTD &= ~(1<<PD2);		 //2. Led off
}

void get_data (void)
{
	unsigned int trigger_counter;
	unsigned int a;
    unsigned char tmp;
	unsigned char sync_1;
	unsigned int tmp_d_trigger;
 	unsigned int trigger_delay;
  	unsigned int trigger_point;
	
	exec_get = 0;
	sync = 0;
	sync_1 = 0;
	trigger_point = 0;
	if ((trigger_prev) && (d_trigger != 0))
	{
		//Platz fr Vortriggerung berspringen
		tmp_d_trigger = (loop+1)*d_trigger;
		trigger_point = tmp_d_trigger;
		for(trigger_counter = 0; trigger_counter < tmp_d_trigger;trigger_counter++)
		{  
			//RAM Adresscounter +1
			PORTC |= (1<<CLK); //Clock Adresscounter +1 (High)
			PORTC &= ~(1<<CLK);//Clock Adresscounter (LOW)
		}
	} 
		
	//Trigger-Level finden
	for(trigger_counter = 0; trigger_counter < TRIGGER_BEREICH;trigger_counter++)
	{  
		//RAM Adresscounter +1
		PORTC |= (1<<CLK); //Clock Adresscounter +1 (High)
		asm("nop");
		tmp = PINA;
		PORTC &= ~(1<<CLK);//Clock Adresscounter (LOW)
		if (trigger_typ)
		{
		if (tmp < (trigger_level - 5)) //positive Flanke ermitteln
			{		
				sync_1 = 1;
				break;
			}
		}
		else
		{
			if (tmp > (trigger_level + 5)) //negative Flanke ermitteln
			{
				sync_1 = 1;
				break;
			}
		}
	}
		
	tmp_d_trigger = 2 * TRIGGER_BEREICH - trigger_counter;
	for(a = 0; a < tmp_d_trigger;a++)
	{  
		//RAM Adresscounter +1
		PORTC |= (1<<CLK); //Clock Adresscounter +1 (High)
		asm("nop");
		tmp = PINA;
		PORTC &= ~(1<<CLK);//Clock Adresscounter (LOW)
		if (trigger_typ)
		{   //Bedingung fr Triggerung erfolgt (tmp < (trigger_level -5) und (tmp >= trigger_level)
			if ((tmp >= trigger_level) && (sync_1)) //positive Flanke
			{
				PORTD |= (1<<PD2);			 //2. Led on
				sync = 1;
				break;
			}
		}
		else
		{   //Bedingung fr Triggerung erfolgt (tmp < (trigger_level -5) und (tmp >= trigger_level)
			if ((tmp <= trigger_level) && (sync_1))
			{
				PORTD |= (1<<PD2);			 //2. Led on
				sync = 1;
				break;
			}
		}
	}
		
	exec_get = 0;
	while((sync)&&(!exec_get));
	
	// Triggerverzgerung bercksichtigen
	if ((trigger_prev) && (d_trigger != 0)) 
	{
		trigger_delay = a + trigger_counter;
		PORTC |= (1<<RES);          //Reset des CPLD Adresscounters
		PORTC &= ~(1<<RES);
	}
	else
	{
		trigger_delay = (loop+1)*d_trigger;
	}
	
	while(trigger_delay--)
	{
		PORTC |= (1<<CLK); //Clock Adresscounter +1 (High)
		PORTC &= ~(1<<CLK);//Clock Adresscounter (LOW)
	}
		
	if (!(sync_plus) || ((sync_plus) && (sync)))
	{
		hold = tmp_hold;
		if (hold) trigger_point = a + trigger_counter;
		send_Data(trigger_point);
	}
}

void is_hold(void)
{
	while(hold)
	{
		if (get_hold_ram)
		{
			PORTC |= (1<<RES);   //Reset des CPLD Adresscounters
			PORTC &= ~(1<<RES);
			usart_write_char(0); 	// header 00 255 254
			usart_write_byte(0xff);
			usart_write_byte(0xfe);
			usart_write_byte(0xf0);
			for(unsigned int a=0; a < 2; a++) usart_write_byte(0); // TP - Lnge header Datenstream sollte berall gleich sein
			send_Data_no_loop(RAM_SIZE);
			get_hold_ram = 0;
		}
	hold = tmp_hold;
	}
 }
 
  void top_ram(void)
 {
	unsigned char tr_level;
	unsigned char next;
	
	exec_get = 0;
	next = 1;
	if (trigger_typ)
	{
		tr_level = trigger_level - 5;
		PORTC |= (1<<RES);          //Reset des CPLD Adresscounters
		PORTC &= ~(1<<RES);          
		PORTC |= (1<<RUN);          //Beschreiben des RAMs mit AD Werten
		while ((trigger_top_ram)&&(PINC & (1<<STO)))		 //positive Flanke ermitteln
		{
			if (next == 1)
			{
				while ((PINC & (1<<STO))&&((PINA < 25) || (PINA > tr_level)));//Unsauber, hier fehlt ein Latch
				if ((PINA > 25)&&(PINA < tr_level)) next = 0;
			}
			else
			{	
				if (PINA >= trigger_level)
				{
					PORTC |= (1<<RES);          //Reset des CPLD Adresscounters
					PORTC &= ~(1<<RES);
					hold = tmp_hold;
					PORTD |= (1<<PD2);			 //2. Led on
					break;
				}
			}
		}
	}
	else
	{
		tr_level = trigger_level + 5;
		PORTC |= (1<<RES);          //Reset des CPLD Adresscounters
		PORTC &= ~(1<<RES);          
		PORTC |= (1<<RUN);          //Beschreiben des RAMs mit AD Werten
		while ((trigger_top_ram)&&(PINC & (1<<STO)))	 //negative Flanke ermitteln
		{
			if (next == 1)
			{
				if (PINA > tr_level)
				{
					next = 0;
				}
			}
			else
			{	
				while ((PINC & (1<<STO))&&((PINA < 25) || (PINA > tr_level)));//Unsauber, hier fehlt ein Latch
				if ((PINA > 25)&&(PINA <= trigger_level))
				{
					PORTC |= (1<<RES);          //Reset des CPLD Adresscounters
					PORTC &= ~(1<<RES); 
					hold = tmp_hold;
					PORTD |= (1<<PD2);			 //2. Led on
					break;
				}
			}
		}
	}
	
	if (acc_delay == 0)
	{
		while (PINC & (1<<STO));    //Letzte Speicheradresse erreicht
		PORTC &= ~(1<<RUN);
	}
	else
	{
		_delay_ms(acc_delay); //reine Zeitschleife, da asynchroner Lauf - delay_us(double us) acc_delay
		PORTC &= ~(1<<RUN);
		PORTC |= (1<<RES);          //Reset des CPLD Adresscounters
		PORTC &= ~(1<<RES);
	}
	while (!exec_get);
	send_Data(0);
}
