/*------------------------------------------------------------------------------
 Copyright:      Radig Ulrich  mailto: mail@ulrichradig.de
 Author:         Radig Ulrich
 Remarks:        
 known Problems: none
 Version:        03.12.2008
 Description:    Commando Interpreter
 gendert:       Gerd B.
 Version:        23.05.2010

 Dieses Programm ist freie Software. Sie knnen es unter den Bedingungen der 
 GNU General Public License, wie von der Free Software Foundation verffentlicht, 
 weitergeben und/oder modifizieren, entweder gem Version 2 der Lizenz oder 
 (nach Ihrer Option) jeder spteren Version. 

 Die Verffentlichung dieses Programms erfolgt in der Hoffnung, 
 da es Ihnen von Nutzen sein wird, aber OHNE IRGENDEINE GARANTIE, 
 sogar ohne die implizite Garantie der MARKTREIFE oder der VERWENDBARKEIT 
 FR EINEN BESTIMMTEN ZWECK. Details finden Sie in der GNU General Public License. 

 Sie sollten eine Kopie der GNU General Public License zusammen mit diesem 
 Programm erhalten haben. 
 Falls nicht, schreiben Sie an die Free Software Foundation, 
 Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA. 
------------------------------------------------------------------------------*/

#ifndef _CMD_H_
	#define _CMD_H_	
		
	#include <avr/io.h>
	#include "usart.h"
	#include <util/delay.h>
	#define TRIGGER_BEREICH 8000
	#define RAM_SIZE 32768
	
	void get_data (void);
	void is_hold(void);
	void top_ram(void);

	typedef struct
	{
		char* cmd; 				        // Stringzeiger auf Befehlsnamen
		void(*fp)(void);  	// Zeiger auf auszufhrende Funktion
	} COMMAND_STRUCTUR;	
	
 	unsigned char  trigger_level;
    unsigned char  trigger_typ;
    unsigned int   loop;
	volatile unsigned char  d_trigger;
	unsigned char  trigger_prev;
	unsigned char  sync_plus;
	unsigned char  sync;
	volatile unsigned char  exec_get;
	unsigned char  hold;
	unsigned char  tmp_hold;
	unsigned char  get_hold_ram;
    volatile unsigned char  trigger_top_ram;
	unsigned char	acc_delay;
	unsigned int  	fft;

    #define MAX_VAR	10
    volatile unsigned int variable[MAX_VAR];
	
    #define RES PC7
    #define RUN PC6
    #define STO PC5
    #define CLK PC4
    #define DIV0 PC3
    #define DIV1 PC2
    
    //Kommando Interpreter
	extern unsigned char extract_cmd    (char *);
  
	//reset the unit
	extern void command_reset		    (void);
	extern void command_set_ac 		    (void);
    extern void command_set_dc 		    (void);
    extern void command_offset 		    (void);
    extern void command_get_data 	    (void);
	extern void command_set_hold	    (void);
	extern void command_clear_hold	    (void);
	extern void command_get_hold_ram	(void);
    extern void command_accelerate		(void);
	extern void command_set_fft			(void);

    extern void command_trigger_f_high 	(void);
    extern void command_trigger_f_low 	(void);
    extern void command_trigger_level 	(void);
    extern void command_trigger_top_ram	(void);
	extern void command_trigger_ram		(void);

    extern void command_div             (void);
	extern void command_trigger_delay	(void);
	extern void command_set_delay		(void);
	extern void command_set_prev		(void);
	
	extern void command_set_syncp		(void);
	extern void command_clear_syncp		(void);


	#define RESET() {asm("ldi r30,0"); asm("ldi r31,0"); asm("ijmp");}
	unsigned char extract_cmd (char *string_pointer);
		
#endif //_CMD_H_


