/*----------------------------------------------------------------------------
 Copyright:      Radig Ulrich  mailto: mail@ulrichradig.de
 Author:         Radig Ulrich
 Remarks:        
 known Problems: none
 Version:        17.10.2008
 Description:    MyScope
 gendert:       Gerd B.
 Version:        10.06.2010

 Dieses Programm ist freie Software. Sie knnen es unter den Bedingungen der 
 GNU General Public License, wie von der Free Software Foundation verffentlicht, 
 weitergeben und/oder modifizieren, entweder gem Version 2 der Lizenz oder 
 (nach Ihrer Option) jeder spteren Version. 

 Die Verffentlichung dieses Programms erfolgt in der Hoffnung, 
 da es Ihnen von Nutzen sein wird, aber OHNE IRGENDEINE GARANTIE, 
 sogar ohne die implizite Garantie der MARKTREIFE oder der VERWENDBARKEIT 
 FR EINEN BESTIMMTEN ZWECK. Details finden Sie in der GNU General Public License. 

 Sie sollten eine Kopie der GNU General Public License zusammen mit diesem 
 Programm erhalten haben. 
 Falls nicht, schreiben Sie an die Free Software Foundation, 
 Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA. 
----------------------------------------------------------------------------*/

#include <avr/io.h>
#include "config.h"
#include "usart.h"
#include "cmd.h"

//----------------------------------------------------------------------------
//Hier startet das Hauptprogramm
int main (void)
{    
    usart_init(BAUDRATE);
    usart_write("MYSCOPE compiliert am "__DATE__" um "__TIME__"\r\n");
    usart_write("Compiliert mit GCC Version "__VERSION__"\r\n");
    
    sei();

    DDRB |= (1<<PB0)|(1<<PB1);
	DDRD |= (1<<PD2);  // Direction 2. Led
    
    //Power Led On
    PORTB |= (1<<PB0);

    //AC/DC Messung (1=DC)
    PORTB |= (1<<PB1);
    
    DDRA = 0x00;	
    DDRC = (1<<RES)|(1<<RUN)|(1<<CLK)|(1<<DIV0)|(1<<DIV1); 
    PORTC = 0x00;  

    //Set TIMER2 (PWM OC2 Pin) Scope Offset Spannung erzeugen
	DDRD |= (1<<7);
	TCCR2 |= (1<<WGM21|1<<WGM20|1<<COM21|1<<CS20);
	OCR2 = 128;
	
    while(1)
    {  
        
		if (!hold)
		{
			if (trigger_top_ram)
				top_ram();
			else
			{
				PORTC |= (1<<RES);          //Reset des CPLD Adresscounters
				PORTC &= ~(1<<RES);          
				PORTC |= (1<<RUN);          //Beschreiben des RAMs mit AD Werten
				while (PINC & (1<<STO));    //Letzte Speicheradresse erreicht
				PORTC &= ~(1<<RUN);
				get_data();
			}
		}
		is_hold();
    }
}



