Imports System.Math

Public Class Form1
    Const div_y = 10
    Const div_x = 12
    Const box_delta_y = 40
    Const box_delta_x = 40
    Const acc_border = 12
    Public Const HeaderLength = 1 ' HeaderLength ist gleich 2 von 0 bis 1 - real 5, wird aber beim Lesen aus Data(x) entfernt
    Public DIV_loop As Decimal
    Public DIV_teiler As Decimal
    Public Const RAM_size = 32768
    Public Data(RAM_size + 1024) ' gre Index abgeleitet von SerialPort1.ReadBuffersize
    Const c_RX_Count = 650 'Public
    Dim RX_Count = c_RX_Count + HeaderLength
    Const TL_off = 0 'TimeLines_off
    Const TL_1 = 1 'TimeLine_1
    Const TL_2 = 2 'TimeLine_2
    Const TL_3 = 3 'TimeLine_3 fr fft eigene TimeLine genommen um trigger_delay nicht wieder rausnehmen zu mssen
    ' eine dritte Zeilinie => TL_3=3 definieren; Dim TimeLine(TL_3) und
    ' z.B: DrawCursorLine(grafx.Graphics, TimeLine(TL_3), myPen7)
    Dim TimeLineData(TL_3) As Decimal 'Feld(0)0 - moving = False, sonst Zeiger auf Feldx (ZeitLinie1, ZeitLinie2...)
    Dim visbleTimeL As Boolean
    Delegate Sub SetTextCallback(ByVal x As Decimal)
    Public Time_Bytes_Print As Integer
    Dim Time_div_set As Byte
    Dim varDIV_loop As Decimal = 1
    Dim TP_DIV_loop As Decimal = 1
    Dim accelerate As Boolean = False
    Dim acc_delay As Byte = 0
    Dim TrigPos As Boolean
    Public trigoff As Byte
    Dim trigger_delay As Byte
    Dim trigger_prev As Boolean
    Dim trigger_ram As Boolean
    Dim trigger_vz As Integer = -1
    Dim TrHinweis As String
    Dim sync_plus As Boolean
    Dim Switch_hold As Boolean
    Dim hold As Boolean
    Dim Ac As Boolean
    Dim readDataHold As Boolean = False
    Dim TrPoint As Integer
    Dim Uss_Visible As Boolean = True
    Public Uss_corr As Decimal = 22.8
    Dim UssGr_corr As Decimal = 1.175
    Dim Y0_line As Decimal = 146
    Dim delta_x1 As Decimal
    '======================================
    Dim fft_on As Boolean = False
    Public fft_exp_sampels As Byte  '0=512, 1=1024, 2=2048, 3=4096, 4=8192 und 5=16384 mglich
    Dim fa As Decimal 'Abtastfrequenz
    Dim fft_Dehnen_Value As Integer

    Private Sub Form1_Load(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.Load
        Dim ports() As String
        Dim port As String
        Dim count As Integer
 
        visbleTimeL = False
        TimeLineData(0) = TL_off
        TimeLineData(TL_1) = HeaderLength + 1
        TimeLineData(TL_2) = HeaderLength + 1
        TimeLineData(TL_3) = HeaderLength + 1
        Time_Bytes_Print = 100
        Write_Spectrum()
        Timer1.Interval = ReadIniValue(My.Application.Info.DirectoryPath & "\MyScope.ini", "Scope", "Timer-Interval")
        Timer1.Start()
        trigger_ram = True
        set_TrMode()
        fft_on = False
        'Com Ports suchen und in Liste eintragen
        ports = System.IO.Ports.SerialPort.GetPortNames
        ComboBox_ComPort.Text = ports(0)
        For Each port In ports
            ComboBox_ComPort.Items.Add(port)
        Next port

        For count = 0 To c_RX_Count
            Data(count) = Y0_line
        Next
        ComboBox_ComPort.Text = ReadIniValue(My.Application.Info.DirectoryPath & "\MyScope.ini", "Default", "Port")
        Time_div_set = ReadIniValue(My.Application.Info.DirectoryPath & "\MyScope.ini", "Scope", "Time-div")
        If (Time_div_set < 0) And (Time_div_set > 14) Then
            Time_div_set = 12       ' Zeitbasis auf 1 ms
            TextBox_Horizomtal.Text = "1 ms"
        Else
            TextBox_Horizomtal.Text = ReadIniValue(My.Application.Info.DirectoryPath & "\MyScope.ini", "Scope", "Time-Text")
        End If
        TrackBar_Trigger.Value = ReadIniValue(My.Application.Info.DirectoryPath & "\MyScope.ini", "Scope", "Triggervalue")
        If (TrackBar_Trigger.Value < 0) And (TrackBar_Trigger.Value > 255) Then
            TrackBar_Trigger.Value = 170
        End If
        TrackBar_YPos.Value = ReadIniValue(My.Application.Info.DirectoryPath & "\MyScope.ini", "Scope", "Y-Position")
        If (TrackBar_YPos.Value < 0) And (TrackBar_YPos.Value > 255) Then
            TrackBar_YPos.Value = 128
        End If
        TrHinweis = UCase(ReadIniValue(My.Application.Info.DirectoryPath & "\MyScope.ini", "Scope", "Trigger-Hinweis"))
        If (TrHinweis = "Y") Or (TrHinweis = "YES") Then
            TrHinweis = "yes"
        ElseIf (TrHinweis = "N") Or (TrHinweis = "NO") Or (TrHinweis = "") Then
            TrHinweis = "no"
        End If
        Uss_corr = ReadIniValue(My.Application.Info.DirectoryPath & "\MyScope.ini", "Measurement-correction", "Uss-corr")
        If (Uss_corr = 0) Or (Uss_corr > 1000) Then
            Uss_Visible = False
            Uss_corr = 1
        End If
        UssGr_corr = ReadIniValue(My.Application.Info.DirectoryPath & "\MyScope.ini", "Measurement-correction", "UssGraph-corr")
        Y0_line = ReadIniValue(My.Application.Info.DirectoryPath & "\MyScope.ini", "Measurement-correction", "Y0-Line")
        SerialPort1.PortName() = ComboBox_ComPort.Text
        fft_exp_sampels = ReadIniValue(My.Application.Info.DirectoryPath & "\MyScope.ini", "Scope", "FFT-exp")
        If (fft_exp_sampels < 0) Or (fft_exp_sampels > 5) Then
            fft_exp_sampels = 0
        End If
        Nfft = 512 << fft_exp_sampels ' 512 * 2 ^ fft_exp_sampels
        N05fft = Nfft \ 2
        TrackBar_fft_Dehnen.Maximum = 1 << fft_exp_sampels
        TrackBar_fft_Dehnen.Value = TrackBar_fft_Dehnen.Maximum
        fft_Dehnen_Value = 1
    End Sub

    Private Sub Button_ComPort_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button_ComPort.Click
        'Button COM Port Open/Close
        If SerialPort1.IsOpen = False Then
            Try
                SerialPort1.Open()
            Catch
                MsgBox("Error open " + ComboBox_ComPort.Text)
                Exit Sub
            End Try
            Button_ComPort.Text = "CLOSE"
            Button_ComPort.BackColor = SystemColors.Control
            ComboBox_ComPort.Enabled = False
            Time_print()
            Ac = False              ' wird durch set_AC auf True geschaltet - repetierend
            set_AC()                ' AC
            set_triggeroff()
            set_trigfl()            ' positive Flanke
            TrackBar_Trigger_delay.Value = 0     ' keine Triggerverzgerung
            set_trigger_delay()
            sync_plus = True        ' wird gleich zurckgeschaltet, damit nicht mit sync_plus (gelb) anfngt
            set_trigger_del()       ' Schalter auf Triggerverzgerung
            sync_plus = False       ' sonst msste im ungnstigsten Fall Button 2 mal bettigt werden
            Switch_hold = True      ' wird durch set_hold auf False geschaltet - repetierend
            set_hold()
            set_y_pos()             ' Y-Position Offset
            trigger_ram = Not (trigger_ram)
            set_TrMode()            ' ansonsten funktioniert manchmal Triggerdelay nicht nach ffnen
            accelerate = True
            set_acc()
            GroupBox_TriggerDelay.Visible = trigger_ram
            fft_on = Not (fft_on)   ' aktuellen Zustand beibehalten, set_fft repetierend
            set_fft()
        Else
            Button_ComPort.Text = "OPEN"
            ComboBox_ComPort.Enabled = True
            Button_ComPort.BackColor = Color.Red
            SerialPort1.Close()
            Button_Tr_pos.BackColor = SystemColors.Control
            Button_Tr_neg.BackColor = SystemColors.Control
            Button_Tr_prev.BackColor = SystemColors.Control
            Button_Tr_prev.ForeColor = SystemColors.ControlText
            Button_Tr_delay.BackColor = SystemColors.Control
            Button_Tr_delay.ForeColor = SystemColors.ControlText
            Button_Hold.BackColor = SystemColors.Control
            GroupBox_TriggerDelay.ForeColor = SystemColors.ControlText
        End If
    End Sub

    Private Sub Write_Spectrum()

        Dim U_low As Decimal = 256
        Dim U_high As Decimal = 0
        Dim Uss As Decimal
        Dim i As Decimal
        Dim myGrafik As Graphics
        Dim myPen1 As New Pen(Color.Black, 2)
        Dim myPen2 As New Pen(Color.DarkGray, 1)
        Dim myPen3 As New Pen(Color.DarkGray, 3)
        Dim myPen4 As New Pen(Color.DarkRed, 2)
        Dim myPen5 As New Pen(Color.DarkBlue, 2)
        Dim drawFont As New Font("Microsoft Sans Serif", 8)
        Dim drawFontUSS As New Font("Microsoft Sans Serif", 12)
        Dim TextSize As New System.Drawing.SizeF
        Dim DimResult As String = ""
        Dim f1 As Decimal
        Dim fs As String
        Dim count As Decimal

        Dim pb_x As Decimal
        Dim pb_y As Decimal

        Dim delta_y As Decimal
        Dim delta_x As Decimal

        Dim delta_y1 As Decimal
        'Dim delta_x1 As Decimal

        Dim grafx As BufferedGraphics
        Dim context As BufferedGraphicsContext

        context = BufferedGraphicsManager.Current
        context.MaximumBuffer = New Size(PictureBox1.Width + 1, PictureBox1.Height + 1)
        grafx = context.Allocate(PictureBox1.CreateGraphics(), New Rectangle(0, 0, PictureBox1.Width, PictureBox1.Height))

        'clear buffer
        grafx.Graphics.FillRectangle(Brushes.ForestGreen, 0, 0, PictureBox1.Width, PictureBox1.Height)

        myGrafik = Graphics.FromHwnd(hwnd:=PictureBox1().Handle)

        If Time_Bytes_Print = 0 Then Time_Bytes_Print = 1 '512


        pb_x = PictureBox1.Width - (2 * box_delta_x)
        pb_y = PictureBox1.Height - (2 * box_delta_y)

        delta_y = pb_y / div_y
        delta_x = pb_x / div_x

        '====================================================
        If fft_on Then

            'paint horizontal lines
            For count = 0 To div_y
                grafx.Graphics.DrawLine(myPen2, box_delta_x, (delta_y * count) + box_delta_y, pb_x + box_delta_x, (delta_y * count) + box_delta_y)
            Next

            'paint vertical lines
            'delta_x = pb_x / div_x

            For count = 0 To div_x
                grafx.Graphics.DrawLine(myPen2, (delta_x * count) + box_delta_x, box_delta_y, (delta_x * count) + box_delta_x, pb_y + box_delta_y)

                fs = xAchse(df * (HScrollBar1.Value - 1) + fn / (div_x * fft_Dehnen_Value) * count, fn, DimResult)
                TextSize = grafx.Graphics.MeasureString(fs, drawFont)
                If count < div_x Then
                    grafx.Graphics.DrawString(fs, drawFont, Brushes.Black, (delta_x * count) + box_delta_x - TextSize.Width / 2, pb_y + box_delta_y + 2)
                Else
                    grafx.Graphics.DrawString(fs + DimResult, drawFont, Brushes.Black, (delta_x * count) + box_delta_x - 3 - TextSize.Width / 2, pb_y + box_delta_y + 2)
                End If
            Next
            If maxvalue = 0 Then
                maxvalue = 1
            End If

            Calculate_fft()

            delta_y1 = pb_y / maxvalue
            delta_x1 = pb_x * fft_Dehnen_Value / N05fft

            f1 = df * smax
            TextSize = grafx.Graphics.MeasureString(FormatFrequenz(f1), drawFont)
            grafx.Graphics.DrawString(FormatFrequenz(f1), drawFont, Brushes.Yellow, CInt((delta_x1 * (smax - HScrollBar1.Value + 1)) + box_delta_x - TextSize.Width / 2), pb_y + box_delta_y + TextSize.Height + 2)
            'paint data line - HeaderLength wurde bei DatFFT() bereits herausgenommen
            For count = 1 To N05fft \ fft_Dehnen_Value
                i = count + HScrollBar1.Value - 1
                grafx.Graphics.DrawLine(myPen1, (count * delta_x1) - delta_x1 + box_delta_x, pb_y - DatFFT(i - 1) * delta_y1 + box_delta_y, (count * delta_x1) + box_delta_x, pb_y - DatFFT(i) * delta_y1 + box_delta_y)
            Next

            If visbleTimeL Then 'Cursor-Linien zeichnen
                DrawCursorLine(grafx.Graphics, TimeLineData(TL_3), pb_x, myPen5)
            End If
        Else
            '====================================================

            'paint horizontal lines
            For count = 0 To div_y
                If count = 5 Then
                    grafx.Graphics.DrawLine(myPen3, box_delta_x, (delta_y * count) + box_delta_y, pb_x + box_delta_x, (delta_y * count) + box_delta_y)
                Else
                    grafx.Graphics.DrawLine(myPen2, box_delta_x, (delta_y * count) + box_delta_y, pb_x + box_delta_x, (delta_y * count) + box_delta_y)
                End If
            Next

            'paint vertical lines
            For count = 0 To div_x
                If count = div_x / 2 Then
                    grafx.Graphics.DrawLine(myPen3, (delta_x * count) + box_delta_x, box_delta_y, (delta_x * count) + box_delta_x, pb_y + box_delta_y)
                Else
                    grafx.Graphics.DrawLine(myPen2, (delta_x * count) + box_delta_x, box_delta_y, (delta_x * count) + box_delta_x, pb_y + box_delta_y)
                End If
            Next

            delta_y1 = pb_y / 255              'AD-Wandler max. Digitalwert
            delta_x1 = pb_x / Time_Bytes_Print 'RX_DATA

            'paint data line
            For count = 1 To Time_Bytes_Print 'RX_DATA
                i = (count * (varDIV_loop)) - varDIV_loop + HeaderLength + HScrollBar1.Value
                grafx.Graphics.DrawLine(myPen1, (count * delta_x1) - delta_x1 + box_delta_x, (255 - Data(i)) * UssGr_corr * delta_y1 + box_delta_y, (count * delta_x1) + box_delta_x, (255 - Data(i + varDIV_loop)) * UssGr_corr * delta_y1 + box_delta_y)

                If (U_high < Data(i)) Then
                    U_high = Data(i)
                ElseIf (U_low > Data(i)) Then
                    U_low = Data(i)
                End If
            Next

            DrawTriggerPoint(grafx.Graphics, pb_x, delta_y1)

            If visbleTimeL Then 'Cursor-Linien zeichnen
                DrawCursorLine(grafx.Graphics, TimeLineData(TL_2), pb_x, myPen4)
                DrawCursorLine(grafx.Graphics, TimeLineData(TL_1), pb_x, myPen5)
            End If

            If Uss_Visible Then
                Uss = (U_high - U_low) / Uss_corr
                grafx.Graphics.DrawString("Uss " + Format(Uss, "0.0 V"), drawFontUSS, Brushes.Black, box_delta_x - 5, box_delta_y \ 4)
            End If
        End If

        'display buffer
        grafx.Render(myGrafik)
        grafx.Dispose()

        myPen1.Dispose()
        myPen2.Dispose()
        myPen3.Dispose()
        myPen4.Dispose()
        myPen5.Dispose()
    End Sub

    Private Sub DrawTriggerPoint(ByVal graph As Graphics, ByVal pb_x As Decimal, ByVal delta_y As Decimal)
        Dim myPenTPoint As New Pen(Color.DarkRed, 3)
        Dim myPenTDreieck As New Pen(Color.DarkRed, 2)
        Dim TriggerPoint As Decimal = (TrPoint - HScrollBar1.Value + 1) * delta_x1 / TP_DIV_loop
        If (TriggerPoint > 0) Then
            If (TriggerPoint <= pb_x) Then
                graph.DrawEllipse(myPenTPoint, TriggerPoint + box_delta_x, (255 - trigoff) * UssGr_corr * delta_y + box_delta_y, 2, 2)
            Else
                'wenn Cursorlinien mit z.B. Scrollbar auerhalb des sichtbaren, so wenigsten Vierecke zum Zurckholen darstellen 
                graph.DrawLine(myPenTDreieck, pb_x + box_delta_x + 1, (255 - trigoff) * UssGr_corr * delta_y + box_delta_y, pb_x + box_delta_x - 5, (255 - trigoff) * UssGr_corr * delta_y + box_delta_y + 4)
                graph.DrawLine(myPenTDreieck, pb_x + box_delta_x + 1, (255 - trigoff) * UssGr_corr * delta_y + box_delta_y, pb_x + box_delta_x - 5, (255 - trigoff) * UssGr_corr * delta_y + box_delta_y - 4)
                graph.DrawLine(myPenTDreieck, pb_x + box_delta_x - 4, (255 - trigoff) * UssGr_corr * delta_y + box_delta_y + 4, pb_x + box_delta_x - 4, (255 - trigoff) * UssGr_corr * delta_y + box_delta_y - 4)
            End If
        Else
            graph.DrawLine(myPenTDreieck, box_delta_x - 2, (255 - trigoff) * UssGr_corr * delta_y + box_delta_y, box_delta_x + 4, (255 - trigoff) * UssGr_corr * delta_y + box_delta_y + 4)
            graph.DrawLine(myPenTDreieck, box_delta_x - 2, (255 - trigoff) * UssGr_corr * delta_y + box_delta_y, box_delta_x + 4, (255 - trigoff) * UssGr_corr * delta_y + box_delta_y - 4)
            graph.DrawLine(myPenTDreieck, box_delta_x + 4, (255 - trigoff) * UssGr_corr * delta_y + box_delta_y + 4, box_delta_x + 4, (255 - trigoff) * UssGr_corr * delta_y + box_delta_y - 4)
        End If
        myPenTPoint.Dispose()
        myPenTDreieck.Dispose()
    End Sub

    Private Sub DrawCursorLine(ByVal graph As Graphics, ByVal TimeLineIndex As Long, ByVal pb_x As Decimal, ByVal myPen As Pen)
        Dim TimeLine As Decimal = (TimeLineIndex - HScrollBar1.Value - HeaderLength) * delta_x1 / varDIV_loop
        If (TimeLine >= 0) Then
            If (TimeLine <= pb_x + delta_x1) Then
                Dim startVert As New Point(TimeLine + box_delta_x, box_delta_y)
                Dim endVert As New Point(TimeLine + box_delta_x, Me.PictureBox1.Height - box_delta_y + 2)
                graph.DrawRectangle(myPen, TimeLine - 3 + box_delta_x, box_delta_y - 5, 5, 5)
                graph.DrawLine(myPen, startVert, endVert)
            Else
                'wenn Cursorlinien mit z.B. Scrollbar auerhalb des sichtbaren, so wenigsten Vierecke zum Zurckholen darstellen 
                graph.DrawRectangle(myPen, pb_x + box_delta_x - 3, box_delta_y - 5, 5, 5)
            End If
        Else
            graph.DrawRectangle(myPen, box_delta_x - 3, box_delta_y - 5, 5, 5)
        End If
    End Sub

    Private Sub PictureBox1_MouseDoubleClick(ByVal sender As System.Object, ByVal e As System.Windows.Forms.MouseEventArgs) Handles PictureBox1.MouseDoubleClick
        If visbleTimeL And e.Button = Windows.Forms.MouseButtons.Left Then
            Dim tmpTimeLineData3 As Decimal = TimeLineData_x(TL_3)
            Dim tmpTimeLineData1 As Decimal = TimeLineData_x(TL_1)
            Dim tmpTimeLineData2 As Decimal = TimeLineData_x(TL_2)
            If Mouse_in_Rectangle(e, box_delta_x) Then                         'linkes Viereck
                If fft_on Then
                    If tmpTimeLineData3 < 0 Then
                        TimeLineData(TL_3) = HScrollBar1.Value + HeaderLength
                    End If
                Else
                    If tmpTimeLineData1 < 0 Then
                        TimeLineData(TL_1) = HScrollBar1.Value + HeaderLength
                    ElseIf tmpTimeLineData2 < 0 Then
                        TimeLineData(TL_2) = HScrollBar1.Value + HeaderLength
                    End If
                End If
            ElseIf Mouse_in_Rectangle(e, PictureBox1.Width - box_delta_x) Then 'rechtes Viereck
                If fft_on Then
                    If tmpTimeLineData3 > PictureBox1.Width - (2 * box_delta_x) Then
                        TimeLineData(TL_3) = (PictureBox1.Width - (2 * box_delta_x)) * varDIV_loop / delta_x1 + HScrollBar1.Value + HeaderLength
                    End If
                Else
                    If tmpTimeLineData1 > PictureBox1.Width - (2 * box_delta_x) Then
                        TimeLineData(TL_1) = (PictureBox1.Width - (2 * box_delta_x)) * varDIV_loop / delta_x1 + HScrollBar1.Value + HeaderLength
                    ElseIf tmpTimeLineData2 > PictureBox1.Width - (2 * box_delta_x) Then
                        TimeLineData(TL_2) = (PictureBox1.Width - (2 * box_delta_x)) * varDIV_loop / delta_x1 + HScrollBar1.Value + HeaderLength
                    End If
                End If
            End If
        End If
    End Sub
    Function Mouse_in_Rectangle(ByVal e As System.Windows.Forms.MouseEventArgs, ByVal x_mid_Rect As Decimal) As Boolean
        'Innerhalb der oberen und unteren Line                   und der linken und rechten Linie des Vierecks?
        Return (e.Y >= box_delta_y - 6 And e.Y <= box_delta_y + 1 And e.X - 4 <= x_mid_Rect And e.X + 3 >= x_mid_Rect)
    End Function
    Function TimeLineData_x(ByVal TL_x As Decimal) As Decimal
        Return ((TimeLineData(TL_x) - HScrollBar1.Value - HeaderLength) * delta_x1 / varDIV_loop)
    End Function

    Private Sub PictureBox1_MouseMove(ByVal sender As System.Object, ByVal e As System.Windows.Forms.MouseEventArgs) Handles PictureBox1.MouseMove
        If TimeLineData(0) > TL_off Then
            If e.X < box_delta_x Then                         'linker Rand erreicht?
                TimeLineData(TimeLineData(0)) = HScrollBar1.Value + HeaderLength
            ElseIf e.X > PictureBox1.Width - box_delta_x Then 'rechter Rand erreicht?
                TimeLineData(TimeLineData(0)) = (PictureBox1.Width - (2 * box_delta_x)) * varDIV_loop / delta_x1 + HScrollBar1.Value + HeaderLength
            Else                                              'innerhalb des Bereiches
                TimeLineData(TimeLineData(0)) = ((e.X - box_delta_x) * varDIV_loop / delta_x1) + HScrollBar1.Value + HeaderLength
            End If
        End If
        CalculateTime()
        If Switch_hold Then
            Write_Spectrum()
        End If
    End Sub

    Private Sub PictureBox1_MouseDown(ByVal sender As System.Object, ByVal e As System.Windows.Forms.MouseEventArgs) Handles PictureBox1.MouseDown
        If visbleTimeL And e.Button = Windows.Forms.MouseButtons.Left Then
            If e.Y >= box_delta_y - 6 And e.Y <= Me.PictureBox1.Height - box_delta_y + 2 Then 'Innerhalb der oberen und unteren Line?
                If fft_on Then
                    If TLx_MouseDown(e, TL_3) Then
                        TimeLineData(0) = TL_3
                    End If
                Else
                    If TLx_MouseDown(e, TL_1) Then
                        TimeLineData(0) = TL_1
                    ElseIf TLx_MouseDown(e, TL_2) Then
                        TimeLineData(0) = TL_2
                    End If
                End If
            End If
        End If
    End Sub
    Function TLx_MouseDown(ByVal e As System.Windows.Forms.MouseEventArgs, ByVal TL_x As Decimal) As Boolean
        Dim tmpTimeLineData As Decimal = (TimeLineData(TL_x) - HScrollBar1.Value - HeaderLength) * delta_x1 / varDIV_loop + box_delta_x
        Return (e.X - 3 <= tmpTimeLineData And e.X + 2 >= tmpTimeLineData) Or Mouse_in_Rectangle(e, tmpTimeLineData)
    End Function

    Private Sub PictureBox1_MouseUp(ByVal sender As System.Object, ByVal e As System.Windows.Forms.MouseEventArgs) Handles PictureBox1.MouseUp
        If e.Button = Windows.Forms.MouseButtons.Left Then
            TimeLineData(0) = TL_off
        End If
    End Sub

    Private Sub Button_Cursor_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button_Cursor.Click
        If visbleTimeL Then
            visbleTimeL = False
            Button_Cursor.Text = "on"
            TextBox_Cu_Zeit.Text = ""
            TextBox_Cu_Frequenz.Text = ""
        Else
            visbleTimeL = True
            Button_Cursor.Text = "off"
            CalculateTime()
        End If
        If Switch_hold Then
            Write_Spectrum()
        End If
    End Sub

    Private Sub Timer1_Tick(ByVal sender As Object, ByVal e As System.EventArgs) Handles Timer1.Tick
        If SerialPort1.IsOpen = True Then
            Try
                SerialPort1.Write("GET")
                SerialPort1.Write(Chr(13))
            Catch
                Exit Try
            End Try
        End If
        Write_Spectrum()
    End Sub

    Private Sub SerialPort1_DataReceived(ByVal sender As Object, ByVal e As System.IO.Ports.SerialDataReceivedEventArgs) Handles SerialPort1.DataReceived
        Const exit_end = 100
        Dim Byte_RX_Count As Long
        Dim p As Byte
        Dim header_b0, header_b1, header_b2, header_b3 As Byte
        Dim header, header_hold As Boolean
        Dim tmp_p As Byte = 0
        Dim exit_count As Integer

        header = False
        header_b1 = 1
        header_b2 = 1
        header_b3 = 1
        header_hold = False
        If Not (hold) Then
            Do
                header_b0 = header_b1
                header_b1 = header_b2
                header_b2 = header_b3
                exit_count = exit_end
                Try
                    While (SerialPort1.BytesToRead = 0) And (exit_count > 0)
                        exit_count -= 1
                    End While
                Catch
                    Exit Sub
                End Try
                Try
                    header_b3 = SerialPort1.ReadByte()
                Catch
                    Exit Sub
                End Try
                If header_b0 = 0 Then
                    If header_b1 = 255 And header_b2 = 0 And header_b3 = 240 Then
                        header_hold = True
                        header = True
                    ElseIf header_b1 = 0 And header_b2 = 255 And header_b3 = 240 Then
                        header = True
                    End If
                End If
            Loop Until header
            For Byte_RX_Count = 0 To (RX_Count)
                exit_count = exit_end
                Try
                    While (SerialPort1.BytesToRead = 0) And (exit_count > 0)
                        exit_count -= 1
                    End While
                Catch
                    Exit For
                End Try
                Try
                    Data(Byte_RX_Count) = SerialPort1.ReadByte()
                Catch
                    Exit For
                End Try
            Next
            TrPoint = Data(1)                  ' BitSchieben von Array-Inhalten nicht mglich
            TrPoint = Data(0) + (TrPoint << 8) ' Triggerpunkt besteht aus msb und lsb
            If HScrollBar1.Maximum > 1 And TrPoint > HScrollBar1.Maximum Then ' kommt nur bei Fehler whrend der seriellen
                TrPoint = HScrollBar1.Maximum - 2 ' Datenbertragung vor - muss aber behandelt
            End If                                ' werden
            If Switch_hold Then
                If header_hold Then
                    hold = True
                    Button_Hold.BackColor = Color.Yellow
                    readDataHold = True
                    TrPoint = TrPoint + 2 ' 2 - rs232-bertragung erst kurz nach Triggerung
                    GroupBox_TriggerDelayVisible(0)
                    GroupBox_Y_PosVisible(0)
                End If
            End If
        Else
            If readDataHold Then ' macht das Einlesen HoldRam noch etwas sicherer
                ProgressVisible(1)
                Do
                    header_b0 = header_b1
                    header_b1 = header_b2
                    header_b2 = header_b3
                    exit_count = exit_end
                    Try
                        While (SerialPort1.BytesToRead = 0) And (exit_count > 0)
                            exit_count -= 1
                        End While
                    Catch
                        Exit Sub
                    End Try
                    Try
                        header_b3 = SerialPort1.ReadByte()
                    Catch
                        Exit Sub
                    End Try
                Loop Until header_b0 = 0 And header_b1 = 255 And header_b2 = 254 And header_b3 = 240
                For Byte_RX_Count = 0 To RAM_size - 5 ' rs232-bertragung relativ unsicher
                    exit_count = exit_end
                    Try
                        While (SerialPort1.BytesToRead = 0) And (exit_count > 0)
                            exit_count -= 1
                        End While
                    Catch
                        Exit For
                    End Try
                    Try
                        Data(Byte_RX_Count) = SerialPort1.ReadByte()
                    Catch
                        Exit For
                    End Try
                    p = Byte_RX_Count * 100 \ (RAM_size + 1) ' sonst bremst ProgressBar
                    If p > tmp_p Then                        ' das Einlesen zu sehr aus
                        tmp_p = p                            ' so um ca. Faktor 2
                        set_Progress(p)                      ' schneller
                    End If
                Next
                ProgressVisible(0)
                If Not (trigger_prev) Then
                    TrPoint = TrPoint + (DIV_loop + 1) * trigger_delay
                End If
                HScrollBarValue(TrPoint)                 ' im TriggerEreignis mit Darstellung beginnen 
                HScrollBarVisible(1)
                TimeLineData(TL_1) = TrPoint + HeaderLength
                TimeLineData(TL_2) = TrPoint + HeaderLength
                TrPoint = TrPoint + (DIV_loop + 1) * trigger_delay * trigger_vz
                If Not (trigger_ram) Then
                    TrPoint = 0
                    GroupBox_SpurVisible(0)
                End If
                readDataHold = False
                If DIV_loop > 0 Then
                    GroupBox_DehnenVisible(1)
                    TrackBar_DehnenMax(DIV_loop + 1)
                    TrackBar_DehnenValue(DIV_loop + 1)
                    varDIV_loop = DIV_loop + 1
                    TP_DIV_loop = DIV_loop + 1
                End If
            End If
        End If
    End Sub
    Private Sub set_Progress(ByVal x As Decimal)
        If Me.ProgressBar1.InvokeRequired Then
            Dim d As New SetTextCallback(AddressOf set_Progress)
            Me.Invoke(d, New Object() {x})
        Else
            Me.ProgressBar1.Value = x
        End If
    End Sub
    Private Sub ProgressVisible(ByVal x As Decimal)
        If Me.ProgressBar1.InvokeRequired Then
            Dim d As New SetTextCallback(AddressOf ProgressVisible)
            Me.Invoke(d, New Object() {x})
        Else
            Me.ProgressBar1.Visible = x
        End If
    End Sub
    Private Sub HScrollBarValue(ByVal x As Decimal)
        If Me.HScrollBar1.InvokeRequired Then
            Dim d As New SetTextCallback(AddressOf HScrollBarValue)
            Me.Invoke(d, New Object() {x})
        Else
            Me.HScrollBar1.Value = x
        End If
    End Sub
    Private Sub HScrollBarVisible(ByVal x As Decimal)
        If Me.HScrollBar1.InvokeRequired Then
            Dim d As New SetTextCallback(AddressOf HScrollBarVisible)
            Me.Invoke(d, New Object() {x})
        Else
            Me.HScrollBar1.Visible = x
        End If
    End Sub
    Private Sub GroupBox_Y_PosVisible(ByVal x As Decimal)
        If Me.GroupBox_Y_Pos.InvokeRequired Then
            Dim d As New SetTextCallback(AddressOf GroupBox_Y_PosVisible)
            Me.Invoke(d, New Object() {x})
        Else
            Me.GroupBox_Y_Pos.Visible = x
        End If
    End Sub
    Private Sub GroupBox_TriggerDelayVisible(ByVal x As Decimal)
        If Me.GroupBox_TriggerDelay.InvokeRequired Then
            Dim d As New SetTextCallback(AddressOf GroupBox_TriggerDelayVisible)
            Me.Invoke(d, New Object() {x})
        Else
            Me.GroupBox_TriggerDelay.Visible = x
        End If
    End Sub
    Private Sub GroupBox_DehnenVisible(ByVal x As Decimal)
        If Me.GroupBox_Dehnen.InvokeRequired Then
            Dim d As New SetTextCallback(AddressOf GroupBox_DehnenVisible)
            Me.Invoke(d, New Object() {x})
        Else
            Me.GroupBox_Dehnen.Visible = x
        End If
    End Sub
    Private Sub TrackBar_DehnenMax(ByVal x As Decimal)
        If Me.TrackBar_Dehnen.InvokeRequired Then
            Dim d As New SetTextCallback(AddressOf TrackBar_DehnenMax)
            Me.Invoke(d, New Object() {x})
        Else
            Me.TrackBar_Dehnen.Maximum = x
        End If
    End Sub
    Private Sub TrackBar_DehnenValue(ByVal x As Decimal)
        If Me.TrackBar_Dehnen.InvokeRequired Then
            Dim d As New SetTextCallback(AddressOf TrackBar_DehnenValue)
            Me.Invoke(d, New Object() {x})
        Else
            Me.TrackBar_Dehnen.Value = x
        End If
    End Sub
    Private Sub GroupBox_SpurVisible(ByVal x As Decimal)
        If Me.GroupBox_Spur.InvokeRequired Then
            Dim d As New SetTextCallback(AddressOf GroupBox_SpurVisible)
            Me.Invoke(d, New Object() {x})
        Else
            Me.GroupBox_Spur.Visible = x
        End If
    End Sub

    Private Sub Button_t_plus_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button_t_plus.Click
        If (SerialPort1.IsOpen = True) And Not (hold) Then
            If Time_div_set < 15 And (Not (fft_on) Or fft_exp_sampels = 0 Or trigger_ram Or Not (accelerate) Or Time_div_set + 1 < acc_border) Then
                Time_div_set = Time_div_set + 1
                Time_print()
            End If
        End If
    End Sub

    Private Sub Button_t_minus_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button_t_minus.Click
        If (SerialPort1.IsOpen = True) And Not (hold) Then
            If Time_div_set > 0 Then
                Time_div_set = Time_div_set - 1
                Time_print()
            End If
        End If
    End Sub

    Private Sub Time_print()
        'bei Teiler 1 max RAM-Inhalt 20ns * 1 * 32768 = 655369 ns ca. 655 s
        'innerhalb ca. des halben Speichers wird Triggerflanke ermittelt, so
        'dass im ungnstigen Fall nur die halbe Aufzeichnungszeit fr das Signal
        'zur Verfgung steht. Die Triggerverzgerung beeinflusst diese zustzlich.
        Dim DIV As String
        Dim DimResult As String = ""
        Dim Result As Decimal

        Select Case Time_div_set
            Case 0
                ' 100 ns
                Time_Bytes_Print = 60
                DIV_loop = 0
                DIV_teiler = 0
                '1 * 20ns * 60 Sampels /12Div = 100ns ** H

            Case 1
                ' 250 ns
                Time_Bytes_Print = 150
                DIV_loop = 0
                DIV_teiler = 0
                '1 * 20ns * 150 Sampels /12Div = 250ns ** H

            Case 2
                ' 500 ns
                Time_Bytes_Print = 300
                DIV_loop = 0
                DIV_teiler = 0
                '1 * 20ns * 300 Sampels / 12Div = 500ns ** H

            Case 3
                ' 1 s
                Time_Bytes_Print = 600
                DIV_loop = 0
                DIV_teiler = 0
                '1 * 20ns * 600Sampels / 12 Div = 1000ns 1s ** H

            Case 4
                ' 2.5 s
                Time_Bytes_Print = 500
                DIV_loop = 2
                DIV_teiler = 0
                '3 * 20ns * 500Sampels / 12 Div = 2500ns 2,5s ** H

            Case 5
                '5 s
                Time_Bytes_Print = 600
                DIV_loop = 4
                DIV_teiler = 0
                '5 * 20ns * 600Sampels / 12 Div = 5000ns 5s ** H

            Case 6
                ' 10 s
                Time_Bytes_Print = 600
                DIV_loop = 9
                DIV_teiler = 0
                '10 * 20ns * 600 Sampels / 12Div = 10000 ns 10 s ** H

                'bei Teiler 2 max RAM-Inhalt 20ns * 2 * 32768 = 1310720 ns ca. 1,3 ms
            Case 7
                ' 25 s
                Time_Bytes_Print = 600
                DIV_loop = 24
                DIV_teiler = 0
                '25 * 20ns * 600 Sampels /12Div = 25000 ns 25 s ** H
                'Teiler bei 25s von 625,11,3 wieder auf 600,24,0 gesetzt, da vorher extrem lange Wiederholrate
                'Time_Bytes_Print = 625
                'DIV_loop = 11
                'DIV_teiler = 3
                '12 * 2 * 20ns * 625 Sampels /12Div = 25000 ns 25 s ** H

                'bei Teiler 32 max RAM-Inhalt 20ns * 32 * 32768 = 20971520 ns ca. 21 ms
            Case 8
                ' 50 s
                Time_Bytes_Print = 469
                DIV_loop = 1
                DIV_teiler = 1
                '2 * 32 * 20ns * 469 Sampels /12Div = 50027 ns ca 50 s ** H

            Case 9
                ' 100 s
                Time_Bytes_Print = 625
                DIV_loop = 2
                DIV_teiler = 1
                '3 * 32 * 20ns * 625 Sampels /12Div = 100000ns 100s ** H

            Case 10
                ' 250 s
                Time_Bytes_Print = 586
                DIV_loop = 7
                DIV_teiler = 1
                '8 * 32 * 20ns * 586 Sampels /12Div = 250027ns ca 250s ** H

            Case 11
                ' 500 s
                Time_Bytes_Print = 625
                DIV_loop = 14
                DIV_teiler = 1
                '15 * 32 * 20ns * 625Sampels /12Div = 500000ns 500s ** H

                'bei Teiler 256 max RAM-Inhalt 20ns * 256 * 32768 = 167772160 ns ca. 167 ms
            Case 12
                ' 1 ms
                Time_Bytes_Print = 469
                DIV_loop = 4
                DIV_teiler = 2
                '5 * 256 * 20ns * 469Sampels /12Div = 1000533ns ca 1ms

            Case 13
                ' 2.5 ms
                Time_Bytes_Print = 586
                DIV_loop = 9
                DIV_teiler = 2
                '10 * 256 * 20ns * 586Sampels /12Div = 2500267ns ca 2.5ms

            Case 14
                ' 5 ms
                Time_Bytes_Print = 558
                DIV_loop = 20
                DIV_teiler = 2
                '21 * 256 * 20ns * 558Sampels /12Div = 4999680ns ca 5ms

            Case 15
                ' 10 ms
                Time_Bytes_Print = 601
                DIV_loop = 38
                DIV_teiler = 2
                '39 * 256 * 20ns * 601 Sampels /12Div = 10000640ns ca 10ms

        End Select

        DIV = "DIV " + CStr(DIV_teiler) + "," + CStr(DIV_loop)
        Try
            SerialPort1.Write(DIV)
            SerialPort1.Write(Chr(13))
        Catch
            Exit Try
        End Try
        TP_DIV_loop = DIV_loop + 1

        Result = Produkt_vTeilerSRate(DIV_teiler) * (DIV_loop + 1) * Time_Bytes_Print
        If Not (trigger_ram) Then
            acc_delay = Result \ 1000000 + 1 ' gleich in ms + 1ms wegen Nachkommastellen
            If Time_div_set < acc_border Then  ' ab 1ms und top-RAM beschleunigen der Darstellung durch vorzeitiges Beenden RAM-write mglich
                acc_delay = 0         ' sonst vollstndig RAM beschreiben
                GroupBox_Spur.Visible = False
                Button_Hold.Visible = True
            Else
                If Not (fft_on) Then
                    GroupBox_Spur.Visible = True
                End If
            End If
            If accelerate Then
                If acc_delay > 0 Then
                    Button_Hold.Visible = False
                End If
                Try
                    SerialPort1.Write("ACC")
                    SerialPort1.Write(Str(acc_delay))
                    SerialPort1.Write(Chr(13))
                Catch
                    Exit Try
                End Try
            End If
        End If
        'Horizontal div
        TextBox_Horizomtal.Text = CStr(Round(CalculateTimeDim(Result / div_x, DimResult) * 100) / 100) + DimResult  'x * 20ns in Func enthalten
        If fft_on Then
            fft_init_values()
            Write_Spectrum() 'nur fr Frequenzanzeige Cursor bei FFT delta_x1 wird nur bei Write_Spectrum gendert
            CalculateTime()  'nur fr Frequenzanzeige Cursor bei FFT
        End If
    End Sub

    Private Sub fft_init_values()
        fa = 1000000000 / Produkt_vTeilerSRate(DIV_teiler)
        If Nfft = 512 Then
            fa = 1000000000 / (Produkt_vTeilerSRate(DIV_teiler) * (DIV_loop + 1))
        Else
            fa = 1000000000 / Produkt_vTeilerSRate(DIV_teiler)
        End If
        fn = fa / 2
        df = fa / Nfft
    End Sub

    Private Sub Button_set_AC_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button_AC.Click
        If Not (hold) Then
            set_AC()
        End If
    End Sub
    Private Sub set_AC()
        If SerialPort1.IsOpen = True Then
            If Ac Then
                Ac = False
                Button_AC.Text = "DC"
                Try
                    SerialPort1.Write("DC")
                    SerialPort1.Write(Chr(13))
                Catch
                    Exit Try
                End Try
            Else
                Ac = True
                Button_AC.Text = "AC"
                Try
                    SerialPort1.Write("AC")
                    SerialPort1.Write(Chr(13))
                Catch
                    Exit Try
                End Try
            End If
        End If
    End Sub

    Private Sub TrackBar_YPos_Scroll(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles TrackBar_YPos.Scroll
        set_y_pos()
    End Sub
    Private Sub set_y_pos()
        Dim offset As Byte
        If SerialPort1.IsOpen = True Then
            offset = TrackBar_YPos.Value
            Try
                SerialPort1.Write("OFFSET")
                SerialPort1.Write(Str(offset))
                SerialPort1.Write(Chr(13))
            Catch
                Exit Try
            End Try
        End If
    End Sub

    Private Sub ComboBox_ComPort_SelectedIndexChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles ComboBox_ComPort.SelectedIndexChanged
        SerialPort1.PortName() = ComboBox_ComPort.Text
    End Sub

    Private Sub Button_Pr_print_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button_Pr_print.Click
        If PrintDialog1.ShowDialog() = Windows.Forms.DialogResult.OK Then
            PrintDocument1.Print()
        End If
    End Sub

    Private Sub Button_Pr_prev_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button_Pr_prev.Click
        PrintPreviewDialog1.Document = PrintDocument1
        If PrintPreviewDialog1.ShowDialog() = Windows.Forms.DialogResult.OK Then
            PrintDocument1.Print()
        End If
    End Sub

    Private Sub PrintDocument1_PrintPage(ByVal sender As System.Object, ByVal e As System.Drawing.Printing.PrintPageEventArgs) Handles PrintDocument1.PrintPage
        Dim i As Decimal
        Dim grafx As Graphics = e.Graphics
        Dim myPen1 As New Pen(Color.Black, 1)
        Dim myPen2 As New Pen(Color.DarkGray, 1)
        Dim myPen3 As New Pen(Color.DarkGray, 3)
        Dim drawFont As New Font("Microsoft Sans Serif", 8)
        'Dim drawBrush As New SolidBrush(Color.Black)
        Dim TextSize As New System.Drawing.SizeF
        Dim DimResult As String = ""
        Dim f1 As Decimal
        Dim fs As String
        Dim count As Integer

        Dim pb_x As Integer
        Dim pb_y As Integer

        Dim delta_y As Decimal
        Dim delta_x As Decimal

        Dim delta_y1 As Decimal
        Dim delta_x1 As Decimal

        If Time_Bytes_Print > c_RX_Count Then Time_Bytes_Print = c_RX_Count
        If Time_Bytes_Print = 0 Then Time_Bytes_Print = c_RX_Count

        pb_x = 650 - (2 * box_delta_x)
        pb_y = 520 - (2 * box_delta_y)

        delta_y = pb_y / div_y
        delta_x = pb_x / div_x

        delta_y1 = pb_y / 255
        delta_x1 = pb_x / Time_Bytes_Print 'RX_DATA
        If fft_on Then

            'paint horizontal lines
            For count = 0 To div_y
                grafx.DrawLine(myPen2, box_delta_x, (delta_y * count) + box_delta_y, pb_x + box_delta_x, (delta_y * count) + box_delta_y)
            Next

            'paint vertical lines
            'delta_x = pb_x / div_x

            For count = 0 To div_x
                grafx.DrawLine(myPen2, (delta_x * count) + box_delta_x, box_delta_y, (delta_x * count) + box_delta_x, pb_y + box_delta_y)
 
                fs = xAchse(df * (HScrollBar1.Value - 1) + fn / (div_x * fft_Dehnen_Value) * count, fn, DimResult)
                TextSize = grafx.MeasureString(fs, drawFont)
                If count < div_x Then
                    grafx.DrawString(fs, drawFont, Brushes.Black, (delta_x * count) + box_delta_x - TextSize.Width / 2, pb_y + box_delta_y + 2)
                Else
                    grafx.DrawString(fs + DimResult, drawFont, Brushes.Black, (delta_x * count) + box_delta_x - 3 - TextSize.Width / 2, pb_y + box_delta_y + 2)
                End If
            Next
            If maxvalue = 0 Then
                maxvalue = 1
            End If

            Calculate_fft()

            delta_y1 = pb_y / maxvalue
            delta_x1 = pb_x * fft_Dehnen_Value / N05fft

            pb_y = 520 - box_delta_y
            f1 = df * smax
            TextSize = grafx.MeasureString(FormatFrequenz(f1), drawFont)
            grafx.DrawString(FormatFrequenz(f1), drawFont, Brushes.DarkGray, CInt((delta_x1 * (smax - HScrollBar1.Value + 1)) + box_delta_x - TextSize.Width / 2), pb_y + TextSize.Height + 2)
            'paint data line - HeaderLength wurde bei DatFFT() bereits herausgenommen
            For count = 1 To N05fft \ fft_Dehnen_Value
                i = count + HScrollBar1.Value - 1
                grafx.DrawLine(myPen1, (count * delta_x1) - delta_x1 + box_delta_x, pb_y - DatFFT(i - 1) * delta_y1, (count * delta_x1) + box_delta_x, pb_y - DatFFT(i) * delta_y1)
            Next

        Else
            '===================================================='paint horizontal lines
            For count = 0 To div_y
                If count = 5 Then
                    grafx.DrawLine(myPen3, box_delta_x, (delta_y * count) + box_delta_y, pb_x + box_delta_x, (delta_y * count) + box_delta_y)
                Else
                    grafx.DrawLine(myPen2, box_delta_x, (delta_y * count) + box_delta_y, pb_x + box_delta_x, (delta_y * count) + box_delta_y)
                End If
            Next

            'paint vertical lines
            For count = 0 To div_x
                If count = 6 Then
                    grafx.DrawLine(myPen3, (delta_x * count) + box_delta_x, box_delta_y, (delta_x * count) + box_delta_x, pb_y + box_delta_y)
                Else
                    grafx.DrawLine(myPen2, (delta_x * count) + box_delta_x, box_delta_y, (delta_x * count) + box_delta_x, pb_y + box_delta_y)
                End If
            Next

            'paint data line
            For count = 1 To Time_Bytes_Print 'RX_DATA
                i = (count * (varDIV_loop)) - (varDIV_loop) + HeaderLength + HScrollBar1.Value
                grafx.DrawLine(myPen1, ((count) * delta_x1) - delta_x1 + box_delta_x, (255 - Data(i)) * UssGr_corr * delta_y1 + box_delta_y, (count * delta_x1) + box_delta_x, (255 - Data(i + varDIV_loop)) * UssGr_corr * delta_y1 + box_delta_y)
            Next
        End If
        myPen1.Dispose()
        myPen2.Dispose()
        myPen3.Dispose()
    End Sub

    Private Sub TrackBar_Trigger_Scroll(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles TrackBar_Trigger.Scroll
        If hold Then
            TrackBar_Trigger.Value = trigoff
        End If
        set_triggeroff()
    End Sub
    Private Sub set_triggeroff()
        If SerialPort1.IsOpen = True Then
            trigoff = TrackBar_Trigger.Value
            Try
                SerialPort1.Write("TRIGOFF")
                SerialPort1.Write(Str(trigoff))
                SerialPort1.Write(Chr(13))
            Catch
                Exit Try
            End Try
        End If
    End Sub

    Private Sub Button_Tr_pos_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button_Tr_pos.Click
        If Not (Switch_hold) Then
            set_trigfl()
        End If
    End Sub
    Private Sub set_trigfl()
        If SerialPort1.IsOpen = True Then
            Button_Tr_pos.BackColor = Color.LightGreen()
            Button_Tr_neg.BackColor = SystemColors.Control
            TrigPos = True
            Try
                SerialPort1.Write("TRIGFH")
                SerialPort1.Write(Chr(13))
            Catch
                Exit Try
            End Try
        End If
    End Sub

    Private Sub Button_Tr_neg_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button_Tr_neg.Click
        If Not (Switch_hold) Then
            set_trigfh()
        End If
    End Sub
    Private Sub set_trigfh()
        If SerialPort1.IsOpen = True Then
            Button_Tr_neg.BackColor = Color.LightGreen()
            Button_Tr_pos.BackColor = SystemColors.Control
            TrigPos = False
            Try
                SerialPort1.Write("TRIGFL")
                SerialPort1.Write(Chr(13))
            Catch
                Exit Try
            End Try
        End If
    End Sub

    Private Sub TrackBar_Trigger_delay_Scroll(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles TrackBar_Trigger_delay.Scroll
        set_trigger_delay()
    End Sub
    Private Sub set_trigger_delay()
        If SerialPort1.IsOpen = True Then
            TimeLineData(TL_1) = TimeLineData(TL_1) + (TrackBar_Trigger_delay.Value - trigger_delay) * trigger_vz
            TimeLineData(TL_2) = TimeLineData(TL_2) + (TrackBar_Trigger_delay.Value - trigger_delay) * trigger_vz
            trigger_delay = TrackBar_Trigger_delay.Value
            Try
                SerialPort1.Write("TRIGDEL")
                SerialPort1.Write(Str(trigger_delay))
                SerialPort1.Write(Chr(13))
            Catch
                Exit Try
            End Try
            If (trigger_delay > 0) Then
                GroupBox_TriggerDelay.ForeColor = Color.Red
            Else
                GroupBox_TriggerDelay.ForeColor = SystemColors.ControlText
            End If
            'Write_Spectrum()
        End If
    End Sub

    Private Sub Button_Tr_prev_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button_Tr_prev.Click
        set_trigger_prev()
    End Sub
    Private Sub set_trigger_prev()
        If SerialPort1.IsOpen = True Then
            If trigger_prev Then
                If sync_plus Then
                    sync_plus = False
                    Button_Tr_prev.ForeColor = SystemColors.ControlText
                    Try
                        SerialPort1.Write("NSYNCP")
                        SerialPort1.Write(Chr(13))
                    Catch
                        Exit Try
                    End Try
                Else
                    sync_plus = True 'nur bei Synchronisation Datenbertragung
                    Button_Tr_prev.ForeColor = Color.Yellow
                    Try
                        SerialPort1.Write("SYNCP")
                        SerialPort1.Write(Chr(13))
                    Catch
                        Exit Try
                    End Try
                End If
            Else
                sync_plus = False
                Button_Tr_prev.ForeColor = SystemColors.ControlText
                Button_Tr_delay.ForeColor = SystemColors.ControlText
                Try
                    SerialPort1.Write("NSYNCP")
                    SerialPort1.Write(Chr(13))
                Catch
                    Exit Try
                End Try
                trigger_prev = True
                trigger_vz = 1
            End If
            Button_Tr_prev.BackColor = Color.LightGreen()
            Button_Tr_delay.BackColor = SystemColors.Control
            Try
                SerialPort1.Write("TRPREV")
                SerialPort1.Write(Chr(13))
            Catch
                Exit Try
            End Try
        End If
    End Sub

    Private Sub Button_Tr_delay_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button_Tr_delay.Click
        set_trigger_del()
    End Sub
    Private Sub set_trigger_del()
        If SerialPort1.IsOpen = True Then
            If Not (trigger_prev) Then
                If sync_plus Then
                    sync_plus = False
                    Button_Tr_delay.ForeColor = SystemColors.ControlText
                    Try
                        SerialPort1.Write("NSYNCP")
                        SerialPort1.Write(Chr(13))
                    Catch
                        Exit Try
                    End Try
                Else
                    sync_plus = True 'nur bei Synchronisation Datenbertragung
                    Button_Tr_delay.ForeColor = Color.Yellow
                    Try
                        SerialPort1.Write("SYNCP")
                        SerialPort1.Write(Chr(13))
                    Catch
                        Exit Try
                    End Try
                End If
            Else
                sync_plus = False
                Button_Tr_delay.ForeColor = SystemColors.ControlText
                Button_Tr_prev.ForeColor = SystemColors.ControlText
                Try
                    SerialPort1.Write("NSYNCP")
                    SerialPort1.Write(Chr(13))
                Catch
                    Exit Try
                End Try
                trigger_prev = False
                trigger_vz = -1
            End If
            Button_Tr_delay.BackColor = Color.LightGreen()
            Button_Tr_prev.BackColor = SystemColors.Control
            Try
                SerialPort1.Write("TRDEL")
                SerialPort1.Write(Chr(13))
            Catch
                Exit Try
            End Try
        End If
    End Sub

    Private Sub Button_Hold_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button_Hold.Click
        If Not fft_on Then
            set_hold()
        End If
    End Sub
    Private Sub set_hold()
        If SerialPort1.IsOpen = True Then
            If Switch_hold Then
                Switch_hold = False
                hold = False
                varDIV_loop = 1        'so kann in Write_Spectrum() gleiches 'paint data line verwendet werden
                HScrollBar1.Value = 1  'so kann in Write_Spectrum() gleiches 'paint data line verwendet werden
                TP_DIV_loop = DIV_loop + 1
                Time_print()
                Button_Hold.BackColor = SystemColors.Control
                HScrollBar1.Visible = False
                GroupBox_Dehnen.Visible = False
                GroupBox_Dehnen.ForeColor = SystemColors.ControlText
                If trigger_ram Then
                    GroupBox_TriggerDelay.Visible = True
                End If
                GroupBox_Y_Pos.Visible = True
                TimeLineData(TL_1) = HeaderLength + 1
                TimeLineData(TL_2) = HeaderLength + 1
                If Not (sync_plus) Then
                    sync_plus = False 'nur bei Synchronisation Datenbertragung
                    Try
                        SerialPort1.Write("NSYNCP")
                        SerialPort1.Write(Chr(13))
                    Catch
                        Exit Try
                    End Try
                End If
                Try
                    SerialPort1.Write("NHOLD")
                    SerialPort1.Write(Chr(13))
                Catch
                    Exit Try
                End Try
                Button_Hold.BackColor = SystemColors.Control
            Else
                Switch_hold = True
                Button_Hold.BackColor = Color.LightGreen()
                HScrollBar1.Maximum = RAM_size - (((Time_Bytes_Print + 1) * (DIV_loop + 1)) - (DIV_loop + 1)) - 11 ' 10 besteht aus HeaderLength und 6 welche weniger gelesen werden
                Try
                    SerialPort1.Write("SYNCP") 'bei Hold immer sync_plus verwenden, aber nicht merken
                    SerialPort1.Write(Chr(13))
                    SerialPort1.Write("HOLD")
                    SerialPort1.Write(Chr(13))
                    SerialPort1.Write("HOLDRAM")
                    SerialPort1.Write(Chr(13))
                Catch
                    Exit Try
                End Try
            End If
        End If
    End Sub

    Private Sub Button_TrMode_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button_TrMode.Click
        set_TrMode()
    End Sub
    Private Sub set_TrMode()
        If SerialPort1.IsOpen = True Then
            If Not (Switch_hold) And Not (fft_on) Then
                If trigger_ram Then
                    trigger_ram = False
                    Button_TrMode.Text = "Top"
                    LinkLabel_TrHinweis.Text = "Triggerpunkt" + Chr(13) + "am RAM-Anfang"
                    GroupBox_TriggerDelay.Visible = False
                    acc_delay = 0
                    If Time_div_set >= acc_border Then
                        GroupBox_Spur.Visible = True
                    End If
                    Try
                        SerialPort1.Write("ACC")
                        SerialPort1.Write(acc_delay)
                        SerialPort1.Write(Chr(13))
                        SerialPort1.Write("TRTRAM")
                        SerialPort1.Write(Chr(13))
                    Catch
                        Exit Try
                    End Try
                Else
                    trigger_ram = True
                    accelerate = False
                    GroupBox_Spur.Visible = False
                    Button_TrMode.Text = "RAM"
                    GroupBox_TriggerDelay.Visible = True
                    Button_Hold.Visible = True
                    Button_acc.Text = "slow"
                    LinkLabel_TrHinweis.Text = "Triggerpunkt" + Chr(13) + "im RAM-Bereich"
                    Try
                        SerialPort1.Write("TRRAM")
                        SerialPort1.Write(Chr(13))
                    Catch
                        Exit Try
                    End Try
                End If
            End If
            Try
                SerialPort1.DiscardInBuffer()
            Catch
            End Try
        End If
    End Sub

    Private Sub Button_acc_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button_acc.Click
        set_acc()
    End Sub
    Private Sub set_acc()
        If SerialPort1.IsOpen = True Then
            If accelerate Then
                accelerate = False
                acc_delay = 0
                Button_acc.Text = "slow"
                Button_Hold.Visible = True
                Try
                    SerialPort1.Write("ACC")
                    SerialPort1.Write(Str(acc_delay))
                    SerialPort1.Write(Chr(13))
                Catch
                    Exit Try
                End Try
            Else
                accelerate = True
                If Time_div_set >= acc_border Then
                    Button_Hold.Visible = False
                    acc_delay = Produkt_vTeilerSRate(DIV_teiler) * (DIV_loop + 1) * Time_Bytes_Print \ 1000000 + 1 ' gleich in ms + 1ms wegen Nachkommastellen
                    Button_acc.Text = "acc"
                    Try
                        SerialPort1.Write("ACC")
                        SerialPort1.Write(Str(acc_delay))
                        SerialPort1.Write(Chr(13))
                    Catch
                        Exit Try
                    End Try
                End If
            End If
            Try
                SerialPort1.DiscardInBuffer()
            Catch
            End Try
        End If
    End Sub

    Private Sub Button_TrMode_MouseLeave(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button_TrMode.MouseLeave
        LinkLabel_TrHinweis.Visible = False
    End Sub

    Private Sub Button_TrMode_MouseHover(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button_TrMode.MouseHover
        If SerialPort1.IsOpen = True Then
            If Not (hold) And (TrHinweis = "yes") Then
                LinkLabel_TrHinweis.Visible = True
            End If
        End If
    End Sub

    Private Sub Button_FFT_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button_FFT.Click
        If acc_delay = 0 Or Not (accelerate) Or fft_exp_sampels = 0 Then
            set_fft()
        End If
    End Sub
    Private Sub set_fft()
        Dim tmp_fft_exp_sampels As Byte

        If Not (Switch_hold) Then
            If fft_on Then
                fft_on = False
                HScrollBar1.Value = 1
                GroupBox_fft_Dehnen.Visible = False
                HScrollBar1.Visible = False
                If trigger_ram Then
                    GroupBox_TriggerDelay.Visible = True
                Else
                    If acc_border <= Time_div_set Then
                        GroupBox_Spur.Visible = True
                    End If
                End If
                GroupBox_Y_Pos.Visible = True
                Button_FFT.Text = "FFT"
                RX_Count = c_RX_Count + HeaderLength
                tmp_fft_exp_sampels = 0 ' in Firmware send_Data wieder mit loop
            Else
                fft_on = True
                GroupBox_TriggerDelay.Visible = False
                GroupBox_Y_Pos.Visible = False
                GroupBox_Spur.Visible = False
                GroupBox_fft_Dehnen.Visible = TrackBar_fft_Dehnen.Maximum > 1 ' entspricht If TrackBar_fft_Dehnen.Maximum > 1
                HScrollBar1.Maximum = N05fft + 1 - N05fft \ fft_Dehnen_Value  ' +1 - max darf nicht 0 sein
                HScrollBar1.Visible = (TrackBar_fft_Dehnen.Maximum > 1) And (fft_Dehnen_Value > 1)
                Button_FFT.Text = "Norm"
                TextBox_Cu_Zeit.Text = ""
                fft_init_values()
                If Nfft = 512 Then
                    RX_Count = c_RX_Count + HeaderLength
                Else
                    RX_Count = Nfft + HeaderLength
                End If
                tmp_fft_exp_sampels = fft_exp_sampels
            End If
            Try
                SerialPort1.Write("FFT")
                SerialPort1.Write(Str(tmp_fft_exp_sampels))
                SerialPort1.Write(Chr(13))
            Catch
                Exit Try
            End Try
            CalculateTime()
        End If
    End Sub

    Private Sub TrackBar_fft_Dehnen_Scroll(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles TrackBar_fft_Dehnen.Scroll
        fft_Dehnen_Value = TrackBar_fft_Dehnen.Maximum + 1 - TrackBar_fft_Dehnen.Value ' nur umgekhrte Wirkung von TrackBar
        If fft_Dehnen_Value > 1 Then
            HScrollBar1.Maximum = N05fft + 1 - N05fft \ fft_Dehnen_Value
            HScrollBar1.Visible = True
        Else
            HScrollBar1.Value = 1
            HScrollBar1.Visible = False
        End If
    End Sub

    Private Sub HScrollBar1_Scroll(ByVal sender As System.Object, ByVal e As System.Windows.Forms.ScrollEventArgs) Handles HScrollBar1.Scroll
        Write_Spectrum()
    End Sub

    Private Sub TrackBar_Dehnen_Scroll(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles TrackBar_Dehnen.Scroll
        Dim DimResult As String = ""
        Dim Result As Decimal
        varDIV_loop = TrackBar_Dehnen.Value
        TP_DIV_loop = varDIV_loop
        HScrollBar1.Maximum = RAM_size - (((Time_Bytes_Print + 1) * (varDIV_loop)) - (varDIV_loop)) - 11
        If (varDIV_loop < DIV_loop + 1) Then
            GroupBox_Dehnen.ForeColor = Color.Red
        Else
            GroupBox_Dehnen.ForeColor = SystemColors.ControlText
        End If
        Result = CalculateTimeDim(Produkt_vTeilerSRate(DIV_teiler) * varDIV_loop * Time_Bytes_Print / div_x, DimResult) 'x * 20ns in Func enthalten
        TextBox_Horizomtal.Text = FormatTimeDim(Result, DimResult)
        CalculateTime()
        Write_Spectrum()
    End Sub

    Private Sub CalculateTime()
        Dim pTime As Decimal
        Dim Result As Decimal
        Dim DimResult As String = ""
        If visbleTimeL Then
            If fft_on Then
                ' ...-1 , da HeaderLength 2 also 0 u. 1 - HscrollBar1.Value ist bereit in TimeLineData(TL_3) enthalten
                TextBox_Cu_Frequenz.Text = FormatFrequenz(Round((TimeLineData(TL_3) - HeaderLength - 1) * 100) / 100 * df)
            Else
                pTime = Abs(TimeLineData(TL_1) - TimeLineData(TL_2)) ' DIV_loop + 1 ist hier in VB2008 Software  x * 20ns in Func enthalten
                If Not (hold) Then
                    pTime = pTime * (DIV_loop + 1)   ' DIV_loop + 1 hineinrechnen, da in Firmware x * 20ns in Function enthalten
                End If
                pTime = pTime * Produkt_vTeilerSRate(DIV_teiler)
                Result = CalculateTimeDim(pTime, DimResult)
                TextBox_Cu_Zeit.Text = FormatTimeDim(Result, DimResult)
                Result = CalculateFrequDim(pTime, DimResult)
                TextBox_Cu_Frequenz.Text = FormatTimeDim(Result, DimResult)
            End If
        End If
    End Sub

    Public Function Produkt_vTeilerSRate(ByVal vTeiler As Integer) As Decimal
        Dim teiler As Integer
        Select Case vTeiler
            Case 0
                teiler = 1
            Case 1
                teiler = 32
            Case 2
                teiler = 256
            Case 3
                teiler = 2
        End Select
        Return (teiler * 20) ' 20ns
    End Function

    Private Function CalculateTimeDim(ByVal Result As Decimal, ByRef DimResult As String) As Decimal
        If Result < 1000 Then
            DimResult = " ns"
        Else
            Result = Result / 1000
            If Result < 1000 Then
                DimResult = " s"
            Else
                Result = Result / 1000
                DimResult = " ms"
            End If
        End If
        Return (Result)
    End Function

    Private Function CalculateFrequDim(ByVal Result As Decimal, ByRef DimResult As String) As Decimal
        If Result <> 0 Then
            Result = 1000 / Result
            If Result >= 1 Then
                DimResult = " MHz"
            Else
                Result = Result * 1000
                If Result >= 1 Then
                    DimResult = " KHz"
                Else
                    Result = Result * 1000
                    DimResult = " Hz"
                End If
            End If
        Else
            Result = 0
            DimResult = ""
        End If
        Return (Result)
    End Function

    Private Function FormatTimeDim(ByVal Time As Decimal, ByVal DimResult As String) As String
        Dim Result As String = ""
        If Time >= 100 Then
            Result = Format(Time + 0.0005, "0.00") + DimResult
        ElseIf Time >= 10 Then
            Result = Format(Time + 0.000005, "0.000") + DimResult
        ElseIf Time >= 1 Then
            Result = Format(Time + 0.000005, "0.000") + DimResult
        End If
        Return (Result)
    End Function

    Private Sub Form1_SizeChanged(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.SizeChanged
        CalculateTime()
        Write_Spectrum()
    End Sub

    Private Sub Form1_Move(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Move
        CalculateTime()
        Write_Spectrum()
    End Sub

    Private Sub Form1_FormClosing(ByVal sender As System.Object, ByVal e As System.Windows.Forms.FormClosingEventArgs) Handles MyBase.FormClosing
        Timer1.Stop()
        WriteIniValue(My.Application.Info.DirectoryPath & "\MyScope.ini", "Default", "Port", (SerialPort1.PortName()))
        WriteIniValue(My.Application.Info.DirectoryPath & "\MyScope.ini", "Scope", "Time-div", (Time_div_set))
        WriteIniValue(My.Application.Info.DirectoryPath & "\MyScope.ini", "Scope", "Time-Text", (TextBox_Horizomtal.Text))
        WriteIniValue(My.Application.Info.DirectoryPath & "\MyScope.ini", "Scope", "Triggervalue", (TrackBar_Trigger.Value))
        WriteIniValue(My.Application.Info.DirectoryPath & "\MyScope.ini", "Scope", "Y-Position", (TrackBar_YPos.Value))
        WriteIniValue(My.Application.Info.DirectoryPath & "\MyScope.ini", "Scope", "Trigger-Hinweis", (TrHinweis))
        'WriteIniValue(My.Application.Info.DirectoryPath & "\MyScope.ini", "Scope", "FFT-exp", (fft_exp_sampels))
        'WriteIniValue(My.Application.Info.DirectoryPath & "\MyScope.ini", "Scope", "Timer-Interval", (Timer1.Interval))
        'If Uss_Visible Then
        'WriteIniValue(My.Application.Info.DirectoryPath & "\MyScope.ini", "Measurement-correction", "Uss-corr", (Uss_corr))
        'WriteIniValue(My.Application.Info.DirectoryPath & "\MyScope.ini", "Measurement-correction", "UssGraph-corr", (UssGr_corr))
        'End If
        'WriteIniValue(My.Application.Info.DirectoryPath & "\MyScope.ini", "Measurement-correction", "Y0-Line", (Y0_Line))
    End Sub


End Class
