﻿Option Strict Off
Option Explicit On
Imports System.Math
Module FFT
    Const N_max = 16384
    Public Nfft As Integer
    Public N05fft As Integer
    Dim N As Integer
    Public REX(N_max) As Double 'REX[ ] holds the real part of the frequency domain
    Public IMX(N_max) As Double 'IMX[ ] holds the imaginary part of the frequency domain
    Public DatFFT(N_max)
    Public smax As Decimal
    Public maxvalue As Double
    Public df, fn As Decimal

    Private Sub fft()

        'Const pi = 3.14159265 'Set constants

        Dim SR, SI, UR, UI, TR, TI As Double
        Dim NM1, ND2, M, K, LE, LE2, JM1, IP, J As Integer ', 
        'THE FAST FOURIER TRANSFORM
        'copyright © 1997-1999 by California Technical Publishing
        'published with  permission from Steven W Smith, www.dspguide.com
        'GUI by logix4u , www.logix4u.net
        'modified by logix4u, www.logix4.net
        'Upon entry, N% contains the number of points in the DFT, REX[ ] and
        'IMX[ ] contain the real and imaginary parts of the input. Upon return,
        'REX[ ] and IMX[ ] contain the DFT output. All signals run from 0 to N%-1.
        NM1 = N - 1
        ND2 = N \ 2
        M = CInt(Log(N) / Log(2))
        J = ND2
        '
        For i As Integer = 1 To N - 2 'Bit reversal sorting
            If i >= J Then GoTo 1190
            TR = REX(J)
            TI = IMX(J)
            REX(J) = REX(i)
            IMX(J) = IMX(i)
            REX(i) = TR
            IMX(i) = TI
1190:       K = ND2
1200:       If K > J Then GoTo 1240
            J = J - K
            K = K / 2
            GoTo 1200
1240:       J = J + K
        Next i
        '
        For L As Integer = 1 To M 'Loop for each stage
            LE = CInt(2 ^ L)
            LE2 = LE / 2
            UR = 1
            UI = 0
            SR = Cos(PI / LE2) 'Calculate sine & cosine values
            SI = -Sin(PI / LE2)
            For J = 1 To LE2 'Loop for each sub DFT
                JM1 = J - 1
                For i As Integer = JM1 To NM1 Step LE 'Loop for each butterfly
                    IP = i + LE2
                    TR = REX(IP) * UR - IMX(IP) * UI 'Butterfly calculation
                    TI = REX(IP) * UI + IMX(IP) * UR
                    REX(IP) = REX(i) - TR
                    IMX(IP) = IMX(i) - TI
                    REX(i) = REX(i) + TR
                    IMX(i) = IMX(i) + TI
                Next i
                TR = UR
                UR = TR * SR - UI * SI
                UI = TR * SI + UI * SR
            Next J
        Next L
        ' '

    End Sub

    Public Sub Calculate_fft()
        Dim cnt As Integer
        Dim NullLine As Byte


        'maxvalue = 0
        'minvalue = 255
        'entspricht Trigger Auto
        'For cnt = 0 To Nfft
        'If Data(cnt + HeaderLength + 1) > maxvalue Then
        'maxvalue = Data(cnt + HeaderLength + 1)
        'End If
        'If Data(cnt + HeaderLength + 1) < minvalue Then
        'minvalue = Data(cnt + HeaderLength + 1)
        'End If
        'Next
        'NullLine = (maxvalue - minvalue) / 2 + minvalue
        NullLine = Form1.trigoff
        maxvalue = 0
        For cnt = 0 To Nfft
            'REX[ ] holds the real part of the frequency domain
            REX(cnt) = (Form1.Data(cnt + Form1.HeaderLength + 1) - NullLine) / Form1.Uss_corr _
            * (0.5 - (0.5 * Cos(2 * PI * cnt / Nfft))) 'Fensterfunktion nach Hanning
            IMX(cnt) = 0
        Next
        N = Nfft 'wäre zwar Time_Bytes_Print, aber  N muss 2^x sein ; übertragen werden immer 650 Sampels
        fft()
        maxvalue = 0
        For cnt = 0 To N05fft
            DatFFT(cnt) = Sqrt(IMX(cnt) * IMX(cnt) + REX(cnt) * REX(cnt))
            If DatFFT(cnt) > maxvalue Then
                maxvalue = DatFFT(cnt)
                smax = cnt
            End If
        Next
    End Sub

    Public Function xAchse(ByVal Value As Decimal, ByVal fn As Decimal, ByRef DimResultat As String) As String
        If fn < 1000 Then
            DimResultat = " Hz"
        Else
            fn = fn / 1000
            If fn < 1000 Then
                Value = Value / 1000
                DimResultat = " KHz"
            Else
                fn = fn / 1000
                Value = Value / 1000000
                DimResultat = " MHz"
            End If
        End If
        Return (FormatxFDim(Value))
    End Function

    Public Function FormatFrequenz(ByVal Value As Decimal) As String
        Dim DimResultat As String

        If Value < 1000 Then
            DimResultat = " Hz"
        Else
            Value = Value / 1000
            If Value < 1000 Then
                DimResultat = " KHz"
            Else
                Value = Value / 1000
                DimResultat = " MHz"
            End If
        End If
        Return (FormatxFDim(Value) + (DimResultat))
    End Function

    Public Function FormatxFDim(ByVal Value As Decimal) As String
        Dim FString As String

        If Value = 0 Then
            FString = Format(Value, "0")
        ElseIf Form1.fft_exp_sampels > 1 Then
            If Value < 1 Then
                FString = Format(Value, "0.0000")
            ElseIf Value < 10 Then
                FString = Format(Value, "0.000")
            ElseIf Value < 100 Then
                FString = Format(Value, "0.00")
            Else
                FString = Format(Value, "0.0")
            End If
        ElseIf Value < 1 Then
            FString = Format(Value, "0.000")
        ElseIf Value < 10 Then
            FString = Format(Value, "0.00")
        ElseIf Value < 100 Then
            FString = Format(Value, "0.0")
        Else
            FString = Format(Value, "0.")
        End If
        Return (FString)
    End Function

End Module
