/* Primitives Kooperatives Multitasking

  teile aus http://my.execpc.com/CE/AC/geezer/osd/tasks/setjmp.c geklaut

*/

#include <stdio.h>
#include <errno.h>
#include "lpc210x.h"
#include "dev_cntrl.h"
#include "lpc_ioctl.h"
#include "lpc_sys.h"

#define set_bit(var, bit) ((var) |= (1 << (bit)))
#define clear_bit(var, bit) ((var) &= (unsigned)~(1 << (bit)))

#define bit_is_set(var, bit) ((var) & (1 << (bit)))
#define bit_is_clear(var, bit) !bit_is_set(var, bit)

/**** Device table.  List of device drivers for newlib.	****/
const struct device_table_entry *device_table[] = {
	&com1,	/* stdin  */
	&com1,	/* stdout */
	&com1,	/* stderr */
	0
};	/* end of list */

static void task0(void)
{
  volatile int a = 10;
  puts("hello from task 0 ");
  while(1)
  {
    schedule(); /* yield() */
    iprintf("task 0 says: a = %d (10)", a);
    //wait();
  }
}

static void task1(void)
{
  volatile int a = 20;
  puts("\tgreetz from task 1 ");
  while(1)
  {
    schedule(); /* yield() */
    iprintf("\ttask 1 says: a = %d (20)", a);
    //wait();
  }
}

int main( void)
{
  struct serial_param sp;
  unsigned int last_count;

  volatile unsigned i;
  unsigned adr;

  SetNativeSpeed(_impure_ptr, 14746uL);

  /* Desired serial line characteristics 9600,8n1			*/
  sp.baud = 115200uL;
  sp.length = UART_WORD_LEN_8;
  sp.parity = UART_PARITY_NONE;
  sp.stop = UART_STOP_BITS_1;

  clear_bit(PINSEL0, 14);
  clear_bit(PINSEL0, 15);

  set_bit(IODIR, 7);
  set_bit(IOCLR, 7);

  /*  Set up memory access, CPU and bus speeds.			*/
  SetMAM( _impure_ptr, 3u, MAM_full_enable);
  VPBControl(_impure_ptr, VPB_DIV1);
  SetDesiredSpeed(_impure_ptr, 60000);

  /*  Set up serial port to desired rate.				*/
  ioctl( fileno(stdout), UART_SETUP, &sp);

  /*  Start timer.						*/
  StartClock(_impure_ptr);

  puts( "Hello World\r\n");		/*  It's alive !!		*/

  puts( "Starting wait\r\n");

  last_count = GetUs();
  set_bit(IOSET, 7);

  tasks_init_task(0, task0);
  tasks_init_task(1, task1);
  
  tasks_schedule();
  
}
