/* Primitives Kooperatives Multitasking

  teile aus http://my.execpc.com/CE/AC/geezer/osd/tasks/setjmp.c geklaut

*/

#include <setjmp.h>

#define bit_is_set(var, bit) ((var) & (1 << (bit)))
#define bit_is_clear(var, bit) !bit_is_set(var, bit)

#define NUM_TASKS 2
#define STACK_SIZE  512

/* die folgenden werte wurden hm... experimentell bestimmt */
#define JMPBUF_IP state[10]
#define JMPBUF_SP state[9]

typedef struct
{
  jmp_buf state;
} task_t;

static task_t g_tasks[NUM_TASKS + 1];
static char stacks[NUM_TASKS][STACK_SIZE];


void tasks_schedule(void)
{
  static unsigned current = NUM_TASKS;
  unsigned prev;

  prev = current;
  /* round-robin switch to next task */
  current++;
  if(current >= NUM_TASKS)
  {
    current = 0;
  }
  
  /* save old task state
  setjmp() returning nonzero means we came here through hyperspace
  from the longjmp() below -- just return */
  if(setjmp(g_tasks[prev].state) != 0)
  {
    return;
  }
  
  /* load new task state */
  longjmp(g_tasks[current].state, 1);
}

void tasks_init_task(unsigned function)
{
  unsigned adr;
  static unsigned int num;

  /* set all registers of task state */
  setjmp(g_tasks[num].state);
  adr = (unsigned)(stacks[num] + STACK_SIZE);
  /* set SP of task state */
  g_tasks[num].JMPBUF_IP = function;

  num ++;
}
